/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.GameRules;

public class CustomFunctionData {
    private static final IChatBaseComponent NO_RECURSIVE_TRACES = new ChatMessage("commands.debug.function.noRecursion");
    private static final MinecraftKey TICK_FUNCTION_TAG = new MinecraftKey("tick");
    private static final MinecraftKey LOAD_FUNCTION_TAG = new MinecraftKey("load");
    final MinecraftServer server;
    @Nullable
    private a context;
    private List<CustomFunction> ticking = ImmutableList.of();
    private boolean postReload;
    private CustomFunctionManager library;

    public CustomFunctionData(MinecraftServer var0, CustomFunctionManager var1) {
        this.server = var0;
        this.library = var1;
        this.postReload(var1);
    }

    public int getCommandLimit() {
        return this.server.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH);
    }

    public CommandDispatcher<CommandListenerWrapper> getDispatcher() {
        return this.server.getCommands().getDispatcher();
    }

    public void tick() {
        this.executeTagFunctions(this.ticking, TICK_FUNCTION_TAG);
        if (this.postReload) {
            this.postReload = false;
            List<CustomFunction> var0 = this.library.getTags().getTagOrEmpty(LOAD_FUNCTION_TAG).getValues();
            this.executeTagFunctions(var0, LOAD_FUNCTION_TAG);
        }
    }

    private void executeTagFunctions(Collection<CustomFunction> var0, MinecraftKey var1) {
        this.server.getProfiler().push(var1::toString);
        for (CustomFunction var3 : var0) {
            this.execute(var3, this.getGameLoopSender());
        }
        this.server.getProfiler().pop();
    }

    public int execute(CustomFunction var0, CommandListenerWrapper var1) {
        return this.execute(var0, var1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(CustomFunction var0, CommandListenerWrapper var1, @Nullable c var2) {
        if (this.context != null) {
            if (var2 != null) {
                this.context.reportError(NO_RECURSIVE_TRACES.getString());
                return 0;
            }
            this.context.delayFunctionCall(var0, var1);
            return 0;
        }
        try {
            this.context = new a(var2);
            int n2 = this.context.runTopCommand(var0, var1);
            return n2;
        }
        finally {
            this.context = null;
        }
    }

    public void replaceLibrary(CustomFunctionManager var0) {
        this.library = var0;
        this.postReload(var0);
    }

    private void postReload(CustomFunctionManager var0) {
        this.ticking = ImmutableList.copyOf(var0.getTags().getTagOrEmpty(TICK_FUNCTION_TAG).getValues());
        this.postReload = true;
    }

    public CommandListenerWrapper getGameLoopSender() {
        return this.server.createCommandSourceStack().withPermission(2).withSuppressedOutput();
    }

    public Optional<CustomFunction> get(MinecraftKey var0) {
        return this.library.getFunction(var0);
    }

    public Tag<CustomFunction> getTag(MinecraftKey var0) {
        return this.library.getTag(var0);
    }

    public Iterable<MinecraftKey> getFunctionNames() {
        return this.library.getFunctions().keySet();
    }

    public Iterable<MinecraftKey> getTagNames() {
        return this.library.getTags().getAvailableTags();
    }

    public static interface c {
        public void onCommand(int var1, String var2);

        public void onReturn(int var1, String var2, int var3);

        public void onError(int var1, String var2);

        public void onCall(int var1, MinecraftKey var2, int var3);
    }

    class a {
        private int depth;
        @Nullable
        private final c tracer;
        private final Deque<b> commandQueue = Queues.newArrayDeque();
        private final List<b> nestedCalls = Lists.newArrayList();

        a(c var1) {
            this.tracer = var1;
        }

        void delayFunctionCall(CustomFunction var0, CommandListenerWrapper var1) {
            int var2 = CustomFunctionData.this.getCommandLimit();
            if (this.commandQueue.size() + this.nestedCalls.size() < var2) {
                this.nestedCalls.add(new b(var1, this.depth, new CustomFunction.d(var0)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int runTopCommand(CustomFunction var0, CommandListenerWrapper var1) {
            int var2 = CustomFunctionData.this.getCommandLimit();
            int var3 = 0;
            CustomFunction.c[] var4 = var0.getEntries();
            for (int var5 = var4.length - 1; var5 >= 0; --var5) {
                this.commandQueue.push(new b(var1, 0, var4[var5]));
            }
            while (!this.commandQueue.isEmpty()) {
                try {
                    b var5 = this.commandQueue.removeFirst();
                    CustomFunctionData.this.server.getProfiler().push(var5::toString);
                    this.depth = var5.depth;
                    var5.execute(CustomFunctionData.this, this.commandQueue, var2, this.tracer);
                    if (!this.nestedCalls.isEmpty()) {
                        Lists.reverse(this.nestedCalls).forEach(this.commandQueue::addFirst);
                        this.nestedCalls.clear();
                    }
                }
                finally {
                    CustomFunctionData.this.server.getProfiler().pop();
                }
                if (++var3 < var2) continue;
                return var3;
            }
            return var3;
        }

        public void reportError(String var0) {
            if (this.tracer != null) {
                this.tracer.onError(this.depth, var0);
            }
        }
    }

    public static class b {
        private final CommandListenerWrapper sender;
        final int depth;
        private final CustomFunction.c entry;

        public b(CommandListenerWrapper var0, int var1, CustomFunction.c var2) {
            this.sender = var0;
            this.depth = var1;
            this.entry = var2;
        }

        public void execute(CustomFunctionData var0, Deque<b> var1, int var2, @Nullable c var3) {
            block4: {
                try {
                    this.entry.execute(var0, this.sender, var1, var2, this.depth, var3);
                }
                catch (CommandSyntaxException var4) {
                    if (var3 != null) {
                        var3.onError(this.depth, var4.getRawMessage().getString());
                    }
                }
                catch (Exception var4) {
                    if (var3 == null) break block4;
                    var3.onError(this.depth, var4.getMessage());
                }
            }
        }

        public String toString() {
            return this.entry.toString();
        }
    }
}

