/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.util.RegistryID;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class DataWatcherRegistry {
    private static final RegistryID<DataWatcherSerializer<?>> SERIALIZERS = RegistryID.create(16);
    public static final DataWatcherSerializer<Byte> BYTE = new DataWatcherSerializer<Byte>(){

        @Override
        public void write(PacketDataSerializer var0, Byte var1) {
            var0.writeByte(var1.byteValue());
        }

        @Override
        public Byte read(PacketDataSerializer var0) {
            return var0.readByte();
        }

        @Override
        public Byte copy(Byte var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Integer> INT = new DataWatcherSerializer<Integer>(){

        @Override
        public void write(PacketDataSerializer var0, Integer var1) {
            var0.writeVarInt(var1);
        }

        @Override
        public Integer read(PacketDataSerializer var0) {
            return var0.readVarInt();
        }

        @Override
        public Integer copy(Integer var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Float> FLOAT = new DataWatcherSerializer<Float>(){

        @Override
        public void write(PacketDataSerializer var0, Float var1) {
            var0.writeFloat(var1.floatValue());
        }

        @Override
        public Float read(PacketDataSerializer var0) {
            return Float.valueOf(var0.readFloat());
        }

        @Override
        public Float copy(Float var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<String> STRING = new DataWatcherSerializer<String>(){

        @Override
        public void write(PacketDataSerializer var0, String var1) {
            var0.writeUtf(var1);
        }

        @Override
        public String read(PacketDataSerializer var0) {
            return var0.readUtf();
        }

        @Override
        public String copy(String var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<IChatBaseComponent> COMPONENT = new DataWatcherSerializer<IChatBaseComponent>(){

        @Override
        public void write(PacketDataSerializer var0, IChatBaseComponent var1) {
            var0.writeComponent(var1);
        }

        @Override
        public IChatBaseComponent read(PacketDataSerializer var0) {
            return var0.readComponent();
        }

        @Override
        public IChatBaseComponent copy(IChatBaseComponent var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Optional<IChatBaseComponent>> OPTIONAL_COMPONENT = new DataWatcherSerializer<Optional<IChatBaseComponent>>(){

        @Override
        public void write(PacketDataSerializer var0, Optional<IChatBaseComponent> var1) {
            if (var1.isPresent()) {
                var0.writeBoolean(true);
                var0.writeComponent(var1.get());
            } else {
                var0.writeBoolean(false);
            }
        }

        @Override
        public Optional<IChatBaseComponent> read(PacketDataSerializer var0) {
            return var0.readBoolean() ? Optional.of(var0.readComponent()) : Optional.empty();
        }

        @Override
        public Optional<IChatBaseComponent> copy(Optional<IChatBaseComponent> var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<ItemStack> ITEM_STACK = new DataWatcherSerializer<ItemStack>(){

        @Override
        public void write(PacketDataSerializer var0, ItemStack var1) {
            var0.writeItem(var1);
        }

        @Override
        public ItemStack read(PacketDataSerializer var0) {
            return var0.readItem();
        }

        @Override
        public ItemStack copy(ItemStack var0) {
            return var0.copy();
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Optional<IBlockData>> BLOCK_STATE = new DataWatcherSerializer<Optional<IBlockData>>(){

        @Override
        public void write(PacketDataSerializer var0, Optional<IBlockData> var1) {
            if (var1.isPresent()) {
                var0.writeVarInt(Block.getId(var1.get()));
            } else {
                var0.writeVarInt(0);
            }
        }

        @Override
        public Optional<IBlockData> read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            if (var1 == 0) {
                return Optional.empty();
            }
            return Optional.of(Block.stateById(var1));
        }

        @Override
        public Optional<IBlockData> copy(Optional<IBlockData> var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Boolean> BOOLEAN = new DataWatcherSerializer<Boolean>(){

        @Override
        public void write(PacketDataSerializer var0, Boolean var1) {
            var0.writeBoolean(var1);
        }

        @Override
        public Boolean read(PacketDataSerializer var0) {
            return var0.readBoolean();
        }

        @Override
        public Boolean copy(Boolean var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<ParticleParam> PARTICLE = new DataWatcherSerializer<ParticleParam>(){

        @Override
        public void write(PacketDataSerializer var0, ParticleParam var1) {
            var0.writeVarInt(IRegistry.PARTICLE_TYPE.getId(var1.getType()));
            var1.writeToNetwork(var0);
        }

        @Override
        public ParticleParam read(PacketDataSerializer var0) {
            return this.readParticle(var0, (Particle)IRegistry.PARTICLE_TYPE.byId(var0.readVarInt()));
        }

        private <T extends ParticleParam> T readParticle(PacketDataSerializer var0, Particle<T> var1) {
            return var1.getDeserializer().fromNetwork(var1, var0);
        }

        @Override
        public ParticleParam copy(ParticleParam var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Vector3f> ROTATIONS = new DataWatcherSerializer<Vector3f>(){

        @Override
        public void write(PacketDataSerializer var0, Vector3f var1) {
            var0.writeFloat(var1.getX());
            var0.writeFloat(var1.getY());
            var0.writeFloat(var1.getZ());
        }

        @Override
        public Vector3f read(PacketDataSerializer var0) {
            return new Vector3f(var0.readFloat(), var0.readFloat(), var0.readFloat());
        }

        @Override
        public Vector3f copy(Vector3f var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<BlockPosition> BLOCK_POS = new DataWatcherSerializer<BlockPosition>(){

        @Override
        public void write(PacketDataSerializer var0, BlockPosition var1) {
            var0.writeBlockPos(var1);
        }

        @Override
        public BlockPosition read(PacketDataSerializer var0) {
            return var0.readBlockPos();
        }

        @Override
        public BlockPosition copy(BlockPosition var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Optional<BlockPosition>> OPTIONAL_BLOCK_POS = new DataWatcherSerializer<Optional<BlockPosition>>(){

        @Override
        public void write(PacketDataSerializer var0, Optional<BlockPosition> var1) {
            var0.writeBoolean(var1.isPresent());
            if (var1.isPresent()) {
                var0.writeBlockPos(var1.get());
            }
        }

        @Override
        public Optional<BlockPosition> read(PacketDataSerializer var0) {
            if (!var0.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(var0.readBlockPos());
        }

        @Override
        public Optional<BlockPosition> copy(Optional<BlockPosition> var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<EnumDirection> DIRECTION = new DataWatcherSerializer<EnumDirection>(){

        @Override
        public void write(PacketDataSerializer var0, EnumDirection var1) {
            var0.writeEnum(var1);
        }

        @Override
        public EnumDirection read(PacketDataSerializer var0) {
            return var0.readEnum(EnumDirection.class);
        }

        @Override
        public EnumDirection copy(EnumDirection var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<Optional<UUID>> OPTIONAL_UUID = new DataWatcherSerializer<Optional<UUID>>(){

        @Override
        public void write(PacketDataSerializer var0, Optional<UUID> var1) {
            var0.writeBoolean(var1.isPresent());
            if (var1.isPresent()) {
                var0.writeUUID(var1.get());
            }
        }

        @Override
        public Optional<UUID> read(PacketDataSerializer var0) {
            if (!var0.readBoolean()) {
                return Optional.empty();
            }
            return Optional.of(var0.readUUID());
        }

        @Override
        public Optional<UUID> copy(Optional<UUID> var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<NBTTagCompound> COMPOUND_TAG = new DataWatcherSerializer<NBTTagCompound>(){

        @Override
        public void write(PacketDataSerializer var0, NBTTagCompound var1) {
            var0.writeNbt(var1);
        }

        @Override
        public NBTTagCompound read(PacketDataSerializer var0) {
            return var0.readNbt();
        }

        @Override
        public NBTTagCompound copy(NBTTagCompound var0) {
            return var0.copy();
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<VillagerData> VILLAGER_DATA = new DataWatcherSerializer<VillagerData>(){

        @Override
        public void write(PacketDataSerializer var0, VillagerData var1) {
            var0.writeVarInt(IRegistry.VILLAGER_TYPE.getId(var1.getType()));
            var0.writeVarInt(IRegistry.VILLAGER_PROFESSION.getId(var1.getProfession()));
            var0.writeVarInt(var1.getLevel());
        }

        @Override
        public VillagerData read(PacketDataSerializer var0) {
            return new VillagerData(IRegistry.VILLAGER_TYPE.byId(var0.readVarInt()), IRegistry.VILLAGER_PROFESSION.byId(var0.readVarInt()), var0.readVarInt());
        }

        @Override
        public VillagerData copy(VillagerData var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<OptionalInt> OPTIONAL_UNSIGNED_INT = new DataWatcherSerializer<OptionalInt>(){

        @Override
        public void write(PacketDataSerializer var0, OptionalInt var1) {
            var0.writeVarInt(var1.orElse(-1) + 1);
        }

        @Override
        public OptionalInt read(PacketDataSerializer var0) {
            int var1 = var0.readVarInt();
            return var1 == 0 ? OptionalInt.empty() : OptionalInt.of(var1 - 1);
        }

        @Override
        public OptionalInt copy(OptionalInt var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };
    public static final DataWatcherSerializer<EntityPose> POSE = new DataWatcherSerializer<EntityPose>(){

        @Override
        public void write(PacketDataSerializer var0, EntityPose var1) {
            var0.writeEnum(var1);
        }

        @Override
        public EntityPose read(PacketDataSerializer var0) {
            return var0.readEnum(EntityPose.class);
        }

        @Override
        public EntityPose copy(EntityPose var0) {
            return var0;
        }

        @Override
        public /* synthetic */ Object read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    };

    public static void registerSerializer(DataWatcherSerializer<?> var0) {
        SERIALIZERS.add(var0);
    }

    @Nullable
    public static DataWatcherSerializer<?> getSerializer(int var0) {
        return SERIALIZERS.byId(var0);
    }

    public static int getSerializedId(DataWatcherSerializer<?> var0) {
        return SERIALIZERS.getId(var0);
    }

    private DataWatcherRegistry() {
    }

    static {
        DataWatcherRegistry.registerSerializer(BYTE);
        DataWatcherRegistry.registerSerializer(INT);
        DataWatcherRegistry.registerSerializer(FLOAT);
        DataWatcherRegistry.registerSerializer(STRING);
        DataWatcherRegistry.registerSerializer(COMPONENT);
        DataWatcherRegistry.registerSerializer(OPTIONAL_COMPONENT);
        DataWatcherRegistry.registerSerializer(ITEM_STACK);
        DataWatcherRegistry.registerSerializer(BOOLEAN);
        DataWatcherRegistry.registerSerializer(ROTATIONS);
        DataWatcherRegistry.registerSerializer(BLOCK_POS);
        DataWatcherRegistry.registerSerializer(OPTIONAL_BLOCK_POS);
        DataWatcherRegistry.registerSerializer(DIRECTION);
        DataWatcherRegistry.registerSerializer(OPTIONAL_UUID);
        DataWatcherRegistry.registerSerializer(BLOCK_STATE);
        DataWatcherRegistry.registerSerializer(COMPOUND_TAG);
        DataWatcherRegistry.registerSerializer(PARTICLE);
        DataWatcherRegistry.registerSerializer(VILLAGER_DATA);
        DataWatcherRegistry.registerSerializer(OPTIONAL_UNSIGNED_INT);
        DataWatcherRegistry.registerSerializer(POSE);
    }
}

