/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Type;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ChatDeserializer;

public class ServerPing {
    public static final int FAVICON_WIDTH = 64;
    public static final int FAVICON_HEIGHT = 64;
    @Nullable
    private IChatBaseComponent description;
    @Nullable
    private ServerPingPlayerSample players;
    @Nullable
    private ServerData version;
    @Nullable
    private String favicon;

    @Nullable
    public IChatBaseComponent getDescription() {
        return this.description;
    }

    public void setDescription(IChatBaseComponent var0) {
        this.description = var0;
    }

    @Nullable
    public ServerPingPlayerSample getPlayers() {
        return this.players;
    }

    public void setPlayers(ServerPingPlayerSample var0) {
        this.players = var0;
    }

    @Nullable
    public ServerData getVersion() {
        return this.version;
    }

    public void setVersion(ServerData var0) {
        this.version = var0;
    }

    public void setFavicon(String var0) {
        this.favicon = var0;
    }

    @Nullable
    public String getFavicon() {
        return this.favicon;
    }

    public static class ServerPingPlayerSample {
        private final int maxPlayers;
        private final int numPlayers;
        @Nullable
        private GameProfile[] sample;

        public ServerPingPlayerSample(int var0, int var1) {
            this.maxPlayers = var0;
            this.numPlayers = var1;
        }

        public int getMaxPlayers() {
            return this.maxPlayers;
        }

        public int getNumPlayers() {
            return this.numPlayers;
        }

        @Nullable
        public GameProfile[] getSample() {
            return this.sample;
        }

        public void setSample(GameProfile[] var0) {
            this.sample = var0;
        }

        public static class Serializer
        implements JsonDeserializer<ServerPingPlayerSample>,
        JsonSerializer<ServerPingPlayerSample> {
            public ServerPingPlayerSample deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
                JsonArray var5;
                JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "players");
                ServerPingPlayerSample var4 = new ServerPingPlayerSample(ChatDeserializer.getAsInt(var3, "max"), ChatDeserializer.getAsInt(var3, "online"));
                if (ChatDeserializer.isArrayNode(var3, "sample") && (var5 = ChatDeserializer.getAsJsonArray(var3, "sample")).size() > 0) {
                    GameProfile[] var6 = new GameProfile[var5.size()];
                    for (int var7 = 0; var7 < var6.length; ++var7) {
                        JsonObject var8 = ChatDeserializer.convertToJsonObject(var5.get(var7), "player[" + var7 + "]");
                        String var9 = ChatDeserializer.getAsString(var8, "id");
                        var6[var7] = new GameProfile(UUID.fromString(var9), ChatDeserializer.getAsString(var8, "name"));
                    }
                    var4.setSample(var6);
                }
                return var4;
            }

            public JsonElement serialize(ServerPingPlayerSample var0, Type var1, JsonSerializationContext var2) {
                JsonObject var3 = new JsonObject();
                var3.addProperty("max", (Number)var0.getMaxPlayers());
                var3.addProperty("online", (Number)var0.getNumPlayers());
                GameProfile[] var4 = var0.getSample();
                if (var4 != null && var4.length > 0) {
                    JsonArray var5 = new JsonArray();
                    for (int var6 = 0; var6 < var4.length; ++var6) {
                        JsonObject var7 = new JsonObject();
                        UUID var8 = var4[var6].getId();
                        var7.addProperty("id", var8 == null ? "" : var8.toString());
                        var7.addProperty("name", var4[var6].getName());
                        var5.add((JsonElement)var7);
                    }
                    var3.add("sample", (JsonElement)var5);
                }
                return var3;
            }

            public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
                return this.serialize((ServerPingPlayerSample)object, type, jsonSerializationContext);
            }

            public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return this.deserialize(jsonElement, type, jsonDeserializationContext);
            }
        }
    }

    public static class ServerData {
        private final String name;
        private final int protocol;

        public ServerData(String var0, int var1) {
            this.name = var0;
            this.protocol = var1;
        }

        public String getName() {
            return this.name;
        }

        public int getProtocol() {
            return this.protocol;
        }

        public static class Serializer
        implements JsonDeserializer<ServerData>,
        JsonSerializer<ServerData> {
            public ServerData deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
                JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "version");
                return new ServerData(ChatDeserializer.getAsString(var3, "name"), ChatDeserializer.getAsInt(var3, "protocol"));
            }

            public JsonElement serialize(ServerData var0, Type var1, JsonSerializationContext var2) {
                JsonObject var3 = new JsonObject();
                var3.addProperty("name", var0.getName());
                var3.addProperty("protocol", (Number)var0.getProtocol());
                return var3;
            }

            public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
                return this.serialize((ServerData)object, type, jsonSerializationContext);
            }

            public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return this.deserialize(jsonElement, type, jsonDeserializationContext);
            }
        }
    }

    public static class Serializer
    implements JsonDeserializer<ServerPing>,
    JsonSerializer<ServerPing> {
        public ServerPing deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "status");
            ServerPing var4 = new ServerPing();
            if (var3.has("description")) {
                var4.setDescription((IChatBaseComponent)var2.deserialize(var3.get("description"), IChatBaseComponent.class));
            }
            if (var3.has("players")) {
                var4.setPlayers((ServerPingPlayerSample)var2.deserialize(var3.get("players"), ServerPingPlayerSample.class));
            }
            if (var3.has("version")) {
                var4.setVersion((ServerData)var2.deserialize(var3.get("version"), ServerData.class));
            }
            if (var3.has("favicon")) {
                var4.setFavicon(ChatDeserializer.getAsString(var3, "favicon"));
            }
            return var4;
        }

        public JsonElement serialize(ServerPing var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            if (var0.getDescription() != null) {
                var3.add("description", var2.serialize((Object)var0.getDescription()));
            }
            if (var0.getPlayers() != null) {
                var3.add("players", var2.serialize((Object)var0.getPlayers()));
            }
            if (var0.getVersion() != null) {
                var3.add("version", var2.serialize((Object)var0.getVersion()));
            }
            if (var0.getFavicon() != null) {
                var3.addProperty("favicon", var0.getFavicon());
            }
            return var3;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ServerPing)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

