/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.Paintings;

public class PacketPlayOutSpawnEntityPainting
implements Packet<PacketListenerPlayOut> {
    private final int id;
    private final UUID uuid;
    private final BlockPosition pos;
    private final EnumDirection direction;
    private final int motive;

    public PacketPlayOutSpawnEntityPainting(EntityPainting var0) {
        this.id = var0.getId();
        this.uuid = var0.getUUID();
        this.pos = var0.getPos();
        this.direction = var0.getDirection();
        this.motive = IRegistry.MOTIVE.getId(var0.motive);
    }

    public PacketPlayOutSpawnEntityPainting(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.uuid = var0.readUUID();
        this.motive = var0.readVarInt();
        this.pos = var0.readBlockPos();
        this.direction = EnumDirection.from2DDataValue(var0.readUnsignedByte());
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeUUID(this.uuid);
        var0.writeVarInt(this.motive);
        var0.writeBlockPos(this.pos);
        var0.writeByte(this.direction.get2DDataValue());
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddPainting(this);
    }

    public int getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public EnumDirection getDirection() {
        return this.direction;
    }

    public Paintings getMotive() {
        return IRegistry.MOTIVE.byId(this.motive);
    }
}

