/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.scores.ScoreboardObjective;

public class PacketPlayOutScoreboardDisplayObjective
implements Packet<PacketListenerPlayOut> {
    private final int slot;
    private final String objectiveName;

    public PacketPlayOutScoreboardDisplayObjective(int var0, @Nullable ScoreboardObjective var1) {
        this.slot = var0;
        this.objectiveName = var1 == null ? "" : var1.getName();
    }

    public PacketPlayOutScoreboardDisplayObjective(PacketDataSerializer var0) {
        this.slot = var0.readByte();
        this.objectiveName = var0.readUtf();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeByte(this.slot);
        var0.writeUtf(this.objectiveName);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetDisplayObjective(this);
    }

    public int getSlot() {
        return this.slot;
    }

    @Nullable
    public String getObjectiveName() {
        return Objects.equals(this.objectiveName, "") ? null : this.objectiveName;
    }
}

