/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.RecipeBookSettings;

public class PacketPlayOutRecipes
implements Packet<PacketListenerPlayOut> {
    private final Action state;
    private final List<MinecraftKey> recipes;
    private final List<MinecraftKey> toHighlight;
    private final RecipeBookSettings bookSettings;

    public PacketPlayOutRecipes(Action var0, Collection<MinecraftKey> var1, Collection<MinecraftKey> var2, RecipeBookSettings var3) {
        this.state = var0;
        this.recipes = ImmutableList.copyOf(var1);
        this.toHighlight = ImmutableList.copyOf(var2);
        this.bookSettings = var3;
    }

    public PacketPlayOutRecipes(PacketDataSerializer var0) {
        this.state = var0.readEnum(Action.class);
        this.bookSettings = RecipeBookSettings.read(var0);
        this.recipes = var0.readList(PacketDataSerializer::readResourceLocation);
        this.toHighlight = this.state == Action.INIT ? var0.readList(PacketDataSerializer::readResourceLocation) : ImmutableList.of();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeEnum(this.state);
        this.bookSettings.write(var0);
        var0.writeCollection(this.recipes, PacketDataSerializer::writeResourceLocation);
        if (this.state == Action.INIT) {
            var0.writeCollection(this.toHighlight, PacketDataSerializer::writeResourceLocation);
        }
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddOrRemoveRecipes(this);
    }

    public List<MinecraftKey> getRecipes() {
        return this.recipes;
    }

    public List<MinecraftKey> getHighlights() {
        return this.toHighlight;
    }

    public RecipeBookSettings getBookSettings() {
        return this.bookSettings;
    }

    public Action getState() {
        return this.state;
    }

    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action INIT = new Action();
        public static final /* enum */ Action ADD = new Action();
        public static final /* enum */ Action REMOVE = new Action();
        private static final /* synthetic */ Action[] d;

        public static Action[] values() {
            return (Action[])d.clone();
        }

        public static Action valueOf(String var0) {
            return Enum.valueOf(Action.class, var0);
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{INIT, ADD, REMOVE};
        }

        static {
            d = Action.a();
        }
    }
}

