/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutCustomSoundEffect
implements Packet<PacketListenerPlayOut> {
    public static final float LOCATION_ACCURACY = 8.0f;
    private final MinecraftKey name;
    private final SoundCategory source;
    private final int x;
    private final int y;
    private final int z;
    private final float volume;
    private final float pitch;

    public PacketPlayOutCustomSoundEffect(MinecraftKey var0, SoundCategory var1, Vec3D var2, float var3, float var4) {
        this.name = var0;
        this.source = var1;
        this.x = (int)(var2.x * 8.0);
        this.y = (int)(var2.y * 8.0);
        this.z = (int)(var2.z * 8.0);
        this.volume = var3;
        this.pitch = var4;
    }

    public PacketPlayOutCustomSoundEffect(PacketDataSerializer var0) {
        this.name = var0.readResourceLocation();
        this.source = var0.readEnum(SoundCategory.class);
        this.x = var0.readInt();
        this.y = var0.readInt();
        this.z = var0.readInt();
        this.volume = var0.readFloat();
        this.pitch = var0.readFloat();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeResourceLocation(this.name);
        var0.writeEnum(this.source);
        var0.writeInt(this.x);
        var0.writeInt(this.y);
        var0.writeInt(this.z);
        var0.writeFloat(this.volume);
        var0.writeFloat(this.pitch);
    }

    public MinecraftKey getName() {
        return this.name;
    }

    public SoundCategory getSource() {
        return this.source;
    }

    public double getX() {
        return (float)this.x / 8.0f;
    }

    public double getY() {
        return (float)this.y / 8.0f;
    }

    public double getZ() {
        return (float)this.z / 8.0f;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCustomSoundEvent(this);
    }
}

