/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, WorldServer var2) throws CancelledPacketHandleException {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, var1, var2.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, IAsyncTaskHandler<?> var2) throws CancelledPacketHandleException {
        if (!var2.isSameThread()) {
            var2.execute(() -> {
                if (var1.getConnection().isConnected()) {
                    var0.handle(var1);
                } else {
                    LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)var0);
                }
            });
            throw CancelledPacketHandleException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }
}

