/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessageException;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;

public class ChatMessage
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final Object[] NO_ARGS = new Object[0];
    private static final IChatFormatted TEXT_PERCENT = IChatFormatted.of("%");
    private static final IChatFormatted TEXT_NULL = IChatFormatted.of("null");
    private final String key;
    private final Object[] args;
    @Nullable
    private LocaleLanguage decomposedWith;
    private final List<IChatFormatted> decomposedParts = Lists.newArrayList();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ChatMessage(String var0) {
        this.key = var0;
        this.args = NO_ARGS;
    }

    public ChatMessage(String var0, Object ... var1) {
        this.key = var0;
        this.args = var1;
    }

    private void decompose() {
        LocaleLanguage var0 = LocaleLanguage.getInstance();
        if (var0 == this.decomposedWith) {
            return;
        }
        this.decomposedWith = var0;
        this.decomposedParts.clear();
        String var1 = var0.getOrDefault(this.key);
        try {
            this.decomposeTemplate(var1);
        }
        catch (ChatMessageException var2) {
            this.decomposedParts.clear();
            this.decomposedParts.add(IChatFormatted.of(var1));
        }
    }

    private void decomposeTemplate(String var0) {
        Matcher var1 = FORMAT_PATTERN.matcher(var0);
        try {
            int var2 = 0;
            int var3 = 0;
            while (var1.find(var3)) {
                String var6;
                int var4 = var1.start();
                int var5 = var1.end();
                if (var4 > var3) {
                    var6 = var0.substring(var3, var4);
                    if (var6.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    this.decomposedParts.add(IChatFormatted.of(var6));
                }
                var6 = var1.group(2);
                String var7 = var0.substring(var4, var5);
                if ("%".equals(var6) && "%%".equals(var7)) {
                    this.decomposedParts.add(TEXT_PERCENT);
                } else if ("s".equals(var6)) {
                    int var9;
                    String var8 = var1.group(1);
                    int n2 = var9 = var8 != null ? Integer.parseInt(var8) - 1 : var2++;
                    if (var9 < this.args.length) {
                        this.decomposedParts.add(this.getArgument(var9));
                    }
                } else {
                    throw new ChatMessageException(this, "Unsupported format: '" + var7 + "'");
                }
                var3 = var5;
            }
            if (var3 < var0.length()) {
                String var4 = var0.substring(var3);
                if (var4.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                this.decomposedParts.add(IChatFormatted.of(var4));
            }
        }
        catch (IllegalArgumentException var2) {
            throw new ChatMessageException(this, (Throwable)var2);
        }
    }

    private IChatFormatted getArgument(int var0) {
        if (var0 >= this.args.length) {
            throw new ChatMessageException(this, var0);
        }
        Object var1 = this.args[var0];
        if (var1 instanceof IChatBaseComponent) {
            return (IChatBaseComponent)var1;
        }
        return var1 == null ? TEXT_NULL : IChatFormatted.of(var1.toString());
    }

    @Override
    public ChatMessage plainCopy() {
        return new ChatMessage(this.key, this.args);
    }

    @Override
    public <T> Optional<T> visitSelf(IChatFormatted.b<T> var0, ChatModifier var1) {
        this.decompose();
        for (IChatFormatted var3 : this.decomposedParts) {
            Optional<T> var4 = var3.visit(var0, var1);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> visitSelf(IChatFormatted.a<T> var0) {
        this.decompose();
        for (IChatFormatted var2 : this.decomposedParts) {
            Optional<T> var3 = var2.visit(var0);
            if (!var3.isPresent()) continue;
            return var3;
        }
        return Optional.empty();
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        Object[] var3 = new Object[this.args.length];
        for (int var4 = 0; var4 < var3.length; ++var4) {
            Object var5 = this.args[var4];
            var3[var4] = var5 instanceof IChatBaseComponent ? ChatComponentUtils.updateForEntity(var0, (IChatBaseComponent)var5, var1, var2) : var5;
        }
        return new ChatMessage(this.key, var3);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatMessage) {
            ChatMessage var1 = (ChatMessage)var0;
            return Arrays.equals(this.args, var1.args) && this.key.equals(var1.key) && super.equals(var0);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int var0 = super.hashCode();
        var0 = 31 * var0 + this.key.hashCode();
        var0 = 31 * var0 + Arrays.hashCode(this.args);
        return var0;
    }

    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.key + "', args=" + Arrays.toString(this.args) + ", siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArgs() {
        return this.args;
    }

    @Override
    public /* synthetic */ ChatBaseComponent plainCopy() {
        return this.plainCopy();
    }

    @Override
    public /* synthetic */ IChatMutableComponent plainCopy() {
        return this.plainCopy();
    }
}

