/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatBaseComponent;
import net.minecraft.network.chat.ChatComponentContextual;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChatComponentSelector
extends ChatBaseComponent
implements ChatComponentContextual {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String pattern;
    @Nullable
    private final EntitySelector selector;
    protected final Optional<IChatBaseComponent> separator;

    public ChatComponentSelector(String var0, Optional<IChatBaseComponent> var1) {
        this.pattern = var0;
        this.separator = var1;
        EntitySelector var2 = null;
        try {
            ArgumentParserSelector var3 = new ArgumentParserSelector(new StringReader(var0));
            var2 = var3.parse();
        }
        catch (CommandSyntaxException var3) {
            LOGGER.warn("Invalid selector component: {}: {}", (Object)var0, (Object)var3.getMessage());
        }
        this.selector = var2;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public Optional<IChatBaseComponent> getSeparator() {
        return this.separator;
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null || this.selector == null) {
            return new ChatComponentText("");
        }
        Optional<IChatMutableComponent> var3 = ChatComponentUtils.updateForEntity(var0, this.separator, var1, var2);
        return ChatComponentUtils.formatList(this.selector.findEntities(var0), var3, Entity::getDisplayName);
    }

    @Override
    public String getContents() {
        return this.pattern;
    }

    @Override
    public ChatComponentSelector plainCopy() {
        return new ChatComponentSelector(this.pattern, this.separator);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ChatComponentSelector) {
            ChatComponentSelector var1 = (ChatComponentSelector)var0;
            return this.pattern.equals(var1.pattern) && super.equals(var0);
        }
        return false;
    }

    @Override
    public String toString() {
        return "SelectorComponent{pattern='" + this.pattern + "', siblings=" + this.siblings + ", style=" + this.getStyle() + "}";
    }

    @Override
    public /* synthetic */ ChatBaseComponent plainCopy() {
        return this.plainCopy();
    }

    @Override
    public /* synthetic */ IChatMutableComponent plainCopy() {
        return this.plainCopy();
    }
}

