/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.data.worldgen.WorldGenFeatureBastionPieces;
import net.minecraft.data.worldgen.WorldGenFeatureDesertVillage;
import net.minecraft.data.worldgen.WorldGenFeaturePillagerOutpostPieces;
import net.minecraft.data.worldgen.WorldGenFeatureVillagePlain;
import net.minecraft.data.worldgen.WorldGenFeatureVillageSavanna;
import net.minecraft.data.worldgen.WorldGenFeatureVillageSnowy;
import net.minecraft.data.worldgen.WorldGenFeatureVillageTaiga;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRuinedPortal;
import net.minecraft.world.level.levelgen.feature.WorldGenMineshaft;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenMineshaftConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureOceanRuin;

public class StructureFeatures {
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> PILLAGER_OUTPOST = StructureFeatures.register("pillager_outpost", StructureGenerator.PILLAGER_OUTPOST.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeaturePillagerOutpostPieces.START, 7)));
    private static final StructureFeature<WorldGenMineshaftConfiguration, ? extends StructureGenerator<WorldGenMineshaftConfiguration>> MINESHAFT = StructureFeatures.register("mineshaft", StructureGenerator.MINESHAFT.configured(new WorldGenMineshaftConfiguration(0.004f, WorldGenMineshaft.Type.NORMAL)));
    private static final StructureFeature<WorldGenMineshaftConfiguration, ? extends StructureGenerator<WorldGenMineshaftConfiguration>> MINESHAFT_MESA = StructureFeatures.register("mineshaft_mesa", StructureGenerator.MINESHAFT.configured(new WorldGenMineshaftConfiguration(0.004f, WorldGenMineshaft.Type.MESA)));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> WOODLAND_MANSION = StructureFeatures.register("mansion", StructureGenerator.WOODLAND_MANSION.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> JUNGLE_TEMPLE = StructureFeatures.register("jungle_pyramid", StructureGenerator.JUNGLE_TEMPLE.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> DESERT_PYRAMID = StructureFeatures.register("desert_pyramid", StructureGenerator.DESERT_PYRAMID.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> IGLOO = StructureFeatures.register("igloo", StructureGenerator.IGLOO.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureShipwreckConfiguration, ? extends StructureGenerator<WorldGenFeatureShipwreckConfiguration>> SHIPWRECK = StructureFeatures.register("shipwreck", StructureGenerator.SHIPWRECK.configured(new WorldGenFeatureShipwreckConfiguration(false)));
    private static final StructureFeature<WorldGenFeatureShipwreckConfiguration, ? extends StructureGenerator<WorldGenFeatureShipwreckConfiguration>> SHIPWRECK_BEACHED = StructureFeatures.register("shipwreck_beached", StructureGenerator.SHIPWRECK.configured(new WorldGenFeatureShipwreckConfiguration(true)));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> SWAMP_HUT = StructureFeatures.register("swamp_hut", StructureGenerator.SWAMP_HUT.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    public static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> STRONGHOLD = StructureFeatures.register("stronghold", StructureGenerator.STRONGHOLD.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> OCEAN_MONUMENT = StructureFeatures.register("monument", StructureGenerator.OCEAN_MONUMENT.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureOceanRuinConfiguration, ? extends StructureGenerator<WorldGenFeatureOceanRuinConfiguration>> OCEAN_RUIN_COLD = StructureFeatures.register("ocean_ruin_cold", StructureGenerator.OCEAN_RUIN.configured(new WorldGenFeatureOceanRuinConfiguration(WorldGenFeatureOceanRuin.Temperature.COLD, 0.3f, 0.9f)));
    private static final StructureFeature<WorldGenFeatureOceanRuinConfiguration, ? extends StructureGenerator<WorldGenFeatureOceanRuinConfiguration>> OCEAN_RUIN_WARM = StructureFeatures.register("ocean_ruin_warm", StructureGenerator.OCEAN_RUIN.configured(new WorldGenFeatureOceanRuinConfiguration(WorldGenFeatureOceanRuin.Temperature.WARM, 0.3f, 0.9f)));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> NETHER_BRIDGE = StructureFeatures.register("fortress", StructureGenerator.NETHER_BRIDGE.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<RangeConfiguration, ? extends StructureGenerator<RangeConfiguration>> NETHER_FOSSIL = StructureFeatures.register("nether_fossil", StructureGenerator.NETHER_FOSSIL.configured(new RangeConfiguration(UniformHeight.of(VerticalAnchor.absolute(32), VerticalAnchor.belowTop(2)))));
    private static final StructureFeature<WorldGenFeatureEmptyConfiguration, ? extends StructureGenerator<WorldGenFeatureEmptyConfiguration>> END_CITY = StructureFeatures.register("end_city", StructureGenerator.END_CITY.configured(WorldGenFeatureEmptyConfiguration.INSTANCE));
    private static final StructureFeature<WorldGenFeatureConfigurationChance, ? extends StructureGenerator<WorldGenFeatureConfigurationChance>> BURIED_TREASURE = StructureFeatures.register("buried_treasure", StructureGenerator.BURIED_TREASURE.configured(new WorldGenFeatureConfigurationChance(0.01f)));
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> BASTION_REMNANT = StructureFeatures.register("bastion_remnant", StructureGenerator.BASTION_REMNANT.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureBastionPieces.START, 6)));
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> VILLAGE_PLAINS = StructureFeatures.register("village_plains", StructureGenerator.VILLAGE.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureVillagePlain.START, 6)));
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> VILLAGE_DESERT = StructureFeatures.register("village_desert", StructureGenerator.VILLAGE.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureDesertVillage.START, 6)));
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> VILLAGE_SAVANNA = StructureFeatures.register("village_savanna", StructureGenerator.VILLAGE.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureVillageSavanna.START, 6)));
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> VILLAGE_SNOWY = StructureFeatures.register("village_snowy", StructureGenerator.VILLAGE.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureVillageSnowy.START, 6)));
    private static final StructureFeature<WorldGenFeatureVillageConfiguration, ? extends StructureGenerator<WorldGenFeatureVillageConfiguration>> VILLAGE_TAIGA = StructureFeatures.register("village_taiga", StructureGenerator.VILLAGE.configured(new WorldGenFeatureVillageConfiguration(() -> WorldGenFeatureVillageTaiga.START, 6)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_STANDARD = StructureFeatures.register("ruined_portal", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.STANDARD)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_DESERT = StructureFeatures.register("ruined_portal_desert", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.DESERT)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_JUNGLE = StructureFeatures.register("ruined_portal_jungle", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.JUNGLE)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_SWAMP = StructureFeatures.register("ruined_portal_swamp", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.SWAMP)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_MOUNTAIN = StructureFeatures.register("ruined_portal_mountain", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.MOUNTAIN)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_OCEAN = StructureFeatures.register("ruined_portal_ocean", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.OCEAN)));
    private static final StructureFeature<WorldGenFeatureRuinedPortalConfiguration, ? extends StructureGenerator<WorldGenFeatureRuinedPortalConfiguration>> RUINED_PORTAL_NETHER = StructureFeatures.register("ruined_portal_nether", StructureGenerator.RUINED_PORTAL.configured(new WorldGenFeatureRuinedPortalConfiguration(WorldGenFeatureRuinedPortal.Type.NETHER)));

    public static StructureFeature<?, ?> bootstrap() {
        return MINESHAFT;
    }

    private static <FC extends WorldGenFeatureConfiguration, F extends StructureGenerator<FC>> StructureFeature<FC, F> register(String var0, StructureFeature<FC, F> var1) {
        return RegistryGeneration.register(RegistryGeneration.CONFIGURED_STRUCTURE_FEATURE, var0, var1);
    }

    private static void register(BiConsumer<StructureFeature<?, ?>, ResourceKey<BiomeBase>> var0, StructureFeature<?, ?> var1, Set<ResourceKey<BiomeBase>> var22) {
        var22.forEach(var2 -> var0.accept(var1, (ResourceKey<BiomeBase>)var2));
    }

    private static void register(BiConsumer<StructureFeature<?, ?>, ResourceKey<BiomeBase>> var0, StructureFeature<?, ?> var1, ResourceKey<BiomeBase> var2) {
        var0.accept(var1, var2);
    }

    public static void registerStructures(BiConsumer<StructureFeature<?, ?>, ResourceKey<BiomeBase>> var0) {
        ImmutableSet var1 = ImmutableSet.builder().add(Biomes.DEEP_FROZEN_OCEAN).add(Biomes.DEEP_COLD_OCEAN).add(Biomes.DEEP_OCEAN).add(Biomes.DEEP_LUKEWARM_OCEAN).build();
        ImmutableSet var2 = ImmutableSet.builder().add(Biomes.FROZEN_OCEAN).add(Biomes.OCEAN).add(Biomes.COLD_OCEAN).add(Biomes.LUKEWARM_OCEAN).add(Biomes.WARM_OCEAN).addAll((Iterable)var1).build();
        ImmutableSet var3 = ImmutableSet.builder().add(Biomes.BEACH).add(Biomes.SNOWY_BEACH).build();
        ImmutableSet var4 = ImmutableSet.builder().add(Biomes.RIVER).add(Biomes.FROZEN_RIVER).build();
        ImmutableSet var5 = ImmutableSet.builder().add(Biomes.MEADOW).add(Biomes.FROZEN_PEAKS).add(Biomes.JAGGED_PEAKS).add(Biomes.STONY_PEAKS).add(Biomes.SNOWY_SLOPES).build();
        ImmutableSet var6 = ImmutableSet.builder().add(Biomes.BADLANDS).add(Biomes.ERODED_BADLANDS).add(Biomes.WOODED_BADLANDS).build();
        ImmutableSet var7 = ImmutableSet.builder().add(Biomes.WINDSWEPT_HILLS).add(Biomes.WINDSWEPT_FOREST).add(Biomes.WINDSWEPT_GRAVELLY_HILLS).build();
        ImmutableSet var8 = ImmutableSet.builder().add(Biomes.TAIGA).add(Biomes.SNOWY_TAIGA).add(Biomes.OLD_GROWTH_PINE_TAIGA).add(Biomes.OLD_GROWTH_SPRUCE_TAIGA).build();
        ImmutableSet var9 = ImmutableSet.builder().add(Biomes.BAMBOO_JUNGLE).add(Biomes.JUNGLE).add(Biomes.SPARSE_JUNGLE).build();
        ImmutableSet var10 = ImmutableSet.builder().add(Biomes.FOREST).add(Biomes.FLOWER_FOREST).add(Biomes.BIRCH_FOREST).add(Biomes.OLD_GROWTH_BIRCH_FOREST).add(Biomes.DARK_FOREST).add(Biomes.GROVE).build();
        ImmutableSet var11 = ImmutableSet.builder().add(Biomes.NETHER_WASTES).add(Biomes.BASALT_DELTAS).add(Biomes.SOUL_SAND_VALLEY).add(Biomes.CRIMSON_FOREST).add(Biomes.WARPED_FOREST).build();
        StructureFeatures.register(var0, BURIED_TREASURE, (Set<ResourceKey<BiomeBase>>)var3);
        StructureFeatures.register(var0, DESERT_PYRAMID, Biomes.DESERT);
        StructureFeatures.register(var0, IGLOO, Biomes.SNOWY_TAIGA);
        StructureFeatures.register(var0, IGLOO, Biomes.SNOWY_PLAINS);
        StructureFeatures.register(var0, IGLOO, Biomes.SNOWY_SLOPES);
        StructureFeatures.register(var0, JUNGLE_TEMPLE, Biomes.BAMBOO_JUNGLE);
        StructureFeatures.register(var0, JUNGLE_TEMPLE, Biomes.JUNGLE);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var2);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var4);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var3);
        StructureFeatures.register(var0, MINESHAFT, Biomes.STONY_SHORE);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var5);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var7);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var8);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var9);
        StructureFeatures.register(var0, MINESHAFT, (Set<ResourceKey<BiomeBase>>)var10);
        StructureFeatures.register(var0, MINESHAFT, Biomes.MUSHROOM_FIELDS);
        StructureFeatures.register(var0, MINESHAFT, Biomes.ICE_SPIKES);
        StructureFeatures.register(var0, MINESHAFT, Biomes.WINDSWEPT_SAVANNA);
        StructureFeatures.register(var0, MINESHAFT, Biomes.DESERT);
        StructureFeatures.register(var0, MINESHAFT, Biomes.SAVANNA);
        StructureFeatures.register(var0, MINESHAFT, Biomes.SNOWY_PLAINS);
        StructureFeatures.register(var0, MINESHAFT, Biomes.PLAINS);
        StructureFeatures.register(var0, MINESHAFT, Biomes.SUNFLOWER_PLAINS);
        StructureFeatures.register(var0, MINESHAFT, Biomes.SWAMP);
        StructureFeatures.register(var0, MINESHAFT, Biomes.SAVANNA_PLATEAU);
        StructureFeatures.register(var0, MINESHAFT, Biomes.DRIPSTONE_CAVES);
        StructureFeatures.register(var0, MINESHAFT, Biomes.LUSH_CAVES);
        StructureFeatures.register(var0, MINESHAFT_MESA, (Set<ResourceKey<BiomeBase>>)var6);
        StructureFeatures.register(var0, OCEAN_MONUMENT, (Set<ResourceKey<BiomeBase>>)var1);
        StructureFeatures.register(var0, OCEAN_RUIN_COLD, Biomes.FROZEN_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_COLD, Biomes.COLD_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_COLD, Biomes.OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_COLD, Biomes.DEEP_FROZEN_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_COLD, Biomes.DEEP_COLD_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_COLD, Biomes.DEEP_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_WARM, Biomes.LUKEWARM_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_WARM, Biomes.WARM_OCEAN);
        StructureFeatures.register(var0, OCEAN_RUIN_WARM, Biomes.DEEP_LUKEWARM_OCEAN);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, Biomes.DESERT);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, Biomes.PLAINS);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, Biomes.SAVANNA);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, Biomes.SNOWY_PLAINS);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, Biomes.TAIGA);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, (Set<ResourceKey<BiomeBase>>)var5);
        StructureFeatures.register(var0, PILLAGER_OUTPOST, Biomes.GROVE);
        StructureFeatures.register(var0, RUINED_PORTAL_DESERT, Biomes.DESERT);
        StructureFeatures.register(var0, RUINED_PORTAL_JUNGLE, (Set<ResourceKey<BiomeBase>>)var9);
        StructureFeatures.register(var0, RUINED_PORTAL_OCEAN, (Set<ResourceKey<BiomeBase>>)var2);
        StructureFeatures.register(var0, RUINED_PORTAL_SWAMP, Biomes.SWAMP);
        StructureFeatures.register(var0, RUINED_PORTAL_MOUNTAIN, (Set<ResourceKey<BiomeBase>>)var6);
        StructureFeatures.register(var0, RUINED_PORTAL_MOUNTAIN, (Set<ResourceKey<BiomeBase>>)var7);
        StructureFeatures.register(var0, RUINED_PORTAL_MOUNTAIN, Biomes.SAVANNA_PLATEAU);
        StructureFeatures.register(var0, RUINED_PORTAL_MOUNTAIN, Biomes.WINDSWEPT_SAVANNA);
        StructureFeatures.register(var0, RUINED_PORTAL_MOUNTAIN, Biomes.STONY_SHORE);
        StructureFeatures.register(var0, RUINED_PORTAL_MOUNTAIN, (Set<ResourceKey<BiomeBase>>)var5);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.MUSHROOM_FIELDS);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.ICE_SPIKES);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, (Set<ResourceKey<BiomeBase>>)var3);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, (Set<ResourceKey<BiomeBase>>)var4);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, (Set<ResourceKey<BiomeBase>>)var8);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, (Set<ResourceKey<BiomeBase>>)var10);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.DRIPSTONE_CAVES);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.LUSH_CAVES);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.SAVANNA);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.SNOWY_PLAINS);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.PLAINS);
        StructureFeatures.register(var0, RUINED_PORTAL_STANDARD, Biomes.SUNFLOWER_PLAINS);
        StructureFeatures.register(var0, SHIPWRECK_BEACHED, (Set<ResourceKey<BiomeBase>>)var3);
        StructureFeatures.register(var0, SHIPWRECK, (Set<ResourceKey<BiomeBase>>)var2);
        StructureFeatures.register(var0, SWAMP_HUT, Biomes.SWAMP);
        StructureFeatures.register(var0, VILLAGE_DESERT, Biomes.DESERT);
        StructureFeatures.register(var0, VILLAGE_PLAINS, Biomes.PLAINS);
        StructureFeatures.register(var0, VILLAGE_PLAINS, Biomes.MEADOW);
        StructureFeatures.register(var0, VILLAGE_SAVANNA, Biomes.SAVANNA);
        StructureFeatures.register(var0, VILLAGE_SNOWY, Biomes.SNOWY_PLAINS);
        StructureFeatures.register(var0, VILLAGE_TAIGA, Biomes.TAIGA);
        StructureFeatures.register(var0, WOODLAND_MANSION, Biomes.DARK_FOREST);
        StructureFeatures.register(var0, NETHER_BRIDGE, (Set<ResourceKey<BiomeBase>>)var11);
        StructureFeatures.register(var0, NETHER_FOSSIL, Biomes.SOUL_SAND_VALLEY);
        StructureFeatures.register(var0, BASTION_REMNANT, Biomes.CRIMSON_FOREST);
        StructureFeatures.register(var0, BASTION_REMNANT, Biomes.NETHER_WASTES);
        StructureFeatures.register(var0, BASTION_REMNANT, Biomes.SOUL_SAND_VALLEY);
        StructureFeatures.register(var0, BASTION_REMNANT, Biomes.WARPED_FOREST);
        StructureFeatures.register(var0, RUINED_PORTAL_NETHER, (Set<ResourceKey<BiomeBase>>)var11);
        StructureFeatures.register(var0, END_CITY, Biomes.END_HIGHLANDS);
        StructureFeatures.register(var0, END_CITY, Biomes.END_MIDLANDS);
    }
}

