/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.data.DebugReportGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugReportNBT
implements DebugReportProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DebugReportGenerator generator;

    public DebugReportNBT(DebugReportGenerator var0) {
        this.generator = var0;
    }

    @Override
    public void run(HashCache var02) throws IOException {
        Path var1 = this.generator.getOutputFolder();
        for (Path var3 : this.generator.getInputFolders()) {
            Files.walk(var3, new FileVisitOption[0]).filter(var0 -> var0.toString().endsWith(".nbt")).forEach(var2 -> DebugReportNBT.convertStructure(var2, this.getName(var3, (Path)var2), var1));
        }
    }

    @Override
    public String getName() {
        return "NBT to SNBT";
    }

    private String getName(Path var0, Path var1) {
        String var2 = var0.relativize(var1).toString().replaceAll("\\\\", "/");
        return var2.substring(0, var2.length() - ".nbt".length());
    }

    @Nullable
    public static Path convertStructure(Path var0, String var1, Path var2) {
        try {
            DebugReportNBT.writeSnbt(var2.resolve(var1 + ".snbt"), GameProfileSerializer.structureToSnbt(NBTCompressedStreamTools.readCompressed(Files.newInputStream(var0, new OpenOption[0]))));
            LOGGER.info("Converted {} from NBT to SNBT", (Object)var1);
            return var2.resolve(var1 + ".snbt");
        }
        catch (IOException var3) {
            LOGGER.error("Couldn't convert {} from NBT to SNBT at {}", (Object)var1, (Object)var0, (Object)var3);
            return null;
        }
    }

    public static void writeSnbt(Path var0, String var1) throws IOException {
        Files.createDirectories(var0.getParent(), new FileAttribute[0]);
        try (BufferedWriter var2 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            var2.write(var1);
            var2.write(10);
        }
    }
}

