/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryDataPackCodec;
import net.minecraft.resources.ResourceKey;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryMaterials<T>
extends IRegistryWritable<T> {
    protected static final Logger LOGGER = LogManager.getLogger();
    private final ObjectList<T> byId = new ObjectArrayList(256);
    private final Object2IntMap<T> toId = (Object2IntMap)SystemUtils.make(new Object2IntOpenCustomHashMap(SystemUtils.identityStrategy()), var0 -> var0.defaultReturnValue(-1));
    private final BiMap<MinecraftKey, T> storage = HashBiMap.create();
    private final BiMap<ResourceKey<T>, T> keyStorage = HashBiMap.create();
    private final Map<T, Lifecycle> lifecycles = Maps.newIdentityHashMap();
    private Lifecycle elementsLifecycle;
    @Nullable
    protected Object[] randomCache;
    private int nextId;

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1) {
        super(var02, var1);
        this.elementsLifecycle = var1;
    }

    public static <T> MapCodec<a<T>> withNameAndId(ResourceKey<? extends IRegistry<T>> var0, MapCodec<T> var1) {
        return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)MinecraftKey.CODEC.xmap(ResourceKey.elementKey(var0), ResourceKey::location).fieldOf("name").forGetter(a::key), (App)Codec.INT.fieldOf("id").forGetter(a::id), (App)var1.forGetter(a::value)).apply((Applicative)var2, a::new));
    }

    @Override
    public <V extends T> V registerMapping(int var0, ResourceKey<T> var1, V var2, Lifecycle var3) {
        return this.registerMapping(var0, var1, var2, var3, true);
    }

    private <V extends T> V registerMapping(int var0, ResourceKey<T> var1, V var2, Lifecycle var3, boolean var4) {
        Validate.notNull(var1);
        Validate.notNull(var2);
        this.byId.size(Math.max(this.byId.size(), var0 + 1));
        this.byId.set(var0, var2);
        this.toId.put(var2, var0);
        this.randomCache = null;
        if (var4 && this.keyStorage.containsKey(var1)) {
            SystemUtils.logAndPauseIfInIde("Adding duplicate key '" + var1 + "' to registry");
        }
        if (this.storage.containsValue(var2)) {
            SystemUtils.logAndPauseIfInIde("Adding duplicate value '" + var2 + "' to registry");
        }
        this.storage.put((Object)var1.location(), var2);
        this.keyStorage.put(var1, var2);
        this.lifecycles.put(var2, var3);
        this.elementsLifecycle = this.elementsLifecycle.add(var3);
        if (this.nextId <= var0) {
            this.nextId = var0 + 1;
        }
        return var2;
    }

    @Override
    public <V extends T> V register(ResourceKey<T> var0, V var1, Lifecycle var2) {
        return this.registerMapping(this.nextId, var0, var1, var2);
    }

    @Override
    public <V extends T> V registerOrOverride(OptionalInt var0, ResourceKey<T> var1, V var2, Lifecycle var3) {
        int var5;
        Validate.notNull(var1);
        Validate.notNull(var2);
        Object var4 = this.keyStorage.get(var1);
        if (var4 == null) {
            var5 = var0.isPresent() ? var0.getAsInt() : this.nextId;
        } else {
            var5 = this.toId.getInt(var4);
            if (var0.isPresent() && var0.getAsInt() != var5) {
                throw new IllegalStateException("ID mismatch");
            }
            this.toId.removeInt(var4);
            this.lifecycles.remove(var4);
        }
        return this.registerMapping(var5, var1, var2, var3, false);
    }

    @Override
    @Nullable
    public MinecraftKey getKey(T var0) {
        return (MinecraftKey)this.storage.inverse().get(var0);
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T var0) {
        return Optional.ofNullable((ResourceKey)this.keyStorage.inverse().get(var0));
    }

    @Override
    public int getId(@Nullable T var0) {
        return this.toId.getInt(var0);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceKey<T> var0) {
        return (T)this.keyStorage.get(var0);
    }

    @Override
    @Nullable
    public T byId(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return null;
        }
        return (T)this.byId.get(var0);
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public Lifecycle lifecycle(T var0) {
        return this.lifecycles.get(var0);
    }

    @Override
    public Lifecycle elementsLifecycle() {
        return this.elementsLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.byId.iterator(), Objects::nonNull);
    }

    @Override
    @Nullable
    public T get(@Nullable MinecraftKey var0) {
        return (T)this.storage.get((Object)var0);
    }

    @Override
    public Set<MinecraftKey> keySet() {
        return Collections.unmodifiableSet(this.storage.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableMap(this.keyStorage).entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    @Nullable
    public T getRandom(Random var0) {
        if (this.randomCache == null) {
            Set var1 = this.storage.values();
            if (var1.isEmpty()) {
                return null;
            }
            this.randomCache = var1.toArray(Object[]::new);
        }
        return (T)SystemUtils.getRandom(this.randomCache, var0);
    }

    @Override
    public boolean containsKey(MinecraftKey var0) {
        return this.storage.containsKey((Object)var0);
    }

    @Override
    public boolean containsKey(ResourceKey<T> var0) {
        return this.keyStorage.containsKey(var0);
    }

    public static <T> Codec<RegistryMaterials<T>> networkCodec(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, Codec<T> var22) {
        return RegistryMaterials.withNameAndId(var02, var22.fieldOf("element")).codec().listOf().xmap(var2 -> {
            RegistryMaterials var3 = new RegistryMaterials(var02, var1);
            for (a var5 : var2) {
                var3.registerMapping(var5.id(), var5.key(), var5.value(), var1);
            }
            return var3;
        }, var0 -> {
            ImmutableList.Builder var1 = ImmutableList.builder();
            for (Object var3 : var0) {
                var1.add((Object)new a(var0.getResourceKey(var3).get(), var0.getId(var3), var3));
            }
            return var1.build();
        });
    }

    public static <T> Codec<RegistryMaterials<T>> dataPackCodec(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1, Codec<T> var2) {
        return RegistryDataPackCodec.create(var0, var1, var2);
    }

    public static <T> Codec<RegistryMaterials<T>> directCodec(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, Codec<T> var2) {
        return Codec.unboundedMap((Codec)MinecraftKey.CODEC.xmap(ResourceKey.elementKey(var02), ResourceKey::location), var2).xmap(var22 -> {
            RegistryMaterials var32 = new RegistryMaterials(var02, var1);
            var22.forEach((? super K var2, ? super V var3) -> var32.register((ResourceKey)var2, (Object)var3, var1));
            return var32;
        }, var0 -> ImmutableMap.copyOf(var0.keyStorage));
    }

    record a(ResourceKey<T> key, int id, T value) {
    }
}

