/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.structures.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class IRegistryCustom {
    static final Logger LOGGER = LogManager.getLogger();
    static final Map<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> REGISTRIES = (Map)SystemUtils.make(() -> {
        ImmutableMap.Builder var0 = ImmutableMap.builder();
        IRegistryCustom.put(var0, IRegistry.DIMENSION_TYPE_REGISTRY, DimensionManager.DIRECT_CODEC, DimensionManager.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.BIOME_REGISTRY, BiomeBase.DIRECT_CODEC, BiomeBase.NETWORK_CODEC);
        IRegistryCustom.put(var0, IRegistry.CONFIGURED_CARVER_REGISTRY, WorldGenCarverWrapper.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.CONFIGURED_FEATURE_REGISTRY, WorldGenFeatureConfigured.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.PLACED_FEATURE_REGISTRY, PlacedFeature.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.CONFIGURED_STRUCTURE_FEATURE_REGISTRY, StructureFeature.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.PROCESSOR_LIST_REGISTRY, DefinedStructureStructureProcessorType.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.TEMPLATE_POOL_REGISTRY, WorldGenFeatureDefinedStructurePoolTemplate.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY, GeneratorSettingBase.DIRECT_CODEC);
        IRegistryCustom.put(var0, IRegistry.NOISE_REGISTRY, NoiseGeneratorNormal.a.DIRECT_CODEC);
        return var0.build();
    });
    private static final Dimension BUILTIN = SystemUtils.make(() -> {
        Dimension var02 = new Dimension();
        DimensionManager.registerBuiltin(var02);
        REGISTRIES.keySet().stream().filter(var0 -> !var0.equals(IRegistry.DIMENSION_TYPE_REGISTRY)).forEach(var1 -> IRegistryCustom.copyBuiltin(var02, var1));
        return var02;
    });

    public abstract <E> Optional<IRegistryWritable<E>> ownedRegistry(ResourceKey<? extends IRegistry<? extends E>> var1);

    public <E> IRegistryWritable<E> ownedRegistryOrThrow(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.ownedRegistry(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + var0));
    }

    public <E> Optional<? extends IRegistry<E>> registry(ResourceKey<? extends IRegistry<? extends E>> var0) {
        Optional<IRegistryWritable<E>> var1 = this.ownedRegistry(var0);
        if (var1.isPresent()) {
            return var1;
        }
        return IRegistry.REGISTRY.getOptional(var0.location());
    }

    public <E> IRegistry<E> registryOrThrow(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.registry(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + var0));
    }

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2) {
        var0.put(var1, (Object)new RegistryData(var1, var2, null));
    }

    private static <E> void put(ImmutableMap.Builder<ResourceKey<? extends IRegistry<?>>, RegistryData<?>> var0, ResourceKey<? extends IRegistry<E>> var1, Codec<E> var2, Codec<E> var3) {
        var0.put(var1, (Object)new RegistryData(var1, var2, var3));
    }

    public static Iterable<RegistryData<?>> knownRegistries() {
        return REGISTRIES.values();
    }

    public static Dimension builtin() {
        Dimension var0 = new Dimension();
        RegistryResourceAccess.InMemoryStorage var1 = new RegistryResourceAccess.InMemoryStorage();
        for (RegistryData<?> var3 : REGISTRIES.values()) {
            IRegistryCustom.addBuiltinElements(var0, var1, var3);
        }
        RegistryReadOps.createAndLoad(JsonOps.INSTANCE, var1, (IRegistryCustom)var0);
        return var0;
    }

    private static <E> void addBuiltinElements(Dimension var0, RegistryResourceAccess.InMemoryStorage var1, RegistryData<E> var2) {
        ResourceKey var3 = var2.key();
        boolean var4 = !var3.equals(IRegistry.NOISE_GENERATOR_SETTINGS_REGISTRY) && !var3.equals(IRegistry.DIMENSION_TYPE_REGISTRY);
        IRegistry<E> var5 = BUILTIN.registryOrThrow(var3);
        IRegistryWritable<E> var6 = var0.ownedRegistryOrThrow(var3);
        for (Map.Entry<ResourceKey<E>, E> var8 : var5.entrySet()) {
            ResourceKey<E> var9 = var8.getKey();
            E var10 = var8.getValue();
            if (var4) {
                var1.add(BUILTIN, var9, var2.codec(), var5.getId(var10), var10, var5.lifecycle(var10));
                continue;
            }
            var6.registerMapping(var5.getId(var10), var9, var10, var5.lifecycle(var10));
        }
    }

    private static <R extends IRegistry<?>> void copyBuiltin(Dimension var0, ResourceKey<R> var1) {
        IRegistry<IRegistry<?>> var2 = RegistryGeneration.REGISTRY;
        IRegistry<?> var3 = var2.getOrThrow(var1);
        IRegistryCustom.copy(var0, var3);
    }

    private static <E> void copy(Dimension var0, IRegistry<E> var1) {
        IRegistryWritable<E> var2 = var0.ownedRegistryOrThrow(var1.key());
        for (Map.Entry<ResourceKey<E>, E> var4 : var1.entrySet()) {
            E var5 = var4.getValue();
            var2.registerMapping(var1.getId(var5), var4.getKey(), var5, var1.lifecycle(var5));
        }
    }

    public static void load(IRegistryCustom var0, RegistryReadOps<?> var1) {
        for (RegistryData<?> var3 : REGISTRIES.values()) {
            IRegistryCustom.readRegistry(var1, var0, var3);
        }
    }

    private static <E> void readRegistry(RegistryReadOps<?> var02, IRegistryCustom var1, RegistryData<E> var2) {
        ResourceKey var3 = var2.key();
        RegistryMaterials var4 = (RegistryMaterials)var1.ownedRegistryOrThrow(var3);
        DataResult var5 = var02.decodeElements(var4, var2.key(), var2.codec());
        var5.error().ifPresent(var0 -> {
            throw new JsonParseException("Error loading registry data: " + var0.message());
        });
    }

    public record RegistryData(ResourceKey<? extends IRegistry<E>> key, Codec<E> codec, @Nullable Codec<E> networkCodec) {
        public boolean sendToClient() {
            return this.networkCodec != null;
        }
    }

    public static final class Dimension
    extends IRegistryCustom {
        public static final Codec<Dimension> NETWORK_CODEC = Dimension.makeNetworkCodec();
        private final Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends RegistryMaterials<?>> registries;

        private static <E> Codec<Dimension> makeNetworkCodec() {
            Codec var02 = MinecraftKey.CODEC.xmap(ResourceKey::createRegistryKey, ResourceKey::location);
            Codec var1 = var02.partialDispatch("type", var0 -> DataResult.success(var0.key()), var0 -> Dimension.getNetworkCodec(var0).map(var1 -> RegistryMaterials.networkCodec(var0, Lifecycle.experimental(), var1)));
            UnboundedMapCodec var2 = Codec.unboundedMap((Codec)var02, (Codec)var1);
            return Dimension.captureMap(var2);
        }

        private static <K extends ResourceKey<? extends IRegistry<?>>, V extends RegistryMaterials<?>> Codec<Dimension> captureMap(UnboundedMapCodec<K, V> var0) {
            return var0.xmap(Dimension::new, var02 -> (Map)var02.registries.entrySet().stream().filter(var0 -> REGISTRIES.get(var0.getKey()).sendToClient()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static <E> DataResult<? extends Codec<E>> getNetworkCodec(ResourceKey<? extends IRegistry<E>> var02) {
            return Optional.ofNullable(REGISTRIES.get(var02)).map(var0 -> var0.networkCodec()).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown or not serializable registry: " + var02)));
        }

        public Dimension() {
            this(REGISTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), Dimension::createRegistry)));
        }

        public static IRegistryCustom readFromDisk(Dynamic<?> var0) {
            return new Dimension(REGISTRIES.keySet().stream().collect(Collectors.toMap(Function.identity(), var1 -> Dimension.parseRegistry(var1, var0))));
        }

        private static <E> RegistryMaterials<?> parseRegistry(ResourceKey<? extends IRegistry<?>> var0, Dynamic<?> var1) {
            return (RegistryMaterials)RegistryLookupCodec.create(var0).codec().parse(var1).resultOrPartial(SystemUtils.prefix(var0 + " registry: ", arg_0 -> ((Logger)LOGGER).error(arg_0))).orElseThrow(() -> new IllegalStateException("Failed to get " + var0 + " registry"));
        }

        private Dimension(Map<? extends ResourceKey<? extends IRegistry<?>>, ? extends RegistryMaterials<?>> var0) {
            this.registries = var0;
        }

        private static <E> RegistryMaterials<?> createRegistry(ResourceKey<? extends IRegistry<?>> var0) {
            return new RegistryMaterials(var0, Lifecycle.stable());
        }

        @Override
        public <E> Optional<IRegistryWritable<E>> ownedRegistry(ResourceKey<? extends IRegistry<? extends E>> var02) {
            return Optional.ofNullable(this.registries.get(var02)).map(var0 -> var0);
        }
    }
}

