/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import net.minecraft.commands.synchronization.ArgumentRegistry;
import net.minecraft.commands.synchronization.ArgumentSerializerVoid;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerDouble;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerFloat;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerInteger;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerLong;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializerString;

public class ArgumentSerializers {
    private static final byte NUMBER_FLAG_MIN = 1;
    private static final byte NUMBER_FLAG_MAX = 2;

    public static void bootstrap() {
        ArgumentRegistry.register("brigadier:bool", BoolArgumentType.class, new ArgumentSerializerVoid<BoolArgumentType>(BoolArgumentType::bool));
        ArgumentRegistry.register("brigadier:float", FloatArgumentType.class, new ArgumentSerializerFloat());
        ArgumentRegistry.register("brigadier:double", DoubleArgumentType.class, new ArgumentSerializerDouble());
        ArgumentRegistry.register("brigadier:integer", IntegerArgumentType.class, new ArgumentSerializerInteger());
        ArgumentRegistry.register("brigadier:long", LongArgumentType.class, new ArgumentSerializerLong());
        ArgumentRegistry.register("brigadier:string", StringArgumentType.class, new ArgumentSerializerString());
    }

    public static byte createNumberFlags(boolean var0, boolean var1) {
        byte var2 = 0;
        if (var0) {
            var2 = (byte)(var2 | 1);
        }
        if (var1) {
            var2 = (byte)(var2 | 2);
        }
        return var2;
    }

    public static boolean numberHasMin(byte var0) {
        return (var0 & 1) != 0;
    }

    public static boolean numberHasMax(byte var0) {
        return (var0 & 2) != 0;
    }
}

