/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.ArgumentSerializers;
import net.minecraft.network.PacketDataSerializer;

public class ArgumentSerializerDouble
implements ArgumentSerializer<DoubleArgumentType> {
    @Override
    public void serializeToNetwork(DoubleArgumentType var0, PacketDataSerializer var1) {
        boolean var2 = var0.getMinimum() != -1.7976931348623157E308;
        boolean var3 = var0.getMaximum() != Double.MAX_VALUE;
        var1.writeByte(ArgumentSerializers.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeDouble(var0.getMinimum());
        }
        if (var3) {
            var1.writeDouble(var0.getMaximum());
        }
    }

    @Override
    public DoubleArgumentType deserializeFromNetwork(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        double var2 = ArgumentSerializers.numberHasMin(var1) ? var0.readDouble() : -1.7976931348623157E308;
        double var4 = ArgumentSerializers.numberHasMax(var1) ? var0.readDouble() : Double.MAX_VALUE;
        return DoubleArgumentType.doubleArg((double)var2, (double)var4);
    }

    @Override
    public void serializeToJson(DoubleArgumentType var0, JsonObject var1) {
        if (var0.getMinimum() != -1.7976931348623157E308) {
            var1.addProperty("min", (Number)var0.getMinimum());
        }
        if (var0.getMaximum() != Double.MAX_VALUE) {
            var1.addProperty("max", (Number)var0.getMaximum());
        }
    }

    @Override
    public /* synthetic */ ArgumentType deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
        return this.deserializeFromNetwork(packetDataSerializer);
    }
}

