/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ArgumentNBTKey
implements ArgumentType<g> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType ERROR_INVALID_NODE = new SimpleCommandExceptionType((Message)new ChatMessage("arguments.nbtpath.node.invalid"));
    public static final DynamicCommandExceptionType ERROR_NOTHING_FOUND = new DynamicCommandExceptionType(var0 -> new ChatMessage("arguments.nbtpath.nothing_found", var0));
    private static final char INDEX_MATCH_START = '[';
    private static final char INDEX_MATCH_END = ']';
    private static final char KEY_MATCH_START = '{';
    private static final char KEY_MATCH_END = '}';
    private static final char QUOTED_KEY_START = '\"';

    public static ArgumentNBTKey nbtPath() {
        return new ArgumentNBTKey();
    }

    public static g getPath(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (g)var0.getArgument(var1, g.class);
    }

    public g parse(StringReader var0) throws CommandSyntaxException {
        ArrayList var1 = Lists.newArrayList();
        int var2 = var0.getCursor();
        Object2IntOpenHashMap var3 = new Object2IntOpenHashMap();
        boolean var4 = true;
        while (var0.canRead() && var0.peek() != ' ') {
            char var6;
            h var5 = ArgumentNBTKey.parseNode(var0, var4);
            var1.add(var5);
            var3.put((Object)var5, var0.getCursor() - var2);
            var4 = false;
            if (!var0.canRead() || (var6 = var0.peek()) == ' ' || var6 == '[' || var6 == '{') continue;
            var0.expect('.');
        }
        return new g(var0.getString().substring(var2, var0.getCursor()), var1.toArray(new h[0]), (Object2IntMap<h>)var3);
    }

    private static h parseNode(StringReader var0, boolean var1) throws CommandSyntaxException {
        switch (var0.peek()) {
            case '{': {
                if (!var1) {
                    throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)var0);
                }
                NBTTagCompound var2 = new MojangsonParser(var0).readStruct();
                return new f(var2);
            }
            case '[': {
                var0.skip();
                char var2 = var0.peek();
                if (var2 == '{') {
                    NBTTagCompound var3 = new MojangsonParser(var0).readStruct();
                    var0.expect(']');
                    return new d(var3);
                }
                if (var2 == ']') {
                    var0.skip();
                    return a.INSTANCE;
                }
                int var3 = var0.readInt();
                var0.expect(']');
                return new c(var3);
            }
            case '\"': {
                String var2 = var0.readString();
                return ArgumentNBTKey.readObjectNode(var0, var2);
            }
        }
        String var2 = ArgumentNBTKey.readUnquotedName(var0);
        return ArgumentNBTKey.readObjectNode(var0, var2);
    }

    private static h readObjectNode(StringReader var0, String var1) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '{') {
            NBTTagCompound var2 = new MojangsonParser(var0).readStruct();
            return new e(var1, var2);
        }
        return new b(var1);
    }

    private static String readUnquotedName(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        while (var0.canRead() && ArgumentNBTKey.isAllowedInUnquotedName(var0.peek())) {
            var0.skip();
        }
        if (var0.getCursor() == var1) {
            throw ERROR_INVALID_NODE.createWithContext((ImmutableStringReader)var0);
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static boolean isAllowedInUnquotedName(char var0) {
        return var0 != ' ' && var0 != '\"' && var0 != '[' && var0 != ']' && var0 != '.' && var0 != '{' && var0 != '}';
    }

    static Predicate<NBTBase> createTagPredicate(NBTTagCompound var0) {
        return var1 -> GameProfileSerializer.compareNbt(var0, var1, true);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class g {
        private final String original;
        private final Object2IntMap<h> nodeToOriginalPosition;
        private final h[] nodes;

        public g(String var0, h[] var1, Object2IntMap<h> var2) {
            this.original = var0;
            this.nodes = var1;
            this.nodeToOriginalPosition = var2;
        }

        public List<NBTBase> get(NBTBase var0) throws CommandSyntaxException {
            List<NBTBase> var1 = Collections.singletonList(var0);
            for (h var5 : this.nodes) {
                if (!(var1 = var5.get(var1)).isEmpty()) continue;
                throw this.createNotFoundException(var5);
            }
            return var1;
        }

        public int countMatching(NBTBase var0) {
            List<NBTBase> var1 = Collections.singletonList(var0);
            for (h var5 : this.nodes) {
                if (!(var1 = var5.get(var1)).isEmpty()) continue;
                return 0;
            }
            return var1.size();
        }

        private List<NBTBase> getOrCreateParents(NBTBase var0) throws CommandSyntaxException {
            List<NBTBase> var1 = Collections.singletonList(var0);
            for (int var2 = 0; var2 < this.nodes.length - 1; ++var2) {
                h var3 = this.nodes[var2];
                int var4 = var2 + 1;
                if (!(var1 = var3.getOrCreate(var1, this.nodes[var4]::createPreferredParentTag)).isEmpty()) continue;
                throw this.createNotFoundException(var3);
            }
            return var1;
        }

        public List<NBTBase> getOrCreate(NBTBase var0, Supplier<NBTBase> var1) throws CommandSyntaxException {
            List<NBTBase> var2 = this.getOrCreateParents(var0);
            h var3 = this.nodes[this.nodes.length - 1];
            return var3.getOrCreate(var2, var1);
        }

        private static int apply(List<NBTBase> var02, Function<NBTBase, Integer> var12) {
            return var02.stream().map(var12).reduce(0, (var0, var1) -> var0 + var1);
        }

        public int set(NBTBase var0, NBTBase var1) throws CommandSyntaxException {
            return this.set(var0, var1::copy);
        }

        public int set(NBTBase var0, Supplier<NBTBase> var1) throws CommandSyntaxException {
            List<NBTBase> var22 = this.getOrCreateParents(var0);
            h var3 = this.nodes[this.nodes.length - 1];
            return g.apply(var22, var2 -> var3.setTag((NBTBase)var2, var1));
        }

        public int remove(NBTBase var0) {
            List<NBTBase> var1 = Collections.singletonList(var0);
            for (int var2 = 0; var2 < this.nodes.length - 1; ++var2) {
                var1 = this.nodes[var2].get(var1);
            }
            h var2 = this.nodes[this.nodes.length - 1];
            return g.apply(var1, var2::removeTag);
        }

        private CommandSyntaxException createNotFoundException(h var0) {
            int var1 = this.nodeToOriginalPosition.getInt((Object)var0);
            return ERROR_NOTHING_FOUND.create((Object)this.original.substring(0, var1));
        }

        public String toString() {
            return this.original;
        }
    }

    static interface h {
        public void getTag(NBTBase var1, List<NBTBase> var2);

        public void getOrCreateTag(NBTBase var1, Supplier<NBTBase> var2, List<NBTBase> var3);

        public NBTBase createPreferredParentTag();

        public int setTag(NBTBase var1, Supplier<NBTBase> var2);

        public int removeTag(NBTBase var1);

        default public List<NBTBase> get(List<NBTBase> var0) {
            return this.collect(var0, this::getTag);
        }

        default public List<NBTBase> getOrCreate(List<NBTBase> var0, Supplier<NBTBase> var12) {
            return this.collect(var0, (var1, var2) -> this.getOrCreateTag((NBTBase)var1, var12, (List<NBTBase>)var2));
        }

        default public List<NBTBase> collect(List<NBTBase> var0, BiConsumer<NBTBase, List<NBTBase>> var1) {
            ArrayList var2 = Lists.newArrayList();
            for (NBTBase var4 : var0) {
                var1.accept(var4, var2);
            }
            return var2;
        }
    }

    static class f
    implements h {
        private final Predicate<NBTBase> predicate;

        public f(NBTTagCompound var0) {
            this.predicate = ArgumentNBTKey.createTagPredicate(var0);
        }

        @Override
        public void getTag(NBTBase var0, List<NBTBase> var1) {
            if (var0 instanceof NBTTagCompound && this.predicate.test(var0)) {
                var1.add(var0);
            }
        }

        @Override
        public void getOrCreateTag(NBTBase var0, Supplier<NBTBase> var1, List<NBTBase> var2) {
            this.getTag(var0, var2);
        }

        @Override
        public NBTBase createPreferredParentTag() {
            return new NBTTagCompound();
        }

        @Override
        public int setTag(NBTBase var0, Supplier<NBTBase> var1) {
            return 0;
        }

        @Override
        public int removeTag(NBTBase var0) {
            return 0;
        }
    }

    static class d
    implements h {
        private final NBTTagCompound pattern;
        private final Predicate<NBTBase> predicate;

        public d(NBTTagCompound var0) {
            this.pattern = var0;
            this.predicate = ArgumentNBTKey.createTagPredicate(var0);
        }

        @Override
        public void getTag(NBTBase var0, List<NBTBase> var1) {
            if (var0 instanceof NBTTagList) {
                NBTTagList var2 = (NBTTagList)var0;
                var2.stream().filter(this.predicate).forEach(var1::add);
            }
        }

        @Override
        public void getOrCreateTag(NBTBase var0, Supplier<NBTBase> var1, List<NBTBase> var22) {
            MutableBoolean var3 = new MutableBoolean();
            if (var0 instanceof NBTTagList) {
                NBTTagList var4 = (NBTTagList)var0;
                var4.stream().filter(this.predicate).forEach(var2 -> {
                    var22.add((NBTBase)var2);
                    var3.setTrue();
                });
                if (var3.isFalse()) {
                    NBTTagCompound var5 = this.pattern.copy();
                    var4.add(var5);
                    var22.add(var5);
                }
            }
        }

        @Override
        public NBTBase createPreferredParentTag() {
            return new NBTTagList();
        }

        @Override
        public int setTag(NBTBase var0, Supplier<NBTBase> var1) {
            int var2 = 0;
            if (var0 instanceof NBTTagList) {
                NBTTagList var3 = (NBTTagList)var0;
                int var4 = var3.size();
                if (var4 == 0) {
                    var3.add(var1.get());
                    ++var2;
                } else {
                    for (int var5 = 0; var5 < var4; ++var5) {
                        NBTBase var7;
                        NBTBase var6 = var3.get(var5);
                        if (!this.predicate.test(var6) || (var7 = var1.get()).equals(var6) || !var3.setTag(var5, var7)) continue;
                        ++var2;
                    }
                }
            }
            return var2;
        }

        @Override
        public int removeTag(NBTBase var0) {
            int var1 = 0;
            if (var0 instanceof NBTTagList) {
                NBTTagList var2 = (NBTTagList)var0;
                for (int var3 = var2.size() - 1; var3 >= 0; --var3) {
                    if (!this.predicate.test(var2.get(var3))) continue;
                    var2.remove(var3);
                    ++var1;
                }
            }
            return var1;
        }
    }

    static class a
    implements h {
        public static final a INSTANCE = new a();

        private a() {
        }

        @Override
        public void getTag(NBTBase var0, List<NBTBase> var1) {
            if (var0 instanceof NBTList) {
                var1.addAll((NBTList)var0);
            }
        }

        @Override
        public void getOrCreateTag(NBTBase var0, Supplier<NBTBase> var1, List<NBTBase> var2) {
            if (var0 instanceof NBTList) {
                NBTList var3 = (NBTList)var0;
                if (var3.isEmpty()) {
                    NBTBase var4 = var1.get();
                    if (var3.addTag(0, var4)) {
                        var2.add(var4);
                    }
                } else {
                    var2.addAll(var3);
                }
            }
        }

        @Override
        public NBTBase createPreferredParentTag() {
            return new NBTTagList();
        }

        @Override
        public int setTag(NBTBase var0, Supplier<NBTBase> var1) {
            if (var0 instanceof NBTList) {
                NBTList var2 = (NBTList)var0;
                int var3 = var2.size();
                if (var3 == 0) {
                    var2.addTag(0, var1.get());
                    return 1;
                }
                NBTBase var4 = var1.get();
                int var5 = var3 - (int)var2.stream().filter(var4::equals).count();
                if (var5 == 0) {
                    return 0;
                }
                var2.clear();
                if (!var2.addTag(0, var4)) {
                    return 0;
                }
                for (int var6 = 1; var6 < var3; ++var6) {
                    var2.addTag(var6, var1.get());
                }
                return var5;
            }
            return 0;
        }

        @Override
        public int removeTag(NBTBase var0) {
            NBTList var1;
            int var2;
            if (var0 instanceof NBTList && (var2 = (var1 = (NBTList)var0).size()) > 0) {
                var1.clear();
                return var2;
            }
            return 0;
        }
    }

    static class c
    implements h {
        private final int index;

        public c(int var0) {
            this.index = var0;
        }

        @Override
        public void getTag(NBTBase var0, List<NBTBase> var1) {
            if (var0 instanceof NBTList) {
                int var4;
                NBTList var2 = (NBTList)var0;
                int var3 = var2.size();
                int n2 = var4 = this.index < 0 ? var3 + this.index : this.index;
                if (0 <= var4 && var4 < var3) {
                    var1.add((NBTBase)var2.get(var4));
                }
            }
        }

        @Override
        public void getOrCreateTag(NBTBase var0, Supplier<NBTBase> var1, List<NBTBase> var2) {
            this.getTag(var0, var2);
        }

        @Override
        public NBTBase createPreferredParentTag() {
            return new NBTTagList();
        }

        @Override
        public int setTag(NBTBase var0, Supplier<NBTBase> var1) {
            if (var0 instanceof NBTList) {
                int var4;
                NBTList var2 = (NBTList)var0;
                int var3 = var2.size();
                int n2 = var4 = this.index < 0 ? var3 + this.index : this.index;
                if (0 <= var4 && var4 < var3) {
                    NBTBase var5 = (NBTBase)var2.get(var4);
                    NBTBase var6 = var1.get();
                    if (!var6.equals(var5) && var2.setTag(var4, var6)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int removeTag(NBTBase var0) {
            if (var0 instanceof NBTList) {
                int var3;
                NBTList var1 = (NBTList)var0;
                int var2 = var1.size();
                int n2 = var3 = this.index < 0 ? var2 + this.index : this.index;
                if (0 <= var3 && var3 < var2) {
                    var1.remove(var3);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class e
    implements h {
        private final String name;
        private final NBTTagCompound pattern;
        private final Predicate<NBTBase> predicate;

        public e(String var0, NBTTagCompound var1) {
            this.name = var0;
            this.pattern = var1;
            this.predicate = ArgumentNBTKey.createTagPredicate(var1);
        }

        @Override
        public void getTag(NBTBase var0, List<NBTBase> var1) {
            NBTBase var2;
            if (var0 instanceof NBTTagCompound && this.predicate.test(var2 = ((NBTTagCompound)var0).get(this.name))) {
                var1.add(var2);
            }
        }

        @Override
        public void getOrCreateTag(NBTBase var0, Supplier<NBTBase> var1, List<NBTBase> var2) {
            if (var0 instanceof NBTTagCompound) {
                NBTTagCompound var3 = (NBTTagCompound)var0;
                NBTBase var4 = var3.get(this.name);
                if (var4 == null) {
                    var4 = this.pattern.copy();
                    var3.put(this.name, var4);
                    var2.add(var4);
                } else if (this.predicate.test(var4)) {
                    var2.add(var4);
                }
            }
        }

        @Override
        public NBTBase createPreferredParentTag() {
            return new NBTTagCompound();
        }

        @Override
        public int setTag(NBTBase var0, Supplier<NBTBase> var1) {
            NBTBase var4;
            NBTTagCompound var2;
            NBTBase var3;
            if (var0 instanceof NBTTagCompound && this.predicate.test(var3 = (var2 = (NBTTagCompound)var0).get(this.name)) && !(var4 = var1.get()).equals(var3)) {
                var2.put(this.name, var4);
                return 1;
            }
            return 0;
        }

        @Override
        public int removeTag(NBTBase var0) {
            NBTTagCompound var1;
            NBTBase var2;
            if (var0 instanceof NBTTagCompound && this.predicate.test(var2 = (var1 = (NBTTagCompound)var0).get(this.name))) {
                var1.remove(this.name);
                return 1;
            }
            return 0;
        }
    }

    static class b
    implements h {
        private final String name;

        public b(String var0) {
            this.name = var0;
        }

        @Override
        public void getTag(NBTBase var0, List<NBTBase> var1) {
            NBTBase var2;
            if (var0 instanceof NBTTagCompound && (var2 = ((NBTTagCompound)var0).get(this.name)) != null) {
                var1.add(var2);
            }
        }

        @Override
        public void getOrCreateTag(NBTBase var0, Supplier<NBTBase> var1, List<NBTBase> var2) {
            if (var0 instanceof NBTTagCompound) {
                NBTBase var4;
                NBTTagCompound var3 = (NBTTagCompound)var0;
                if (var3.contains(this.name)) {
                    var4 = var3.get(this.name);
                } else {
                    var4 = var1.get();
                    var3.put(this.name, var4);
                }
                var2.add(var4);
            }
        }

        @Override
        public NBTBase createPreferredParentTag() {
            return new NBTTagCompound();
        }

        @Override
        public int setTag(NBTBase var0, Supplier<NBTBase> var1) {
            if (var0 instanceof NBTTagCompound) {
                NBTBase var4;
                NBTTagCompound var2 = (NBTTagCompound)var0;
                NBTBase var3 = var1.get();
                if (!var3.equals(var4 = var2.put(this.name, var3))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int removeTag(NBTBase var0) {
            NBTTagCompound var1;
            if (var0 instanceof NBTTagCompound && (var1 = (NBTTagCompound)var0).contains(this.name)) {
                var1.remove(this.name);
                return 1;
            }
            return 0;
        }
    }
}

