/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.phys.Vec3D;

public class LighthingBoltPredicate {
    public static final LighthingBoltPredicate ANY = new LighthingBoltPredicate(CriterionConditionValue.IntegerRange.ANY, CriterionConditionEntity.ANY);
    private static final String BLOCKS_SET_ON_FIRE_KEY = "blocks_set_on_fire";
    private static final String ENTITY_STRUCK_KEY = "entity_struck";
    private final CriterionConditionValue.IntegerRange blocksSetOnFire;
    private final CriterionConditionEntity entityStruck;

    private LighthingBoltPredicate(CriterionConditionValue.IntegerRange var0, CriterionConditionEntity var1) {
        this.blocksSetOnFire = var0;
        this.entityStruck = var1;
    }

    public static LighthingBoltPredicate blockSetOnFire(CriterionConditionValue.IntegerRange var0) {
        return new LighthingBoltPredicate(var0, CriterionConditionEntity.ANY);
    }

    public static LighthingBoltPredicate fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "lightning");
        return new LighthingBoltPredicate(CriterionConditionValue.IntegerRange.fromJson(var1.get(BLOCKS_SET_ON_FIRE_KEY)), CriterionConditionEntity.fromJson(var1.get(ENTITY_STRUCK_KEY)));
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        var0.add(BLOCKS_SET_ON_FIRE_KEY, this.blocksSetOnFire.serializeToJson());
        var0.add(ENTITY_STRUCK_KEY, this.entityStruck.serializeToJson());
        return var0;
    }

    public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var22) {
        if (this == ANY) {
            return true;
        }
        if (!(var0 instanceof EntityLightning)) {
            return false;
        }
        EntityLightning var3 = (EntityLightning)var0;
        return this.blocksSetOnFire.matches(var3.getBlocksSetOnFire()) && (this.entityStruck == CriterionConditionEntity.ANY || var3.getHitEntities().anyMatch(var2 -> this.entityStruck.matches(var1, var22, (Entity)var2)));
    }
}

