/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionInstanceAbstract;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.advancements.critereon.LootSerializationContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class CriterionTriggerKilledByCrossbow
extends CriterionTriggerAbstract<a> {
    static final MinecraftKey ID = new MinecraftKey("killed_by_crossbow");

    @Override
    public MinecraftKey getId() {
        return ID;
    }

    @Override
    public a createInstance(JsonObject var0, CriterionConditionEntity.b var1, LootDeserializationContext var2) {
        CriterionConditionEntity.b[] var3 = CriterionConditionEntity.b.fromJsonArray(var0, "victims", var2);
        CriterionConditionValue.IntegerRange var4 = CriterionConditionValue.IntegerRange.fromJson(var0.get("unique_entity_types"));
        return new a(var1, var3, var4);
    }

    @Override
    public void trigger(EntityPlayer var0, Collection<Entity> var1) {
        ArrayList var22 = Lists.newArrayList();
        HashSet var3 = Sets.newHashSet();
        for (Entity var5 : var1) {
            var3.add(var5.getType());
            var22.add(CriterionConditionEntity.createContext(var0, var5));
        }
        this.trigger(var0, (T var2) -> var2.matches(var22, var3.size()));
    }

    @Override
    public /* synthetic */ CriterionInstanceAbstract createInstance(JsonObject jsonObject, CriterionConditionEntity.b b2, LootDeserializationContext lootDeserializationContext) {
        return this.createInstance(jsonObject, b2, lootDeserializationContext);
    }

    public static class a
    extends CriterionInstanceAbstract {
        private final CriterionConditionEntity.b[] victims;
        private final CriterionConditionValue.IntegerRange uniqueEntityTypes;

        public a(CriterionConditionEntity.b var0, CriterionConditionEntity.b[] var1, CriterionConditionValue.IntegerRange var2) {
            super(ID, var0);
            this.victims = var1;
            this.uniqueEntityTypes = var2;
        }

        public static a crossbowKilled(CriterionConditionEntity.a ... var0) {
            CriterionConditionEntity.b[] var1 = new CriterionConditionEntity.b[var0.length];
            for (int var2 = 0; var2 < var0.length; ++var2) {
                CriterionConditionEntity.a var3 = var0[var2];
                var1[var2] = CriterionConditionEntity.b.wrap(var3.build());
            }
            return new a(CriterionConditionEntity.b.ANY, var1, CriterionConditionValue.IntegerRange.ANY);
        }

        public static a crossbowKilled(CriterionConditionValue.IntegerRange var0) {
            CriterionConditionEntity.b[] var1 = new CriterionConditionEntity.b[]{};
            return new a(CriterionConditionEntity.b.ANY, var1, var0);
        }

        public boolean matches(Collection<LootTableInfo> var0, int var1) {
            if (this.victims.length > 0) {
                ArrayList var2 = Lists.newArrayList(var0);
                for (CriterionConditionEntity.b var6 : this.victims) {
                    boolean var7 = false;
                    Iterator var8 = var2.iterator();
                    while (var8.hasNext()) {
                        LootTableInfo var9 = (LootTableInfo)var8.next();
                        if (!var6.matches(var9)) continue;
                        var8.remove();
                        var7 = true;
                        break;
                    }
                    if (var7) continue;
                    return false;
                }
            }
            return this.uniqueEntityTypes.matches(var1);
        }

        @Override
        public JsonObject serializeToJson(LootSerializationContext var0) {
            JsonObject var1 = super.serializeToJson(var0);
            var1.add("victims", CriterionConditionEntity.b.toJson(this.victims, var0));
            var1.add("unique_entity_types", this.uniqueEntityTypes.serializeToJson());
            return var1;
        }
    }
}

