/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsInstance;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;

public class CriterionConditionFluid {
    public static final CriterionConditionFluid ANY = new CriterionConditionFluid(null, null, CriterionTriggerProperties.ANY);
    @Nullable
    private final Tag<FluidType> tag;
    @Nullable
    private final FluidType fluid;
    private final CriterionTriggerProperties properties;

    public CriterionConditionFluid(@Nullable Tag<FluidType> var0, @Nullable FluidType var1, CriterionTriggerProperties var2) {
        this.tag = var0;
        this.fluid = var1;
        this.properties = var2;
    }

    public boolean matches(WorldServer var0, BlockPosition var1) {
        if (this == ANY) {
            return true;
        }
        if (!var0.isLoaded(var1)) {
            return false;
        }
        Fluid var2 = var0.getFluidState(var1);
        FluidType var3 = var2.getType();
        if (this.tag != null && !var3.is(this.tag)) {
            return false;
        }
        if (this.fluid != null && var3 != this.fluid) {
            return false;
        }
        return this.properties.matches(var2);
    }

    public static CriterionConditionFluid fromJson(@Nullable JsonElement var02) {
        Object var4;
        Object var3;
        if (var02 == null || var02.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var02, "fluid");
        FluidType var2 = null;
        if (var1.has("fluid")) {
            var3 = new MinecraftKey(ChatDeserializer.getAsString(var1, "fluid"));
            var2 = IRegistry.FLUID.get((MinecraftKey)var3);
        }
        var3 = null;
        if (var1.has("tag")) {
            var4 = new MinecraftKey(ChatDeserializer.getAsString(var1, "tag"));
            var3 = TagsInstance.getInstance().getTagOrThrow(IRegistry.FLUID_REGISTRY, (MinecraftKey)var4, var0 -> new JsonSyntaxException("Unknown fluid tag '" + var0 + "'"));
        }
        var4 = CriterionTriggerProperties.fromJson(var1.get("state"));
        return new CriterionConditionFluid((Tag<FluidType>)var3, var2, (CriterionTriggerProperties)var4);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (this.fluid != null) {
            var0.addProperty("fluid", IRegistry.FLUID.getKey(this.fluid).toString());
        }
        if (this.tag != null) {
            var0.addProperty("tag", TagsInstance.getInstance().getIdOrThrow(IRegistry.FLUID_REGISTRY, this.tag, () -> new IllegalStateException("Unknown fluid tag")).toString());
        }
        var0.add("state", this.properties.serializeToJson());
        return var0;
    }

    public static class a {
        @Nullable
        private FluidType fluid;
        @Nullable
        private Tag<FluidType> fluids;
        private CriterionTriggerProperties properties = CriterionTriggerProperties.ANY;

        private a() {
        }

        public static a fluid() {
            return new a();
        }

        public a of(FluidType var0) {
            this.fluid = var0;
            return this;
        }

        public a of(Tag<FluidType> var0) {
            this.fluids = var0;
            return this;
        }

        public a setProperties(CriterionTriggerProperties var0) {
            this.properties = var0;
            return this;
        }

        public CriterionConditionFluid build() {
            return new CriterionConditionFluid(this.fluids, this.fluid, this.properties);
        }
    }
}

