/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3D;

public class CriterionConditionDamageSource {
    public static final CriterionConditionDamageSource ANY = a.damageType().build();
    @Nullable
    private final Boolean isProjectile;
    @Nullable
    private final Boolean isExplosion;
    @Nullable
    private final Boolean bypassesArmor;
    @Nullable
    private final Boolean bypassesInvulnerability;
    @Nullable
    private final Boolean bypassesMagic;
    @Nullable
    private final Boolean isFire;
    @Nullable
    private final Boolean isMagic;
    @Nullable
    private final Boolean isLightning;
    private final CriterionConditionEntity directEntity;
    private final CriterionConditionEntity sourceEntity;

    public CriterionConditionDamageSource(@Nullable Boolean var0, @Nullable Boolean var1, @Nullable Boolean var2, @Nullable Boolean var3, @Nullable Boolean var4, @Nullable Boolean var5, @Nullable Boolean var6, @Nullable Boolean var7, CriterionConditionEntity var8, CriterionConditionEntity var9) {
        this.isProjectile = var0;
        this.isExplosion = var1;
        this.bypassesArmor = var2;
        this.bypassesInvulnerability = var3;
        this.bypassesMagic = var4;
        this.isFire = var5;
        this.isMagic = var6;
        this.isLightning = var7;
        this.directEntity = var8;
        this.sourceEntity = var9;
    }

    public boolean matches(EntityPlayer var0, DamageSource var1) {
        return this.matches(var0.getLevel(), var0.position(), var1);
    }

    public boolean matches(WorldServer var0, Vec3D var1, DamageSource var2) {
        if (this == ANY) {
            return true;
        }
        if (this.isProjectile != null && this.isProjectile.booleanValue() != var2.isProjectile()) {
            return false;
        }
        if (this.isExplosion != null && this.isExplosion.booleanValue() != var2.isExplosion()) {
            return false;
        }
        if (this.bypassesArmor != null && this.bypassesArmor.booleanValue() != var2.isBypassArmor()) {
            return false;
        }
        if (this.bypassesInvulnerability != null && this.bypassesInvulnerability.booleanValue() != var2.isBypassInvul()) {
            return false;
        }
        if (this.bypassesMagic != null && this.bypassesMagic.booleanValue() != var2.isBypassMagic()) {
            return false;
        }
        if (this.isFire != null && this.isFire.booleanValue() != var2.isFire()) {
            return false;
        }
        if (this.isMagic != null && this.isMagic.booleanValue() != var2.isMagic()) {
            return false;
        }
        if (this.isLightning != null && this.isLightning != (var2 == DamageSource.LIGHTNING_BOLT)) {
            return false;
        }
        if (!this.directEntity.matches(var0, var1, var2.getDirectEntity())) {
            return false;
        }
        return this.sourceEntity.matches(var0, var1, var2.getEntity());
    }

    public static CriterionConditionDamageSource fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var0, "damage type");
        Boolean var2 = CriterionConditionDamageSource.getOptionalBoolean(var1, "is_projectile");
        Boolean var3 = CriterionConditionDamageSource.getOptionalBoolean(var1, "is_explosion");
        Boolean var4 = CriterionConditionDamageSource.getOptionalBoolean(var1, "bypasses_armor");
        Boolean var5 = CriterionConditionDamageSource.getOptionalBoolean(var1, "bypasses_invulnerability");
        Boolean var6 = CriterionConditionDamageSource.getOptionalBoolean(var1, "bypasses_magic");
        Boolean var7 = CriterionConditionDamageSource.getOptionalBoolean(var1, "is_fire");
        Boolean var8 = CriterionConditionDamageSource.getOptionalBoolean(var1, "is_magic");
        Boolean var9 = CriterionConditionDamageSource.getOptionalBoolean(var1, "is_lightning");
        CriterionConditionEntity var10 = CriterionConditionEntity.fromJson(var1.get("direct_entity"));
        CriterionConditionEntity var11 = CriterionConditionEntity.fromJson(var1.get("source_entity"));
        return new CriterionConditionDamageSource(var2, var3, var4, var5, var6, var7, var8, var9, var10, var11);
    }

    @Nullable
    private static Boolean getOptionalBoolean(JsonObject var0, String var1) {
        return var0.has(var1) ? Boolean.valueOf(ChatDeserializer.getAsBoolean(var0, var1)) : null;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        this.addOptionally(var0, "is_projectile", this.isProjectile);
        this.addOptionally(var0, "is_explosion", this.isExplosion);
        this.addOptionally(var0, "bypasses_armor", this.bypassesArmor);
        this.addOptionally(var0, "bypasses_invulnerability", this.bypassesInvulnerability);
        this.addOptionally(var0, "bypasses_magic", this.bypassesMagic);
        this.addOptionally(var0, "is_fire", this.isFire);
        this.addOptionally(var0, "is_magic", this.isMagic);
        this.addOptionally(var0, "is_lightning", this.isLightning);
        var0.add("direct_entity", this.directEntity.serializeToJson());
        var0.add("source_entity", this.sourceEntity.serializeToJson());
        return var0;
    }

    private void addOptionally(JsonObject var0, String var1, @Nullable Boolean var2) {
        if (var2 != null) {
            var0.addProperty(var1, var2);
        }
    }

    public static class a {
        @Nullable
        private Boolean isProjectile;
        @Nullable
        private Boolean isExplosion;
        @Nullable
        private Boolean bypassesArmor;
        @Nullable
        private Boolean bypassesInvulnerability;
        @Nullable
        private Boolean bypassesMagic;
        @Nullable
        private Boolean isFire;
        @Nullable
        private Boolean isMagic;
        @Nullable
        private Boolean isLightning;
        private CriterionConditionEntity directEntity = CriterionConditionEntity.ANY;
        private CriterionConditionEntity sourceEntity = CriterionConditionEntity.ANY;

        public static a damageType() {
            return new a();
        }

        public a isProjectile(Boolean var0) {
            this.isProjectile = var0;
            return this;
        }

        public a isExplosion(Boolean var0) {
            this.isExplosion = var0;
            return this;
        }

        public a bypassesArmor(Boolean var0) {
            this.bypassesArmor = var0;
            return this;
        }

        public a bypassesInvulnerability(Boolean var0) {
            this.bypassesInvulnerability = var0;
            return this;
        }

        public a bypassesMagic(Boolean var0) {
            this.bypassesMagic = var0;
            return this;
        }

        public a isFire(Boolean var0) {
            this.isFire = var0;
            return this;
        }

        public a isMagic(Boolean var0) {
            this.isMagic = var0;
            return this;
        }

        public a isLightning(Boolean var0) {
            this.isLightning = var0;
            return this;
        }

        public a direct(CriterionConditionEntity var0) {
            this.directEntity = var0;
            return this;
        }

        public a direct(CriterionConditionEntity.a var0) {
            this.directEntity = var0.build();
            return this;
        }

        public a source(CriterionConditionEntity var0) {
            this.sourceEntity = var0;
            return this;
        }

        public a source(CriterionConditionEntity.a var0) {
            this.sourceEntity = var0.build();
            return this;
        }

        public CriterionConditionDamageSource build() {
            return new CriterionConditionDamageSource(this.isProjectile, this.isExplosion, this.bypassesArmor, this.bypassesInvulnerability, this.bypassesMagic, this.isFire, this.isMagic, this.isLightning, this.directEntity, this.sourceEntity);
        }
    }
}

