/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagsInstance;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;

public class CriterionConditionBlock {
    public static final CriterionConditionBlock ANY = new CriterionConditionBlock(null, null, CriterionTriggerProperties.ANY, CriterionConditionNBT.ANY);
    @Nullable
    private final Tag<Block> tag;
    @Nullable
    private final Set<Block> blocks;
    private final CriterionTriggerProperties properties;
    private final CriterionConditionNBT nbt;

    public CriterionConditionBlock(@Nullable Tag<Block> var0, @Nullable Set<Block> var1, CriterionTriggerProperties var2, CriterionConditionNBT var3) {
        this.tag = var0;
        this.blocks = var1;
        this.properties = var2;
        this.nbt = var3;
    }

    public boolean matches(WorldServer var0, BlockPosition var1) {
        TileEntity var3;
        if (this == ANY) {
            return true;
        }
        if (!var0.isLoaded(var1)) {
            return false;
        }
        IBlockData var2 = var0.getBlockState(var1);
        if (this.tag != null && !var2.is(this.tag)) {
            return false;
        }
        if (this.blocks != null && !this.blocks.contains(var2.getBlock())) {
            return false;
        }
        if (!this.properties.matches(var2)) {
            return false;
        }
        return this.nbt == CriterionConditionNBT.ANY || (var3 = var0.getBlockEntity(var1)) != null && this.nbt.matches(var3.saveWithFullMetadata());
    }

    public static CriterionConditionBlock fromJson(@Nullable JsonElement var02) {
        Object var6;
        Object var5;
        if (var02 == null || var02.isJsonNull()) {
            return ANY;
        }
        JsonObject var1 = ChatDeserializer.convertToJsonObject(var02, "block");
        CriterionConditionNBT var2 = CriterionConditionNBT.fromJson(var1.get("nbt"));
        ImmutableSet var3 = null;
        JsonArray var4 = ChatDeserializer.getAsJsonArray(var1, "blocks", null);
        if (var4 != null) {
            var5 = ImmutableSet.builder();
            for (JsonElement var7 : var4) {
                MinecraftKey var8 = new MinecraftKey(ChatDeserializer.convertToString(var7, "block"));
                var5.add((Object)IRegistry.BLOCK.getOptional(var8).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + var8 + "'")));
            }
            var3 = var5.build();
        }
        var5 = null;
        if (var1.has("tag")) {
            var6 = new MinecraftKey(ChatDeserializer.getAsString(var1, "tag"));
            var5 = TagsInstance.getInstance().getTagOrThrow(IRegistry.BLOCK_REGISTRY, (MinecraftKey)var6, var0 -> new JsonSyntaxException("Unknown block tag '" + var0 + "'"));
        }
        var6 = CriterionTriggerProperties.fromJson(var1.get("state"));
        return new CriterionConditionBlock((Tag<Block>)var5, (Set<Block>)var3, (CriterionTriggerProperties)var6, var2);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject var0 = new JsonObject();
        if (this.blocks != null) {
            JsonArray var1 = new JsonArray();
            for (Block var3 : this.blocks) {
                var1.add(IRegistry.BLOCK.getKey(var3).toString());
            }
            var0.add("blocks", (JsonElement)var1);
        }
        if (this.tag != null) {
            var0.addProperty("tag", TagsInstance.getInstance().getIdOrThrow(IRegistry.BLOCK_REGISTRY, this.tag, () -> new IllegalStateException("Unknown block tag")).toString());
        }
        var0.add("nbt", this.nbt.serializeToJson());
        var0.add("state", this.properties.serializeToJson());
        return var0;
    }

    public static class a {
        @Nullable
        private Set<Block> blocks;
        @Nullable
        private Tag<Block> tag;
        private CriterionTriggerProperties properties = CriterionTriggerProperties.ANY;
        private CriterionConditionNBT nbt = CriterionConditionNBT.ANY;

        private a() {
        }

        public static a block() {
            return new a();
        }

        public a of(Block ... var0) {
            this.blocks = ImmutableSet.copyOf((Object[])var0);
            return this;
        }

        public a of(Iterable<Block> var0) {
            this.blocks = ImmutableSet.copyOf(var0);
            return this;
        }

        public a of(Tag<Block> var0) {
            this.tag = var0;
            return this;
        }

        public a hasNbt(NBTTagCompound var0) {
            this.nbt = new CriterionConditionNBT(var0);
            return this;
        }

        public a setProperties(CriterionTriggerProperties var0) {
            this.properties = var0;
            return this;
        }

        public CriterionConditionBlock build() {
            return new CriterionConditionBlock(this.tag, this.blocks, this.properties, this.nbt);
        }
    }
}

