/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ChatDeserializer;

public class AdvancementProgress
implements Comparable<AdvancementProgress> {
    final Map<String, CriterionProgress> criteria;
    private String[][] requirements = new String[0][];

    private AdvancementProgress(Map<String, CriterionProgress> var0) {
        this.criteria = var0;
    }

    public AdvancementProgress() {
        this.criteria = Maps.newHashMap();
    }

    public void update(Map<String, Criterion> var0, String[][] var12) {
        Set<String> var2 = var0.keySet();
        this.criteria.entrySet().removeIf(var1 -> !var2.contains(var1.getKey()));
        for (String var4 : var2) {
            if (this.criteria.containsKey(var4)) continue;
            this.criteria.put(var4, new CriterionProgress());
        }
        this.requirements = var12;
    }

    public boolean isDone() {
        if (this.requirements.length == 0) {
            return false;
        }
        for (String[] var3 : this.requirements) {
            boolean var4 = false;
            for (String var8 : var3) {
                CriterionProgress var9 = this.getCriterion(var8);
                if (var9 == null || !var9.isDone()) continue;
                var4 = true;
                break;
            }
            if (var4) continue;
            return false;
        }
        return true;
    }

    public boolean hasProgress() {
        for (CriterionProgress var1 : this.criteria.values()) {
            if (!var1.isDone()) continue;
            return true;
        }
        return false;
    }

    public boolean grantProgress(String var0) {
        CriterionProgress var1 = this.criteria.get(var0);
        if (var1 != null && !var1.isDone()) {
            var1.grant();
            return true;
        }
        return false;
    }

    public boolean revokeProgress(String var0) {
        CriterionProgress var1 = this.criteria.get(var0);
        if (var1 != null && var1.isDone()) {
            var1.revoke();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AdvancementProgress{criteria=" + this.criteria + ", requirements=" + Arrays.deepToString((Object[])this.requirements) + "}";
    }

    public void serializeToNetwork(PacketDataSerializer var02) {
        var02.writeMap(this.criteria, PacketDataSerializer::writeUtf, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
    }

    public static AdvancementProgress fromNetwork(PacketDataSerializer var0) {
        Map<String, CriterionProgress> var1 = var0.readMap(PacketDataSerializer::readUtf, CriterionProgress::fromNetwork);
        return new AdvancementProgress(var1);
    }

    @Nullable
    public CriterionProgress getCriterion(String var0) {
        return this.criteria.get(var0);
    }

    public float getPercent() {
        if (this.criteria.isEmpty()) {
            return 0.0f;
        }
        float var0 = this.requirements.length;
        float var1 = this.countCompletedRequirements();
        return var1 / var0;
    }

    @Nullable
    public String getProgressText() {
        if (this.criteria.isEmpty()) {
            return null;
        }
        int var0 = this.requirements.length;
        if (var0 <= 1) {
            return null;
        }
        int var1 = this.countCompletedRequirements();
        return var1 + "/" + var0;
    }

    private int countCompletedRequirements() {
        int var0 = 0;
        for (String[] var4 : this.requirements) {
            boolean var5 = false;
            for (String var9 : var4) {
                CriterionProgress var10 = this.getCriterion(var9);
                if (var10 == null || !var10.isDone()) continue;
                var5 = true;
                break;
            }
            if (!var5) continue;
            ++var0;
        }
        return var0;
    }

    public Iterable<String> getRemainingCriteria() {
        ArrayList var0 = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> var2 : this.criteria.entrySet()) {
            if (var2.getValue().isDone()) continue;
            var0.add(var2.getKey());
        }
        return var0;
    }

    public Iterable<String> getCompletedCriteria() {
        ArrayList var0 = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> var2 : this.criteria.entrySet()) {
            if (!var2.getValue().isDone()) continue;
            var0.add(var2.getKey());
        }
        return var0;
    }

    @Nullable
    public Date getFirstProgressDate() {
        Date var0 = null;
        for (CriterionProgress var2 : this.criteria.values()) {
            if (!var2.isDone() || var0 != null && !var2.getObtained().before(var0)) continue;
            var0 = var2.getObtained();
        }
        return var0;
    }

    @Override
    public int compareTo(AdvancementProgress var0) {
        Date var1 = this.getFirstProgressDate();
        Date var2 = var0.getFirstProgressDate();
        if (var1 == null && var2 != null) {
            return 1;
        }
        if (var1 != null && var2 == null) {
            return -1;
        }
        if (var1 == null && var2 == null) {
            return 0;
        }
        return var1.compareTo(var2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((AdvancementProgress)object);
    }

    public static class a
    implements JsonDeserializer<AdvancementProgress>,
    JsonSerializer<AdvancementProgress> {
        public JsonElement serialize(AdvancementProgress var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            JsonObject var4 = new JsonObject();
            for (Map.Entry<String, CriterionProgress> var6 : var0.criteria.entrySet()) {
                CriterionProgress var7 = var6.getValue();
                if (!var7.isDone()) continue;
                var4.add(var6.getKey(), var7.serializeToJson());
            }
            if (!var4.entrySet().isEmpty()) {
                var3.add("criteria", (JsonElement)var4);
            }
            var3.addProperty("done", Boolean.valueOf(var0.isDone()));
            return var3;
        }

        public AdvancementProgress deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            JsonObject var3 = ChatDeserializer.convertToJsonObject(var0, "advancement");
            JsonObject var4 = ChatDeserializer.getAsJsonObject(var3, "criteria", new JsonObject());
            AdvancementProgress var5 = new AdvancementProgress();
            for (Map.Entry var7 : var4.entrySet()) {
                String var8 = (String)var7.getKey();
                var5.criteria.put(var8, CriterionProgress.fromJson(ChatDeserializer.convertToString((JsonElement)var7.getValue(), var8)));
            }
            return var5;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((AdvancementProgress)object, type, jsonSerializationContext);
        }
    }
}

