/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemUtils {
    static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_MAX_THREADS = 255;
    private static final String MAX_THREADS_SYSTEM_PROPERTY = "max.bg.threads";
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ExecutorService BOOTSTRAP_EXECUTOR = SystemUtils.makeExecutor("Bootstrap");
    private static final ExecutorService BACKGROUND_EXECUTOR = SystemUtils.makeExecutor("Main");
    private static final ExecutorService IO_POOL = SystemUtils.makeIoExecutor();
    public static LongSupplier timeSource = System::nanoTime;
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final FileSystemProvider ZIP_FILE_SYSTEM_PROVIDER = FileSystemProvider.installedProviders().stream().filter(var0 -> var0.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    private static Consumer<String> thePauser = var0 -> {};

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String getPropertyName(IBlockState<T> var0, Object var1) {
        return var0.getName((Comparable)var1);
    }

    public static String makeDescriptionId(String var0, @Nullable MinecraftKey var1) {
        if (var1 == null) {
            return var0 + ".unregistered_sadface";
        }
        return var0 + "." + var1.getNamespace() + "." + var1.getPath().replace('/', '.');
    }

    public static long getMillis() {
        return SystemUtils.getNanos() / 1000000L;
    }

    public static long getNanos() {
        return timeSource.getAsLong();
    }

    public static long getEpochMillis() {
        return Instant.now().toEpochMilli();
    }

    private static ExecutorService makeExecutor(String var0) {
        int var12 = MathHelper.clamp(Runtime.getRuntime().availableProcessors() - 1, 1, SystemUtils.getMaxThreads());
        Object var2 = var12 <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(var12, var1 -> {
            ForkJoinWorkerThread var2 = new ForkJoinWorkerThread(var1){

                @Override
                protected void onTermination(Throwable var0) {
                    if (var0 != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)var0);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(var0);
                }
            };
            var2.setName("Worker-" + var0 + "-" + WORKER_COUNT.getAndIncrement());
            return var2;
        }, SystemUtils::onThreadException, true);
        return var2;
    }

    private static int getMaxThreads() {
        String var0 = System.getProperty(MAX_THREADS_SYSTEM_PROPERTY);
        if (var0 != null) {
            try {
                int var1 = Integer.parseInt(var0);
                if (var1 >= 1 && var1 <= 255) {
                    return var1;
                }
                LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", (Object)MAX_THREADS_SYSTEM_PROPERTY, (Object)var0, (Object)255);
            }
            catch (NumberFormatException var1) {
                LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", (Object)MAX_THREADS_SYSTEM_PROPERTY, (Object)var0, (Object)255);
            }
        }
        return 255;
    }

    public static ExecutorService bootstrapExecutor() {
        return BOOTSTRAP_EXECUTOR;
    }

    public static ExecutorService backgroundExecutor() {
        return BACKGROUND_EXECUTOR;
    }

    public static ExecutorService ioPool() {
        return IO_POOL;
    }

    public static void shutdownExecutors() {
        SystemUtils.shutdownExecutor(BACKGROUND_EXECUTOR);
        SystemUtils.shutdownExecutor(IO_POOL);
    }

    private static void shutdownExecutor(ExecutorService var0) {
        boolean var1;
        var0.shutdown();
        try {
            var1 = var0.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var2) {
            var1 = false;
        }
        if (!var1) {
            var0.shutdownNow();
        }
    }

    private static ExecutorService makeIoExecutor() {
        return Executors.newCachedThreadPool(var0 -> {
            Thread var1 = new Thread(var0);
            var1.setName("IO-Worker-" + WORKER_COUNT.getAndIncrement());
            var1.setUncaughtExceptionHandler(SystemUtils::onThreadException);
            return var1;
        });
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable var0) {
        CompletableFuture var1 = new CompletableFuture();
        var1.completeExceptionally(var0);
        return var1;
    }

    public static void throwAsRuntime(Throwable var0) {
        throw var0 instanceof RuntimeException ? (RuntimeException)var0 : new RuntimeException(var0);
    }

    private static void onThreadException(Thread var0, Throwable var1) {
        SystemUtils.pauseInIde(var1);
        if (var1 instanceof CompletionException) {
            var1 = var1.getCause();
        }
        if (var1 instanceof ReportedException) {
            DispenserRegistry.realStdoutPrintln(((ReportedException)var1).getReport().getFriendlyReport());
            System.exit(-1);
        }
        LOGGER.error(String.format("Caught exception in thread %s", var0), var1);
    }

    @Nullable
    public static Type<?> fetchChoiceType(DSL.TypeReference var0, String var1) {
        if (!SharedConstants.CHECK_DATA_FIXER_SCHEMA) {
            return null;
        }
        return SystemUtils.doFetchChoiceType(var0, var1);
    }

    @Nullable
    private static Type<?> doFetchChoiceType(DSL.TypeReference var0, String var1) {
        Type var2;
        block2: {
            var2 = null;
            try {
                var2 = DataConverterRegistry.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getWorldVersion())).getChoiceType(var0, var1);
            }
            catch (IllegalArgumentException var3) {
                LOGGER.error("No data fixer registered for {}", (Object)var1);
                if (!SharedConstants.IS_RUNNING_IN_IDE) break block2;
                throw var3;
            }
        }
        return var2;
    }

    public static Runnable wrapThreadWithTaskName(String var0, Runnable var1) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return () -> {
                Thread var2 = Thread.currentThread();
                String var3 = var2.getName();
                var2.setName(var0);
                try {
                    var1.run();
                }
                finally {
                    var2.setName(var3);
                }
            };
        }
        return var1;
    }

    public static <V> Supplier<V> wrapThreadWithTaskName(String var0, Supplier<V> var1) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return () -> {
                Thread var2 = Thread.currentThread();
                String var3 = var2.getName();
                var2.setName(var0);
                try {
                    Object t2 = var1.get();
                    return t2;
                }
                finally {
                    var2.setName(var3);
                }
            };
        }
        return var1;
    }

    public static OS getPlatform() {
        String var0 = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (var0.contains("win")) {
            return OS.WINDOWS;
        }
        if (var0.contains("mac")) {
            return OS.OSX;
        }
        if (var0.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (var0.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (var0.contains("linux")) {
            return OS.LINUX;
        }
        if (var0.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static Stream<String> getVmArguments() {
        RuntimeMXBean var02 = ManagementFactory.getRuntimeMXBean();
        return var02.getInputArguments().stream().filter(var0 -> var0.startsWith("-X"));
    }

    public static <T> T lastOf(List<T> var0) {
        return var0.get(var0.size() - 1);
    }

    public static <T> T findNextInIterable(Iterable<T> var0, @Nullable T var1) {
        Iterator<T> var2 = var0.iterator();
        T var3 = var2.next();
        if (var1 != null) {
            T var4 = var3;
            while (true) {
                if (var4 == var1) {
                    if (!var2.hasNext()) break;
                    return var2.next();
                }
                if (!var2.hasNext()) continue;
                var4 = var2.next();
            }
        }
        return var3;
    }

    public static <T> T findPreviousInIterable(Iterable<T> var0, @Nullable T var1) {
        Iterator<T> var2 = var0.iterator();
        T var3 = null;
        while (var2.hasNext()) {
            T var4 = var2.next();
            if (var4 == var1) {
                if (var3 != null) break;
                var3 = (T)(var2.hasNext() ? Iterators.getLast(var2) : var1);
                break;
            }
            var3 = var4;
        }
        return var3;
    }

    public static <T> T make(Supplier<T> var0) {
        return var0.get();
    }

    public static <T> T make(T var0, Consumer<T> var1) {
        var1.accept(var0);
        return var0;
    }

    public static <K> Hash.Strategy<K> identityStrategy() {
        return IdentityHashingStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> sequence(List<? extends CompletableFuture<? extends V>> var0) {
        return var0.stream().reduce(CompletableFuture.completedFuture(Lists.newArrayList()), (var02, var12) -> var12.thenCombine((CompletionStage)var02, (var0, var1) -> {
            ArrayList var2 = Lists.newArrayListWithCapacity((int)(var1.size() + 1));
            var2.addAll(var1);
            var2.add(var0);
            return var2;
        }), (var02, var12) -> var02.thenCombine((CompletionStage)var12, (var0, var1) -> {
            ArrayList var2 = Lists.newArrayListWithCapacity((int)(var0.size() + var1.size()));
            var2.addAll(var0);
            var2.addAll(var1);
            return var2;
        }));
    }

    public static <V> CompletableFuture<List<V>> sequenceFailFast(List<? extends CompletableFuture<? extends V>> var0) {
        ArrayList var12 = Lists.newArrayListWithCapacity((int)var0.size());
        CompletableFuture[] var2 = new CompletableFuture[var0.size()];
        CompletableFuture var3 = new CompletableFuture();
        var0.forEach(var32 -> {
            int var42 = var12.size();
            var12.add(null);
            var1[var42] = var32.whenComplete((var3, var4) -> {
                if (var4 != null) {
                    var3.completeExceptionally((Throwable)var4);
                } else {
                    var12.set(var42, var3);
                }
            });
        });
        return CompletableFuture.allOf(var2).applyToEither((CompletionStage)var3, var1 -> var12);
    }

    public static <T> Stream<T> toStream(Optional<? extends T> var0) {
        return (Stream)DataFixUtils.orElseGet(var0.map(Stream::of), Stream::empty);
    }

    public static <T> Optional<T> ifElse(Optional<T> var0, Consumer<T> var1, Runnable var2) {
        if (var0.isPresent()) {
            var1.accept(var0.get());
        } else {
            var2.run();
        }
        return var0;
    }

    public static Runnable name(Runnable var0, Supplier<String> var1) {
        return var0;
    }

    public static void logAndPauseIfInIde(String var0) {
        LOGGER.error(var0);
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            SystemUtils.doPause(var0);
        }
    }

    public static <T extends Throwable> T pauseInIde(T var0) {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            LOGGER.error("Trying to throw a fatal exception, pausing in IDE", var0);
            SystemUtils.doPause(var0.getMessage());
        }
        return var0;
    }

    public static void setPause(Consumer<String> var0) {
        thePauser = var0;
    }

    private static void doPause(String var0) {
        boolean var2;
        Instant var1 = Instant.now();
        LOGGER.warn("Did you remember to set a breakpoint here?");
        boolean bl = var2 = Duration.between(var1, Instant.now()).toMillis() > 500L;
        if (!var2) {
            thePauser.accept(var0);
        }
    }

    public static String describeError(Throwable var0) {
        if (var0.getCause() != null) {
            return SystemUtils.describeError(var0.getCause());
        }
        if (var0.getMessage() != null) {
            return var0.getMessage();
        }
        return var0.toString();
    }

    public static <T> T getRandom(T[] var0, Random var1) {
        return var0[var1.nextInt(var0.length)];
    }

    public static int getRandom(int[] var0, Random var1) {
        return var0[var1.nextInt(var0.length)];
    }

    public static <T> T getRandom(List<T> var0, Random var1) {
        return var0.get(var1.nextInt(var0.size()));
    }

    private static BooleanSupplier createRenamer(final Path var0, final Path var1) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.move(var0, var1, new CopyOption[0]);
                    return true;
                }
                catch (IOException var02) {
                    LOGGER.error("Failed to rename", (Throwable)var02);
                    return false;
                }
            }

            public String toString() {
                return "rename " + var0 + " to " + var1;
            }
        };
    }

    private static BooleanSupplier createDeleter(final Path var0) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(var0);
                    return true;
                }
                catch (IOException var02) {
                    LOGGER.warn("Failed to delete", (Throwable)var02);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + var0;
            }
        };
    }

    private static BooleanSupplier createFileDeletedCheck(final Path var0) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(var0, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + var0 + " is deleted";
            }
        };
    }

    private static BooleanSupplier createFileCreatedCheck(final Path var0) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(var0, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + var0 + " is present";
            }
        };
    }

    private static boolean executeInSequence(BooleanSupplier ... var0) {
        for (BooleanSupplier var4 : var0) {
            if (var4.getAsBoolean()) continue;
            LOGGER.warn("Failed to execute {}", (Object)var4);
            return false;
        }
        return true;
    }

    private static boolean runWithRetries(int var0, String var1, BooleanSupplier ... var2) {
        for (int var3 = 0; var3 < var0; ++var3) {
            if (SystemUtils.executeInSequence(var2)) {
                return true;
            }
            LOGGER.error("Failed to {}, retrying {}/{}", (Object)var1, (Object)var3, (Object)var0);
        }
        LOGGER.error("Failed to {}, aborting, progress might be lost", (Object)var1);
        return false;
    }

    public static void safeReplaceFile(File var0, File var1, File var2) {
        SystemUtils.safeReplaceFile(var0.toPath(), var1.toPath(), var2.toPath());
    }

    public static void safeReplaceFile(Path var0, Path var1, Path var2) {
        int var3 = 10;
        if (Files.exists(var0, new LinkOption[0]) && !SystemUtils.runWithRetries(10, "create backup " + var2, SystemUtils.createDeleter(var2), SystemUtils.createRenamer(var0, var2), SystemUtils.createFileCreatedCheck(var2))) {
            return;
        }
        if (!SystemUtils.runWithRetries(10, "remove old " + var0, SystemUtils.createDeleter(var0), SystemUtils.createFileDeletedCheck(var0))) {
            return;
        }
        if (!SystemUtils.runWithRetries(10, "replace " + var0 + " with " + var1, SystemUtils.createRenamer(var1, var0), SystemUtils.createFileCreatedCheck(var0))) {
            SystemUtils.runWithRetries(10, "restore " + var0 + " from " + var2, SystemUtils.createRenamer(var2, var0), SystemUtils.createFileCreatedCheck(var0));
        }
    }

    public static int offsetByCodepoints(String var0, int var1, int var2) {
        int var3 = var0.length();
        if (var2 >= 0) {
            for (int var4 = 0; var1 < var3 && var4 < var2; ++var4) {
                if (!Character.isHighSurrogate(var0.charAt(var1++)) || var1 >= var3 || !Character.isLowSurrogate(var0.charAt(var1))) continue;
                ++var1;
            }
        } else {
            for (int var4 = var2; var1 > 0 && var4 < 0; ++var4) {
                if (!Character.isLowSurrogate(var0.charAt(--var1)) || var1 <= 0 || !Character.isHighSurrogate(var0.charAt(var1 - 1))) continue;
                --var1;
            }
        }
        return var1;
    }

    public static Consumer<String> prefix(String var0, Consumer<String> var1) {
        return var2 -> var1.accept(var0 + var2);
    }

    public static DataResult<int[]> fixedSize(IntStream var0, int var1) {
        int[] var2 = var0.limit(var1 + 1).toArray();
        if (var2.length != var1) {
            String var3 = "Input is not a list of " + var1 + " ints";
            if (var2.length >= var1) {
                return DataResult.error((String)var3, (Object)Arrays.copyOf(var2, var1));
            }
            return DataResult.error((String)var3);
        }
        return DataResult.success((Object)var2);
    }

    public static <T> DataResult<List<T>> fixedSize(List<T> var0, int var1) {
        if (var0.size() != var1) {
            String var2 = "Input is not a list of " + var1 + " elements";
            if (var0.size() >= var1) {
                return DataResult.error((String)var2, var0.subList(0, var1));
            }
            return DataResult.error((String)var2);
        }
        return DataResult.success(var0);
    }

    public static void startTimerHackThread() {
        Thread var0 = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var0) {
                    LOGGER.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        var0.setDaemon(true);
        var0.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        var0.start();
    }

    public static void copyBetweenDirs(Path var0, Path var1, Path var2) throws IOException {
        Path var3 = var0.relativize(var2);
        Path var4 = var1.resolve(var3);
        Files.copy(var2, var4, new CopyOption[0]);
    }

    public static String sanitizeName(String var0, CharPredicate var12) {
        return var0.toLowerCase(Locale.ROOT).chars().mapToObj(var1 -> var12.test((char)var1) ? Character.toString((char)var1) : "_").collect(Collectors.joining());
    }

    public static <T, R> Function<T, R> memoize(final Function<T, R> var0) {
        return new Function<T, R>(){
            private final Map<T, R> cache = Maps.newHashMap();

            @Override
            public R apply(T var02) {
                return this.cache.computeIfAbsent(var02, var0);
            }

            public String toString() {
                return "memoize/1[function=" + var0 + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(final BiFunction<T, U, R> var0) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> cache = Maps.newHashMap();

            @Override
            public R apply(T var02, U var12) {
                return this.cache.computeIfAbsent(Pair.of(var02, var12), var1 -> var0.apply(var1.getFirst(), var1.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + var0 + ", size=" + this.cache.size() + "]";
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class OS
    extends Enum<OS> {
        public static final /* enum */ OS LINUX = new OS("linux");
        public static final /* enum */ OS SOLARIS = new OS("solaris");
        public static final /* enum */ OS WINDOWS = new OS("windows"){

            @Override
            protected String[] getOpenUrlArguments(URL var0) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", var0.toString()};
            }
        };
        public static final /* enum */ OS OSX = new OS("mac"){

            @Override
            protected String[] getOpenUrlArguments(URL var0) {
                return new String[]{"open", var0.toString()};
            }
        };
        public static final /* enum */ OS UNKNOWN = new OS("unknown");
        private final String telemetryName;
        private static final /* synthetic */ OS[] g;

        public static OS[] values() {
            return (OS[])g.clone();
        }

        public static OS valueOf(String var0) {
            return Enum.valueOf(OS.class, var0);
        }

        OS(String var2) {
            this.telemetryName = var2;
        }

        public void openUrl(URL var0) {
            try {
                Process var1 = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.getOpenUrlArguments(var0)));
                for (String var3 : IOUtils.readLines((InputStream)var1.getErrorStream())) {
                    LOGGER.error(var3);
                }
                var1.getInputStream().close();
                var1.getErrorStream().close();
                var1.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException var1) {
                LOGGER.error("Couldn't open url '{}'", (Object)var0, (Object)var1);
            }
        }

        public void openUri(URI var0) {
            try {
                this.openUrl(var0.toURL());
            }
            catch (MalformedURLException var1) {
                LOGGER.error("Couldn't open uri '{}'", (Object)var0, (Object)var1);
            }
        }

        public void openFile(File var0) {
            try {
                this.openUrl(var0.toURI().toURL());
            }
            catch (MalformedURLException var1) {
                LOGGER.error("Couldn't open file '{}'", (Object)var0, (Object)var1);
            }
        }

        protected String[] getOpenUrlArguments(URL var0) {
            String var1 = var0.toString();
            if ("file".equals(var0.getProtocol())) {
                var1 = var1.replace("file:", "file://");
            }
            return new String[]{"xdg-open", var1};
        }

        public void openUri(String var0) {
            try {
                this.openUrl(new URI(var0).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException var1) {
                LOGGER.error("Couldn't open uri '{}'", (Object)var0, (Object)var1);
            }
        }

        public String telemetryName() {
            return this.telemetryName;
        }

        private static /* synthetic */ OS[] b() {
            return new OS[]{LINUX, SOLARIS, WINDOWS, OSX, UNKNOWN};
        }

        static {
            g = OS.b();
        }
    }

    static final class IdentityHashingStrategy
    extends Enum<IdentityHashingStrategy>
    implements Hash.Strategy<Object> {
        public static final /* enum */ IdentityHashingStrategy INSTANCE = new IdentityHashingStrategy();
        private static final /* synthetic */ IdentityHashingStrategy[] b;

        public static IdentityHashingStrategy[] values() {
            return (IdentityHashingStrategy[])b.clone();
        }

        public static IdentityHashingStrategy valueOf(String var0) {
            return Enum.valueOf(IdentityHashingStrategy.class, var0);
        }

        public int hashCode(Object var0) {
            return System.identityHashCode(var0);
        }

        public boolean equals(Object var0, Object var1) {
            return var0 == var1;
        }

        private static /* synthetic */ IdentityHashingStrategy[] a() {
            return new IdentityHashingStrategy[]{INSTANCE};
        }

        static {
            b = IdentityHashingStrategy.a();
        }
    }
}

