/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.util.MemoryReserve;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashReport {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String title;
    private final Throwable exception;
    private final List<CrashReportSystemDetails> details = Lists.newArrayList();
    private File saveFile;
    private boolean trackingStackTrace = true;
    private StackTraceElement[] uncategorizedStackTrace = new StackTraceElement[0];
    private final SystemReport systemReport = new SystemReport();

    public CrashReport(String var0, Throwable var1) {
        this.title = var0;
        this.exception = var1;
    }

    public String getTitle() {
        return this.title;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getDetails() {
        StringBuilder var0 = new StringBuilder();
        this.getDetails(var0);
        return var0.toString();
    }

    public void getDetails(StringBuilder var0) {
        if (!(this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0 || this.details.isEmpty())) {
            this.uncategorizedStackTrace = (StackTraceElement[])ArrayUtils.subarray((Object[])this.details.get(0).getStacktrace(), (int)0, (int)1);
        }
        if (this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0) {
            var0.append("-- Head --\n");
            var0.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            var0.append("Stacktrace:\n");
            for (StackTraceElement var4 : this.uncategorizedStackTrace) {
                var0.append("\t").append("at ").append(var4);
                var0.append("\n");
            }
            var0.append("\n");
        }
        for (CrashReportSystemDetails var2 : this.details) {
            var2.getDetails(var0);
            var0.append("\n\n");
        }
        this.systemReport.appendToCrashReportString(var0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionMessage() {
        String string;
        StringWriter var0 = null;
        PrintWriter var1 = null;
        Throwable var2 = this.exception;
        if (var2.getMessage() == null) {
            if (var2 instanceof NullPointerException) {
                var2 = new NullPointerException(this.title);
            } else if (var2 instanceof StackOverflowError) {
                var2 = new StackOverflowError(this.title);
            } else if (var2 instanceof OutOfMemoryError) {
                var2 = new OutOfMemoryError(this.title);
            }
            var2.setStackTrace(this.exception.getStackTrace());
        }
        try {
            var0 = new StringWriter();
            var1 = new PrintWriter(var0);
            var2.printStackTrace(var1);
            string = var0.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)var0);
            IOUtils.closeQuietly(var1);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)var0);
        IOUtils.closeQuietly((Writer)var1);
        return string;
    }

    public String getFriendlyReport() {
        StringBuilder var0 = new StringBuilder();
        var0.append("---- Minecraft Crash Report ----\n");
        var0.append("// ");
        var0.append(CrashReport.getErrorComment());
        var0.append("\n\n");
        var0.append("Time: ");
        var0.append(new SimpleDateFormat().format(new Date()));
        var0.append("\n");
        var0.append("Description: ");
        var0.append(this.title);
        var0.append("\n\n");
        var0.append(this.getExceptionMessage());
        var0.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int var1 = 0; var1 < 87; ++var1) {
            var0.append("-");
        }
        var0.append("\n\n");
        this.getDetails(var0);
        return var0.toString();
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToFile(File var0) {
        boolean bl;
        if (this.saveFile != null) {
            return false;
        }
        if (var0.getParentFile() != null) {
            var0.getParentFile().mkdirs();
        }
        OutputStreamWriter var1 = null;
        try {
            var1 = new OutputStreamWriter((OutputStream)new FileOutputStream(var0), StandardCharsets.UTF_8);
            var1.write(this.getFriendlyReport());
            this.saveFile = var0;
            bl = true;
        }
        catch (Throwable var2) {
            boolean bl2;
            try {
                LOGGER.error("Could not save crash report to {}", (Object)var0, (Object)var2);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(var1);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)var1);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)var1);
        return bl;
    }

    public SystemReport getSystemReport() {
        return this.systemReport;
    }

    public CrashReportSystemDetails addCategory(String var0) {
        return this.addCategory(var0, 1);
    }

    public CrashReportSystemDetails addCategory(String var0, int var1) {
        CrashReportSystemDetails var2 = new CrashReportSystemDetails(var0);
        if (this.trackingStackTrace) {
            int var3 = var2.fillInStackTrace(var1);
            StackTraceElement[] var4 = this.exception.getStackTrace();
            StackTraceElement var5 = null;
            StackTraceElement var6 = null;
            int var7 = var4.length - var3;
            if (var7 < 0) {
                System.out.println("Negative index in crash report handler (" + var4.length + "/" + var3 + ")");
            }
            if (var4 != null && 0 <= var7 && var7 < var4.length) {
                var5 = var4[var7];
                if (var4.length + 1 - var3 < var4.length) {
                    var6 = var4[var4.length + 1 - var3];
                }
            }
            this.trackingStackTrace = var2.validateStackTrace(var5, var6);
            if (var3 > 0 && !this.details.isEmpty()) {
                CrashReportSystemDetails var8 = this.details.get(this.details.size() - 1);
                var8.trimStacktrace(var3);
            } else if (var4 != null && var4.length >= var3 && 0 <= var7 && var7 < var4.length) {
                this.uncategorizedStackTrace = new StackTraceElement[var7];
                System.arraycopy(var4, 0, this.uncategorizedStackTrace, 0, this.uncategorizedStackTrace.length);
            } else {
                this.trackingStackTrace = false;
            }
        }
        this.details.add(var2);
        return var2;
    }

    private static String getErrorComment() {
        String[] var0 = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return var0[(int)(SystemUtils.getNanos() % (long)var0.length)];
        }
        catch (Throwable var1) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport forThrowable(Throwable var0, String var1) {
        while (var0 instanceof CompletionException && var0.getCause() != null) {
            var0 = var0.getCause();
        }
        CrashReport var2 = var0 instanceof ReportedException ? ((ReportedException)var0).getReport() : new CrashReport(var1, var0);
        return var2;
    }

    public static void preload() {
        MemoryReserve.allocate();
        new CrashReport("Don't panic!", new Throwable()).getFriendlyReport();
    }
}

