/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3fa;
import java.nio.FloatBuffer;

public final class Matrix4f {
    private static final int ORDER = 4;
    protected float m00;
    protected float m01;
    protected float m02;
    protected float m03;
    protected float m10;
    protected float m11;
    protected float m12;
    protected float m13;
    protected float m20;
    protected float m21;
    protected float m22;
    protected float m23;
    protected float m30;
    protected float m31;
    protected float m32;
    protected float m33;

    public Matrix4f() {
    }

    public Matrix4f(Matrix4f var0) {
        this.m00 = var0.m00;
        this.m01 = var0.m01;
        this.m02 = var0.m02;
        this.m03 = var0.m03;
        this.m10 = var0.m10;
        this.m11 = var0.m11;
        this.m12 = var0.m12;
        this.m13 = var0.m13;
        this.m20 = var0.m20;
        this.m21 = var0.m21;
        this.m22 = var0.m22;
        this.m23 = var0.m23;
        this.m30 = var0.m30;
        this.m31 = var0.m31;
        this.m32 = var0.m32;
        this.m33 = var0.m33;
    }

    public Matrix4f(Quaternion var0) {
        float var1 = var0.i();
        float var2 = var0.j();
        float var3 = var0.k();
        float var4 = var0.r();
        float var5 = 2.0f * var1 * var1;
        float var6 = 2.0f * var2 * var2;
        float var7 = 2.0f * var3 * var3;
        this.m00 = 1.0f - var6 - var7;
        this.m11 = 1.0f - var7 - var5;
        this.m22 = 1.0f - var5 - var6;
        this.m33 = 1.0f;
        float var8 = var1 * var2;
        float var9 = var2 * var3;
        float var10 = var3 * var1;
        float var11 = var1 * var4;
        float var12 = var2 * var4;
        float var13 = var3 * var4;
        this.m10 = 2.0f * (var8 + var13);
        this.m01 = 2.0f * (var8 - var13);
        this.m20 = 2.0f * (var10 - var12);
        this.m02 = 2.0f * (var10 + var12);
        this.m21 = 2.0f * (var9 + var11);
        this.m12 = 2.0f * (var9 - var11);
    }

    public boolean isInteger() {
        Matrix4f var0 = new Matrix4f();
        var0.m30 = 1.0f;
        var0.m31 = 1.0f;
        var0.m32 = 1.0f;
        var0.m33 = 0.0f;
        Matrix4f var1 = this.copy();
        var1.multiply(var0);
        return Matrix4f.isInteger(var1.m00 / var1.m03) && Matrix4f.isInteger(var1.m10 / var1.m13) && Matrix4f.isInteger(var1.m20 / var1.m23) && Matrix4f.isInteger(var1.m01 / var1.m03) && Matrix4f.isInteger(var1.m11 / var1.m13) && Matrix4f.isInteger(var1.m21 / var1.m23) && Matrix4f.isInteger(var1.m02 / var1.m03) && Matrix4f.isInteger(var1.m12 / var1.m13) && Matrix4f.isInteger(var1.m22 / var1.m23);
    }

    private static boolean isInteger(float var0) {
        return (double)Math.abs(var0 - (float)Math.round(var0)) <= 1.0E-5;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        Matrix4f var1 = (Matrix4f)var0;
        return Float.compare(var1.m00, this.m00) == 0 && Float.compare(var1.m01, this.m01) == 0 && Float.compare(var1.m02, this.m02) == 0 && Float.compare(var1.m03, this.m03) == 0 && Float.compare(var1.m10, this.m10) == 0 && Float.compare(var1.m11, this.m11) == 0 && Float.compare(var1.m12, this.m12) == 0 && Float.compare(var1.m13, this.m13) == 0 && Float.compare(var1.m20, this.m20) == 0 && Float.compare(var1.m21, this.m21) == 0 && Float.compare(var1.m22, this.m22) == 0 && Float.compare(var1.m23, this.m23) == 0 && Float.compare(var1.m30, this.m30) == 0 && Float.compare(var1.m31, this.m31) == 0 && Float.compare(var1.m32, this.m32) == 0 && Float.compare(var1.m33, this.m33) == 0;
    }

    public int hashCode() {
        int var0 = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        var0 = 31 * var0 + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        var0 = 31 * var0 + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        var0 = 31 * var0 + (this.m03 != 0.0f ? Float.floatToIntBits(this.m03) : 0);
        var0 = 31 * var0 + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        var0 = 31 * var0 + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        var0 = 31 * var0 + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        var0 = 31 * var0 + (this.m13 != 0.0f ? Float.floatToIntBits(this.m13) : 0);
        var0 = 31 * var0 + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        var0 = 31 * var0 + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        var0 = 31 * var0 + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        var0 = 31 * var0 + (this.m23 != 0.0f ? Float.floatToIntBits(this.m23) : 0);
        var0 = 31 * var0 + (this.m30 != 0.0f ? Float.floatToIntBits(this.m30) : 0);
        var0 = 31 * var0 + (this.m31 != 0.0f ? Float.floatToIntBits(this.m31) : 0);
        var0 = 31 * var0 + (this.m32 != 0.0f ? Float.floatToIntBits(this.m32) : 0);
        var0 = 31 * var0 + (this.m33 != 0.0f ? Float.floatToIntBits(this.m33) : 0);
        return var0;
    }

    private static int bufferIndex(int var0, int var1) {
        return var1 * 4 + var0;
    }

    public void load(FloatBuffer var0) {
        this.m00 = var0.get(Matrix4f.bufferIndex(0, 0));
        this.m01 = var0.get(Matrix4f.bufferIndex(0, 1));
        this.m02 = var0.get(Matrix4f.bufferIndex(0, 2));
        this.m03 = var0.get(Matrix4f.bufferIndex(0, 3));
        this.m10 = var0.get(Matrix4f.bufferIndex(1, 0));
        this.m11 = var0.get(Matrix4f.bufferIndex(1, 1));
        this.m12 = var0.get(Matrix4f.bufferIndex(1, 2));
        this.m13 = var0.get(Matrix4f.bufferIndex(1, 3));
        this.m20 = var0.get(Matrix4f.bufferIndex(2, 0));
        this.m21 = var0.get(Matrix4f.bufferIndex(2, 1));
        this.m22 = var0.get(Matrix4f.bufferIndex(2, 2));
        this.m23 = var0.get(Matrix4f.bufferIndex(2, 3));
        this.m30 = var0.get(Matrix4f.bufferIndex(3, 0));
        this.m31 = var0.get(Matrix4f.bufferIndex(3, 1));
        this.m32 = var0.get(Matrix4f.bufferIndex(3, 2));
        this.m33 = var0.get(Matrix4f.bufferIndex(3, 3));
    }

    public void loadTransposed(FloatBuffer var0) {
        this.m00 = var0.get(Matrix4f.bufferIndex(0, 0));
        this.m01 = var0.get(Matrix4f.bufferIndex(1, 0));
        this.m02 = var0.get(Matrix4f.bufferIndex(2, 0));
        this.m03 = var0.get(Matrix4f.bufferIndex(3, 0));
        this.m10 = var0.get(Matrix4f.bufferIndex(0, 1));
        this.m11 = var0.get(Matrix4f.bufferIndex(1, 1));
        this.m12 = var0.get(Matrix4f.bufferIndex(2, 1));
        this.m13 = var0.get(Matrix4f.bufferIndex(3, 1));
        this.m20 = var0.get(Matrix4f.bufferIndex(0, 2));
        this.m21 = var0.get(Matrix4f.bufferIndex(1, 2));
        this.m22 = var0.get(Matrix4f.bufferIndex(2, 2));
        this.m23 = var0.get(Matrix4f.bufferIndex(3, 2));
        this.m30 = var0.get(Matrix4f.bufferIndex(0, 3));
        this.m31 = var0.get(Matrix4f.bufferIndex(1, 3));
        this.m32 = var0.get(Matrix4f.bufferIndex(2, 3));
        this.m33 = var0.get(Matrix4f.bufferIndex(3, 3));
    }

    public void load(FloatBuffer var0, boolean var1) {
        if (var1) {
            this.loadTransposed(var0);
        } else {
            this.load(var0);
        }
    }

    public void load(Matrix4f var0) {
        this.m00 = var0.m00;
        this.m01 = var0.m01;
        this.m02 = var0.m02;
        this.m03 = var0.m03;
        this.m10 = var0.m10;
        this.m11 = var0.m11;
        this.m12 = var0.m12;
        this.m13 = var0.m13;
        this.m20 = var0.m20;
        this.m21 = var0.m21;
        this.m22 = var0.m22;
        this.m23 = var0.m23;
        this.m30 = var0.m30;
        this.m31 = var0.m31;
        this.m32 = var0.m32;
        this.m33 = var0.m33;
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        var0.append("Matrix4f:\n");
        var0.append(this.m00);
        var0.append(" ");
        var0.append(this.m01);
        var0.append(" ");
        var0.append(this.m02);
        var0.append(" ");
        var0.append(this.m03);
        var0.append("\n");
        var0.append(this.m10);
        var0.append(" ");
        var0.append(this.m11);
        var0.append(" ");
        var0.append(this.m12);
        var0.append(" ");
        var0.append(this.m13);
        var0.append("\n");
        var0.append(this.m20);
        var0.append(" ");
        var0.append(this.m21);
        var0.append(" ");
        var0.append(this.m22);
        var0.append(" ");
        var0.append(this.m23);
        var0.append("\n");
        var0.append(this.m30);
        var0.append(" ");
        var0.append(this.m31);
        var0.append(" ");
        var0.append(this.m32);
        var0.append(" ");
        var0.append(this.m33);
        var0.append("\n");
        return var0.toString();
    }

    public void store(FloatBuffer var0) {
        var0.put(Matrix4f.bufferIndex(0, 0), this.m00);
        var0.put(Matrix4f.bufferIndex(0, 1), this.m01);
        var0.put(Matrix4f.bufferIndex(0, 2), this.m02);
        var0.put(Matrix4f.bufferIndex(0, 3), this.m03);
        var0.put(Matrix4f.bufferIndex(1, 0), this.m10);
        var0.put(Matrix4f.bufferIndex(1, 1), this.m11);
        var0.put(Matrix4f.bufferIndex(1, 2), this.m12);
        var0.put(Matrix4f.bufferIndex(1, 3), this.m13);
        var0.put(Matrix4f.bufferIndex(2, 0), this.m20);
        var0.put(Matrix4f.bufferIndex(2, 1), this.m21);
        var0.put(Matrix4f.bufferIndex(2, 2), this.m22);
        var0.put(Matrix4f.bufferIndex(2, 3), this.m23);
        var0.put(Matrix4f.bufferIndex(3, 0), this.m30);
        var0.put(Matrix4f.bufferIndex(3, 1), this.m31);
        var0.put(Matrix4f.bufferIndex(3, 2), this.m32);
        var0.put(Matrix4f.bufferIndex(3, 3), this.m33);
    }

    public void storeTransposed(FloatBuffer var0) {
        var0.put(Matrix4f.bufferIndex(0, 0), this.m00);
        var0.put(Matrix4f.bufferIndex(1, 0), this.m01);
        var0.put(Matrix4f.bufferIndex(2, 0), this.m02);
        var0.put(Matrix4f.bufferIndex(3, 0), this.m03);
        var0.put(Matrix4f.bufferIndex(0, 1), this.m10);
        var0.put(Matrix4f.bufferIndex(1, 1), this.m11);
        var0.put(Matrix4f.bufferIndex(2, 1), this.m12);
        var0.put(Matrix4f.bufferIndex(3, 1), this.m13);
        var0.put(Matrix4f.bufferIndex(0, 2), this.m20);
        var0.put(Matrix4f.bufferIndex(1, 2), this.m21);
        var0.put(Matrix4f.bufferIndex(2, 2), this.m22);
        var0.put(Matrix4f.bufferIndex(3, 2), this.m23);
        var0.put(Matrix4f.bufferIndex(0, 3), this.m30);
        var0.put(Matrix4f.bufferIndex(1, 3), this.m31);
        var0.put(Matrix4f.bufferIndex(2, 3), this.m32);
        var0.put(Matrix4f.bufferIndex(3, 3), this.m33);
    }

    public void store(FloatBuffer var0, boolean var1) {
        if (var1) {
            this.storeTransposed(var0);
        } else {
            this.store(var0);
        }
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public float adjugateAndDet() {
        float var0 = this.m00 * this.m11 - this.m01 * this.m10;
        float var1 = this.m00 * this.m12 - this.m02 * this.m10;
        float var2 = this.m00 * this.m13 - this.m03 * this.m10;
        float var3 = this.m01 * this.m12 - this.m02 * this.m11;
        float var4 = this.m01 * this.m13 - this.m03 * this.m11;
        float var5 = this.m02 * this.m13 - this.m03 * this.m12;
        float var6 = this.m20 * this.m31 - this.m21 * this.m30;
        float var7 = this.m20 * this.m32 - this.m22 * this.m30;
        float var8 = this.m20 * this.m33 - this.m23 * this.m30;
        float var9 = this.m21 * this.m32 - this.m22 * this.m31;
        float var10 = this.m21 * this.m33 - this.m23 * this.m31;
        float var11 = this.m22 * this.m33 - this.m23 * this.m32;
        float var12 = this.m11 * var11 - this.m12 * var10 + this.m13 * var9;
        float var13 = -this.m10 * var11 + this.m12 * var8 - this.m13 * var7;
        float var14 = this.m10 * var10 - this.m11 * var8 + this.m13 * var6;
        float var15 = -this.m10 * var9 + this.m11 * var7 - this.m12 * var6;
        float var16 = -this.m01 * var11 + this.m02 * var10 - this.m03 * var9;
        float var17 = this.m00 * var11 - this.m02 * var8 + this.m03 * var7;
        float var18 = -this.m00 * var10 + this.m01 * var8 - this.m03 * var6;
        float var19 = this.m00 * var9 - this.m01 * var7 + this.m02 * var6;
        float var20 = this.m31 * var5 - this.m32 * var4 + this.m33 * var3;
        float var21 = -this.m30 * var5 + this.m32 * var2 - this.m33 * var1;
        float var22 = this.m30 * var4 - this.m31 * var2 + this.m33 * var0;
        float var23 = -this.m30 * var3 + this.m31 * var1 - this.m32 * var0;
        float var24 = -this.m21 * var5 + this.m22 * var4 - this.m23 * var3;
        float var25 = this.m20 * var5 - this.m22 * var2 + this.m23 * var1;
        float var26 = -this.m20 * var4 + this.m21 * var2 - this.m23 * var0;
        float var27 = this.m20 * var3 - this.m21 * var1 + this.m22 * var0;
        this.m00 = var12;
        this.m10 = var13;
        this.m20 = var14;
        this.m30 = var15;
        this.m01 = var16;
        this.m11 = var17;
        this.m21 = var18;
        this.m31 = var19;
        this.m02 = var20;
        this.m12 = var21;
        this.m22 = var22;
        this.m32 = var23;
        this.m03 = var24;
        this.m13 = var25;
        this.m23 = var26;
        this.m33 = var27;
        return var0 * var11 - var1 * var10 + var2 * var9 + var3 * var8 - var4 * var7 + var5 * var6;
    }

    public float determinant() {
        float var0 = this.m00 * this.m11 - this.m01 * this.m10;
        float var1 = this.m00 * this.m12 - this.m02 * this.m10;
        float var2 = this.m00 * this.m13 - this.m03 * this.m10;
        float var3 = this.m01 * this.m12 - this.m02 * this.m11;
        float var4 = this.m01 * this.m13 - this.m03 * this.m11;
        float var5 = this.m02 * this.m13 - this.m03 * this.m12;
        float var6 = this.m20 * this.m31 - this.m21 * this.m30;
        float var7 = this.m20 * this.m32 - this.m22 * this.m30;
        float var8 = this.m20 * this.m33 - this.m23 * this.m30;
        float var9 = this.m21 * this.m32 - this.m22 * this.m31;
        float var10 = this.m21 * this.m33 - this.m23 * this.m31;
        float var11 = this.m22 * this.m33 - this.m23 * this.m32;
        return var0 * var11 - var1 * var10 + var2 * var9 + var3 * var8 - var4 * var7 + var5 * var6;
    }

    public void transpose() {
        float var0 = this.m10;
        this.m10 = this.m01;
        this.m01 = var0;
        var0 = this.m20;
        this.m20 = this.m02;
        this.m02 = var0;
        var0 = this.m21;
        this.m21 = this.m12;
        this.m12 = var0;
        var0 = this.m30;
        this.m30 = this.m03;
        this.m03 = var0;
        var0 = this.m31;
        this.m31 = this.m13;
        this.m13 = var0;
        var0 = this.m32;
        this.m32 = this.m23;
        this.m23 = var0;
    }

    public boolean invert() {
        float var0 = this.adjugateAndDet();
        if (Math.abs(var0) > 1.0E-6f) {
            this.multiply(var0);
            return true;
        }
        return false;
    }

    public void multiply(Matrix4f var0) {
        float var1 = this.m00 * var0.m00 + this.m01 * var0.m10 + this.m02 * var0.m20 + this.m03 * var0.m30;
        float var2 = this.m00 * var0.m01 + this.m01 * var0.m11 + this.m02 * var0.m21 + this.m03 * var0.m31;
        float var3 = this.m00 * var0.m02 + this.m01 * var0.m12 + this.m02 * var0.m22 + this.m03 * var0.m32;
        float var4 = this.m00 * var0.m03 + this.m01 * var0.m13 + this.m02 * var0.m23 + this.m03 * var0.m33;
        float var5 = this.m10 * var0.m00 + this.m11 * var0.m10 + this.m12 * var0.m20 + this.m13 * var0.m30;
        float var6 = this.m10 * var0.m01 + this.m11 * var0.m11 + this.m12 * var0.m21 + this.m13 * var0.m31;
        float var7 = this.m10 * var0.m02 + this.m11 * var0.m12 + this.m12 * var0.m22 + this.m13 * var0.m32;
        float var8 = this.m10 * var0.m03 + this.m11 * var0.m13 + this.m12 * var0.m23 + this.m13 * var0.m33;
        float var9 = this.m20 * var0.m00 + this.m21 * var0.m10 + this.m22 * var0.m20 + this.m23 * var0.m30;
        float var10 = this.m20 * var0.m01 + this.m21 * var0.m11 + this.m22 * var0.m21 + this.m23 * var0.m31;
        float var11 = this.m20 * var0.m02 + this.m21 * var0.m12 + this.m22 * var0.m22 + this.m23 * var0.m32;
        float var12 = this.m20 * var0.m03 + this.m21 * var0.m13 + this.m22 * var0.m23 + this.m23 * var0.m33;
        float var13 = this.m30 * var0.m00 + this.m31 * var0.m10 + this.m32 * var0.m20 + this.m33 * var0.m30;
        float var14 = this.m30 * var0.m01 + this.m31 * var0.m11 + this.m32 * var0.m21 + this.m33 * var0.m31;
        float var15 = this.m30 * var0.m02 + this.m31 * var0.m12 + this.m32 * var0.m22 + this.m33 * var0.m32;
        float var16 = this.m30 * var0.m03 + this.m31 * var0.m13 + this.m32 * var0.m23 + this.m33 * var0.m33;
        this.m00 = var1;
        this.m01 = var2;
        this.m02 = var3;
        this.m03 = var4;
        this.m10 = var5;
        this.m11 = var6;
        this.m12 = var7;
        this.m13 = var8;
        this.m20 = var9;
        this.m21 = var10;
        this.m22 = var11;
        this.m23 = var12;
        this.m30 = var13;
        this.m31 = var14;
        this.m32 = var15;
        this.m33 = var16;
    }

    public void multiply(Quaternion var0) {
        this.multiply(new Matrix4f(var0));
    }

    public void multiply(float var0) {
        this.m00 *= var0;
        this.m01 *= var0;
        this.m02 *= var0;
        this.m03 *= var0;
        this.m10 *= var0;
        this.m11 *= var0;
        this.m12 *= var0;
        this.m13 *= var0;
        this.m20 *= var0;
        this.m21 *= var0;
        this.m22 *= var0;
        this.m23 *= var0;
        this.m30 *= var0;
        this.m31 *= var0;
        this.m32 *= var0;
        this.m33 *= var0;
    }

    public void add(Matrix4f var0) {
        this.m00 += var0.m00;
        this.m01 += var0.m01;
        this.m02 += var0.m02;
        this.m03 += var0.m03;
        this.m10 += var0.m10;
        this.m11 += var0.m11;
        this.m12 += var0.m12;
        this.m13 += var0.m13;
        this.m20 += var0.m20;
        this.m21 += var0.m21;
        this.m22 += var0.m22;
        this.m23 += var0.m23;
        this.m30 += var0.m30;
        this.m31 += var0.m31;
        this.m32 += var0.m32;
        this.m33 += var0.m33;
    }

    public void subtract(Matrix4f var0) {
        this.m00 -= var0.m00;
        this.m01 -= var0.m01;
        this.m02 -= var0.m02;
        this.m03 -= var0.m03;
        this.m10 -= var0.m10;
        this.m11 -= var0.m11;
        this.m12 -= var0.m12;
        this.m13 -= var0.m13;
        this.m20 -= var0.m20;
        this.m21 -= var0.m21;
        this.m22 -= var0.m22;
        this.m23 -= var0.m23;
        this.m30 -= var0.m30;
        this.m31 -= var0.m31;
        this.m32 -= var0.m32;
        this.m33 -= var0.m33;
    }

    public float trace() {
        return this.m00 + this.m11 + this.m22 + this.m33;
    }

    public static Matrix4f perspective(double var0, float var2, float var3, float var4) {
        float var5 = (float)(1.0 / Math.tan(var0 * 0.01745329238474369 / 2.0));
        Matrix4f var6 = new Matrix4f();
        var6.m00 = var5 / var2;
        var6.m11 = var5;
        var6.m22 = (var4 + var3) / (var3 - var4);
        var6.m32 = -1.0f;
        var6.m23 = 2.0f * var4 * var3 / (var3 - var4);
        return var6;
    }

    public static Matrix4f orthographic(float var0, float var1, float var2, float var3) {
        Matrix4f var4 = new Matrix4f();
        var4.m00 = 2.0f / var0;
        var4.m11 = 2.0f / var1;
        float var5 = var3 - var2;
        var4.m22 = -2.0f / var5;
        var4.m33 = 1.0f;
        var4.m03 = -1.0f;
        var4.m13 = 1.0f;
        var4.m23 = -(var3 + var2) / var5;
        return var4;
    }

    public static Matrix4f orthographic(float var0, float var1, float var2, float var3, float var4, float var5) {
        Matrix4f var6 = new Matrix4f();
        float var7 = var1 - var0;
        float var8 = var2 - var3;
        float var9 = var5 - var4;
        var6.m00 = 2.0f / var7;
        var6.m11 = 2.0f / var8;
        var6.m22 = -2.0f / var9;
        var6.m03 = -(var1 + var0) / var7;
        var6.m13 = -(var2 + var3) / var8;
        var6.m23 = -(var5 + var4) / var9;
        var6.m33 = 1.0f;
        return var6;
    }

    public void translate(Vector3fa var0) {
        this.m03 += var0.x();
        this.m13 += var0.y();
        this.m23 += var0.z();
    }

    public Matrix4f copy() {
        return new Matrix4f(this);
    }

    public void multiplyWithTranslation(float var0, float var1, float var2) {
        this.m03 = this.m00 * var0 + this.m01 * var1 + this.m02 * var2 + this.m03;
        this.m13 = this.m10 * var0 + this.m11 * var1 + this.m12 * var2 + this.m13;
        this.m23 = this.m20 * var0 + this.m21 * var1 + this.m22 * var2 + this.m23;
        this.m33 = this.m30 * var0 + this.m31 * var1 + this.m32 * var2 + this.m33;
    }

    public static Matrix4f createScaleMatrix(float var0, float var1, float var2) {
        Matrix4f var3 = new Matrix4f();
        var3.m00 = var0;
        var3.m11 = var1;
        var3.m22 = var2;
        var3.m33 = 1.0f;
        return var3;
    }

    public static Matrix4f createTranslateMatrix(float var0, float var1, float var2) {
        Matrix4f var3 = new Matrix4f();
        var3.m00 = 1.0f;
        var3.m11 = 1.0f;
        var3.m22 = 1.0f;
        var3.m33 = 1.0f;
        var3.m03 = var0;
        var3.m13 = var1;
        var3.m23 = var2;
        return var3;
    }
}

