/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class VoxelShapeArray
extends VoxelShape {
    private final DoubleList xs;
    private final DoubleList ys;
    private final DoubleList zs;

    protected VoxelShapeArray(VoxelShapeDiscrete var0, double[] var1, double[] var2, double[] var3) {
        this(var0, (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(var1, var0.getXSize() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(var2, var0.getYSize() + 1)), (DoubleList)DoubleArrayList.wrap((double[])Arrays.copyOf(var3, var0.getZSize() + 1)));
    }

    VoxelShapeArray(VoxelShapeDiscrete var0, DoubleList var1, DoubleList var2, DoubleList var3) {
        super(var0);
        int var4 = var0.getXSize() + 1;
        int var5 = var0.getYSize() + 1;
        int var6 = var0.getZSize() + 1;
        if (var4 != var1.size() || var5 != var2.size() || var6 != var3.size()) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("Lengths of point arrays must be consistent with the size of the VoxelShape."));
        }
        this.xs = var1;
        this.ys = var2;
        this.zs = var3;
    }

    @Override
    protected DoubleList getCoords(EnumDirection.EnumAxis var0) {
        switch (var0) {
            case X: {
                return this.xs;
            }
            case Y: {
                return this.ys;
            }
            case Z: {
                return this.zs;
            }
        }
        throw new IllegalArgumentException();
    }
}

