/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionRandomChanceWithLooting
implements LootItemCondition {
    final float percent;
    final float lootingMultiplier;

    LootItemConditionRandomChanceWithLooting(float var0, float var1) {
        this.percent = var0;
        this.lootingMultiplier = var1;
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.RANDOM_CHANCE_WITH_LOOTING;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.KILLER_ENTITY);
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(LootContextParameters.KILLER_ENTITY);
        int var2 = 0;
        if (var1 instanceof EntityLiving) {
            var2 = EnchantmentManager.getMobLooting((EntityLiving)var1);
        }
        return var0.getRandom().nextFloat() < this.percent + (float)var2 * this.lootingMultiplier;
    }

    public static LootItemCondition.a randomChanceAndLootingBoost(float var0, float var1) {
        return () -> new LootItemConditionRandomChanceWithLooting(var0, var1);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionRandomChanceWithLooting> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionRandomChanceWithLooting var1, JsonSerializationContext var2) {
            var0.addProperty("chance", (Number)Float.valueOf(var1.percent));
            var0.addProperty("looting_multiplier", (Number)Float.valueOf(var1.lootingMultiplier));
        }

        @Override
        public LootItemConditionRandomChanceWithLooting deserialize(JsonObject var0, JsonDeserializationContext var1) {
            return new LootItemConditionRandomChanceWithLooting(ChatDeserializer.getAsFloat(var0, "chance"), ChatDeserializer.getAsFloat(var0, "looting_multiplier"));
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

