/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionAlternative
implements LootItemCondition {
    final LootItemCondition[] terms;
    private final Predicate<LootTableInfo> composedPredicate;

    LootItemConditionAlternative(LootItemCondition[] var0) {
        this.terms = var0;
        this.composedPredicate = LootItemConditions.orConditions(var0);
    }

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ALTERNATIVE;
    }

    @Override
    public final boolean test(LootTableInfo var0) {
        return this.composedPredicate.test(var0);
    }

    @Override
    public void validate(LootCollector var0) {
        LootItemCondition.super.validate(var0);
        for (int var1 = 0; var1 < this.terms.length; ++var1) {
            this.terms[var1].validate(var0.forChild(".term[" + var1 + "]"));
        }
    }

    public static a alternative(LootItemCondition.a ... var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final List<LootItemCondition> terms = Lists.newArrayList();

        public a(LootItemCondition.a ... var0) {
            for (LootItemCondition.a var4 : var0) {
                this.terms.add(var4.build());
            }
        }

        @Override
        public a or(LootItemCondition.a var0) {
            this.terms.add(var0.build());
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new LootItemConditionAlternative(this.terms.toArray(new LootItemCondition[0]));
        }
    }

    public static class b
    implements LootSerializer<LootItemConditionAlternative> {
        @Override
        public void serialize(JsonObject var0, LootItemConditionAlternative var1, JsonSerializationContext var2) {
            var0.add("terms", var2.serialize((Object)var1.terms));
        }

        @Override
        public LootItemConditionAlternative deserialize(JsonObject var0, JsonDeserializationContext var1) {
            LootItemCondition[] var2 = ChatDeserializer.getAsObject(var0, "terms", var1, LootItemCondition[].class);
            return new LootItemConditionAlternative(var2);
        }

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }
}

