/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootItemFunctionSetName
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogManager.getLogger();
    final IChatBaseComponent name;
    @Nullable
    final LootTableInfo.EntityTarget resolutionContext;

    LootItemFunctionSetName(LootItemCondition[] var0, @Nullable IChatBaseComponent var1, @Nullable LootTableInfo.EntityTarget var2) {
        super(var0);
        this.name = var1;
        this.resolutionContext = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_NAME;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.resolutionContext != null ? ImmutableSet.of(this.resolutionContext.getParam()) : ImmutableSet.of();
    }

    public static UnaryOperator<IChatBaseComponent> createResolver(LootTableInfo var02, @Nullable LootTableInfo.EntityTarget var1) {
        Entity var22;
        if (var1 != null && (var22 = var02.getParamOrNull(var1.getParam())) != null) {
            CommandListenerWrapper var3 = var22.createCommandSourceStack().withPermission(2);
            return var2 -> {
                try {
                    return ChatComponentUtils.updateForEntity(var3, var2, var22, 0);
                }
                catch (CommandSyntaxException var3) {
                    LOGGER.warn("Failed to resolve text component", (Throwable)var3);
                    return var2;
                }
            };
        }
        return var0 -> var0;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (this.name != null) {
            var0.setHoverName((IChatBaseComponent)LootItemFunctionSetName.createResolver(var1, this.resolutionContext).apply(this.name));
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> setName(IChatBaseComponent var0) {
        return LootItemFunctionSetName.simpleBuilder(var1 -> new LootItemFunctionSetName((LootItemCondition[])var1, var0, null));
    }

    public static LootItemFunctionConditional.a<?> setName(IChatBaseComponent var0, LootTableInfo.EntityTarget var1) {
        return LootItemFunctionSetName.simpleBuilder(var2 -> new LootItemFunctionSetName((LootItemCondition[])var2, var0, var1));
    }

    public static class a
    extends LootItemFunctionConditional.c<LootItemFunctionSetName> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionSetName var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            if (var1.name != null) {
                var0.add("name", IChatBaseComponent.ChatSerializer.toJsonTree(var1.name));
            }
            if (var1.resolutionContext != null) {
                var0.add("entity", var2.serialize((Object)var1.resolutionContext));
            }
        }

        @Override
        public LootItemFunctionSetName deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            IChatMutableComponent var3 = IChatBaseComponent.ChatSerializer.fromJson(var0.get("name"));
            LootTableInfo.EntityTarget var4 = ChatDeserializer.getAsObject(var0, "entity", null, var1, LootTableInfo.EntityTarget.class);
            return new LootItemFunctionSetName(var2, var3, var4);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

