/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.apache.commons.lang3.ArrayUtils;

public abstract class LootItemFunctionConditional
implements LootItemFunction {
    protected final LootItemCondition[] predicates;
    private final Predicate<LootTableInfo> compositePredicates;

    protected LootItemFunctionConditional(LootItemCondition[] var0) {
        this.predicates = var0;
        this.compositePredicates = LootItemConditions.andConditions(var0);
    }

    @Override
    public final ItemStack apply(ItemStack var0, LootTableInfo var1) {
        return this.compositePredicates.test(var1) ? this.run(var0, var1) : var0;
    }

    protected abstract ItemStack run(ItemStack var1, LootTableInfo var2);

    @Override
    public void validate(LootCollector var0) {
        LootItemFunction.super.validate(var0);
        for (int var1 = 0; var1 < this.predicates.length; ++var1) {
            this.predicates[var1].validate(var0.forChild(".conditions[" + var1 + "]"));
        }
    }

    protected static a<?> simpleBuilder(Function<LootItemCondition[], LootItemFunction> var0) {
        return new b(var0);
    }

    @Override
    public /* synthetic */ Object apply(Object object, Object object2) {
        return this.apply((ItemStack)object, (LootTableInfo)object2);
    }

    static final class b
    extends a<b> {
        private final Function<LootItemCondition[], LootItemFunction> constructor;

        public b(Function<LootItemCondition[], LootItemFunction> var0) {
            this.constructor = var0;
        }

        @Override
        protected b getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return this.constructor.apply(this.getConditions());
        }

        @Override
        protected /* synthetic */ a getThis() {
            return this.getThis();
        }
    }

    public static abstract class c<T extends LootItemFunctionConditional>
    implements LootSerializer<T> {
        @Override
        public void serialize(JsonObject var0, T var1, JsonSerializationContext var2) {
            if (!ArrayUtils.isEmpty((Object[])((LootItemFunctionConditional)var1).predicates)) {
                var0.add("conditions", var2.serialize((Object)((LootItemFunctionConditional)var1).predicates));
            }
        }

        @Override
        public final T deserialize(JsonObject var0, JsonDeserializationContext var1) {
            LootItemCondition[] var2 = ChatDeserializer.getAsObject(var0, "conditions", new LootItemCondition[0], var1, LootItemCondition[].class);
            return this.deserialize(var0, var1, var2);
        }

        public abstract T deserialize(JsonObject var1, JsonDeserializationContext var2, LootItemCondition[] var3);

        @Override
        public /* synthetic */ Object deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.deserialize(jsonObject, jsonDeserializationContext);
        }
    }

    public static abstract class a<T extends a<T>>
    implements LootItemFunction.a,
    LootItemConditionUser<T> {
        private final List<LootItemCondition> conditions = Lists.newArrayList();

        @Override
        public T when(LootItemCondition.a var0) {
            this.conditions.add(var0.build());
            return this.getThis();
        }

        @Override
        public final T unwrap() {
            return this.getThis();
        }

        protected abstract T getThis();

        protected LootItemCondition[] getConditions() {
            return this.conditions.toArray(new LootItemCondition[0]);
        }

        @Override
        public /* synthetic */ Object unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ Object when(LootItemCondition.a a2) {
            return this.when(a2);
        }
    }
}

