/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionApplyBonus
extends LootItemFunctionConditional {
    static final Map<MinecraftKey, c> FORMULAS = Maps.newHashMap();
    final Enchantment enchantment;
    final b formula;

    LootItemFunctionApplyBonus(LootItemCondition[] var0, Enchantment var1, b var2) {
        super(var0);
        this.enchantment = var1;
        this.formula = var2;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.APPLY_BONUS;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return ImmutableSet.of(LootContextParameters.TOOL);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        ItemStack var2 = var1.getParamOrNull(LootContextParameters.TOOL);
        if (var2 != null) {
            int var3 = EnchantmentManager.getItemEnchantmentLevel(this.enchantment, var2);
            int var4 = this.formula.calculateNewCount(var1.getRandom(), var0.getCount(), var3);
            var0.setCount(var4);
        }
        return var0;
    }

    public static LootItemFunctionConditional.a<?> addBonusBinomialDistributionCount(Enchantment var0, float var1, int var2) {
        return LootItemFunctionApplyBonus.simpleBuilder(var3 -> new LootItemFunctionApplyBonus((LootItemCondition[])var3, var0, new a(var2, var1)));
    }

    public static LootItemFunctionConditional.a<?> addOreBonusCount(Enchantment var0) {
        return LootItemFunctionApplyBonus.simpleBuilder(var1 -> new LootItemFunctionApplyBonus((LootItemCondition[])var1, var0, new d()));
    }

    public static LootItemFunctionConditional.a<?> addUniformBonusCount(Enchantment var0) {
        return LootItemFunctionApplyBonus.simpleBuilder(var1 -> new LootItemFunctionApplyBonus((LootItemCondition[])var1, var0, new f(1)));
    }

    public static LootItemFunctionConditional.a<?> addUniformBonusCount(Enchantment var0, int var1) {
        return LootItemFunctionApplyBonus.simpleBuilder(var2 -> new LootItemFunctionApplyBonus((LootItemCondition[])var2, var0, new f(var1)));
    }

    static {
        FORMULAS.put(a.TYPE, a::deserialize);
        FORMULAS.put(d.TYPE, d::deserialize);
        FORMULAS.put(f.TYPE, f::deserialize);
    }

    static interface b {
        public int calculateNewCount(Random var1, int var2, int var3);

        public void serializeParams(JsonObject var1, JsonSerializationContext var2);

        public MinecraftKey getType();
    }

    static final class f
    implements b {
        public static final MinecraftKey TYPE = new MinecraftKey("uniform_bonus_count");
        private final int bonusMultiplier;

        public f(int var0) {
            this.bonusMultiplier = var0;
        }

        @Override
        public int calculateNewCount(Random var0, int var1, int var2) {
            return var1 + var0.nextInt(this.bonusMultiplier * var2 + 1);
        }

        @Override
        public void serializeParams(JsonObject var0, JsonSerializationContext var1) {
            var0.addProperty("bonusMultiplier", (Number)this.bonusMultiplier);
        }

        public static b deserialize(JsonObject var0, JsonDeserializationContext var1) {
            int var2 = ChatDeserializer.getAsInt(var0, "bonusMultiplier");
            return new f(var2);
        }

        @Override
        public MinecraftKey getType() {
            return TYPE;
        }
    }

    static final class d
    implements b {
        public static final MinecraftKey TYPE = new MinecraftKey("ore_drops");

        d() {
        }

        @Override
        public int calculateNewCount(Random var0, int var1, int var2) {
            if (var2 > 0) {
                int var3 = var0.nextInt(var2 + 2) - 1;
                if (var3 < 0) {
                    var3 = 0;
                }
                return var1 * (var3 + 1);
            }
            return var1;
        }

        @Override
        public void serializeParams(JsonObject var0, JsonSerializationContext var1) {
        }

        public static b deserialize(JsonObject var0, JsonDeserializationContext var1) {
            return new d();
        }

        @Override
        public MinecraftKey getType() {
            return TYPE;
        }
    }

    static final class a
    implements b {
        public static final MinecraftKey TYPE = new MinecraftKey("binomial_with_bonus_count");
        private final int extraRounds;
        private final float probability;

        public a(int var0, float var1) {
            this.extraRounds = var0;
            this.probability = var1;
        }

        @Override
        public int calculateNewCount(Random var0, int var1, int var2) {
            for (int var3 = 0; var3 < var2 + this.extraRounds; ++var3) {
                if (!(var0.nextFloat() < this.probability)) continue;
                ++var1;
            }
            return var1;
        }

        @Override
        public void serializeParams(JsonObject var0, JsonSerializationContext var1) {
            var0.addProperty("extra", (Number)this.extraRounds);
            var0.addProperty("probability", (Number)Float.valueOf(this.probability));
        }

        public static b deserialize(JsonObject var0, JsonDeserializationContext var1) {
            int var2 = ChatDeserializer.getAsInt(var0, "extra");
            float var3 = ChatDeserializer.getAsFloat(var0, "probability");
            return new a(var2, var3);
        }

        @Override
        public MinecraftKey getType() {
            return TYPE;
        }
    }

    static interface c {
        public b deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    public static class e
    extends LootItemFunctionConditional.c<LootItemFunctionApplyBonus> {
        @Override
        public void serialize(JsonObject var0, LootItemFunctionApplyBonus var1, JsonSerializationContext var2) {
            super.serialize(var0, var1, var2);
            var0.addProperty("enchantment", IRegistry.ENCHANTMENT.getKey(var1.enchantment).toString());
            var0.addProperty("formula", var1.formula.getType().toString());
            JsonObject var3 = new JsonObject();
            var1.formula.serializeParams(var3, var2);
            if (var3.size() > 0) {
                var0.add("parameters", (JsonElement)var3);
            }
        }

        @Override
        public LootItemFunctionApplyBonus deserialize(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            MinecraftKey var3 = new MinecraftKey(ChatDeserializer.getAsString(var0, "enchantment"));
            Enchantment var4 = IRegistry.ENCHANTMENT.getOptional(var3).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + var3));
            MinecraftKey var5 = new MinecraftKey(ChatDeserializer.getAsString(var0, "formula"));
            c var6 = FORMULAS.get(var5);
            if (var6 == null) {
                throw new JsonParseException("Invalid formula id: " + var5);
            }
            b var7 = var0.has("parameters") ? var6.deserialize(ChatDeserializer.getAsJsonObject(var0, "parameters"), var1) : var6.deserialize(new JsonObject(), var1);
            return new LootItemFunctionApplyBonus(var2, var4, var7);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserialize(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }
}

