/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.ArrayUtils;

public abstract class LootSelectorEntry
extends LootEntryAbstract {
    public static final int DEFAULT_WEIGHT = 1;
    public static final int DEFAULT_QUALITY = 0;
    protected final int weight;
    protected final int quality;
    protected final LootItemFunction[] functions;
    final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;
    private final LootEntry entry = new c(){

        @Override
        public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var1) {
            LootSelectorEntry.this.createItemStack(LootItemFunction.decorate(LootSelectorEntry.this.compositeFunction, var0, var1), var1);
        }
    };

    protected LootSelectorEntry(int var0, int var1, LootItemCondition[] var2, LootItemFunction[] var3) {
        super(var2);
        this.weight = var0;
        this.quality = var1;
        this.functions = var3;
        this.compositeFunction = LootItemFunctions.compose(var3);
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        for (int var1 = 0; var1 < this.functions.length; ++var1) {
            this.functions[var1].validate(var0.forChild(".functions[" + var1 + "]"));
        }
    }

    protected abstract void createItemStack(Consumer<ItemStack> var1, LootTableInfo var2);

    @Override
    public boolean expand(LootTableInfo var0, Consumer<LootEntry> var1) {
        if (this.canRun(var0)) {
            var1.accept(this.entry);
            return true;
        }
        return false;
    }

    public static a<?> simpleBuilder(d var0) {
        return new b(var0);
    }

    static class b
    extends a<b> {
        private final d constructor;

        public b(d var0) {
            this.constructor = var0;
        }

        @Override
        protected b getThis() {
            return this;
        }

        @Override
        public LootEntryAbstract build() {
            return this.constructor.build(this.weight, this.quality, this.getConditions(), this.getFunctions());
        }

        @Override
        protected /* synthetic */ LootEntryAbstract.a getThis() {
            return this.getThis();
        }
    }

    @FunctionalInterface
    protected static interface d {
        public LootSelectorEntry build(int var1, int var2, LootItemCondition[] var3, LootItemFunction[] var4);
    }

    public static abstract class e<T extends LootSelectorEntry>
    extends LootEntryAbstract.Serializer<T> {
        @Override
        public void serializeCustom(JsonObject var0, T var1, JsonSerializationContext var2) {
            if (((LootSelectorEntry)var1).weight != 1) {
                var0.addProperty("weight", (Number)((LootSelectorEntry)var1).weight);
            }
            if (((LootSelectorEntry)var1).quality != 0) {
                var0.addProperty("quality", (Number)((LootSelectorEntry)var1).quality);
            }
            if (!ArrayUtils.isEmpty((Object[])((LootSelectorEntry)var1).functions)) {
                var0.add("functions", var2.serialize((Object)((LootSelectorEntry)var1).functions));
            }
        }

        @Override
        public final T deserializeCustom(JsonObject var0, JsonDeserializationContext var1, LootItemCondition[] var2) {
            int var3 = ChatDeserializer.getAsInt(var0, "weight", 1);
            int var4 = ChatDeserializer.getAsInt(var0, "quality", 0);
            LootItemFunction[] var5 = ChatDeserializer.getAsObject(var0, "functions", new LootItemFunction[0], var1, LootItemFunction[].class);
            return this.deserialize(var0, var1, var3, var4, var2, var5);
        }

        protected abstract T deserialize(JsonObject var1, JsonDeserializationContext var2, int var3, int var4, LootItemCondition[] var5, LootItemFunction[] var6);

        @Override
        public /* synthetic */ LootEntryAbstract deserializeCustom(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditionArray) {
            return this.deserializeCustom(jsonObject, jsonDeserializationContext, lootItemConditionArray);
        }
    }

    public static abstract class a<T extends a<T>>
    extends LootEntryAbstract.a<T>
    implements LootItemFunctionUser<T> {
        protected int weight = 1;
        protected int quality = 0;
        private final List<LootItemFunction> functions = Lists.newArrayList();

        @Override
        public T apply(LootItemFunction.a var0) {
            this.functions.add(var0.build());
            return (T)((a)this.getThis());
        }

        protected LootItemFunction[] getFunctions() {
            return this.functions.toArray(new LootItemFunction[0]);
        }

        public T setWeight(int var0) {
            this.weight = var0;
            return (T)((a)this.getThis());
        }

        public T setQuality(int var0) {
            this.quality = var0;
            return (T)((a)this.getThis());
        }

        @Override
        public /* synthetic */ Object apply(LootItemFunction.a a2) {
            return this.apply(a2);
        }
    }

    protected abstract class c
    implements LootEntry {
        protected c() {
        }

        @Override
        public int getWeight(float var0) {
            return Math.max(MathHelper.floor((float)LootSelectorEntry.this.weight + (float)LootSelectorEntry.this.quality * var0), 0);
        }
    }
}

