/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableInfo {
    private final Random random;
    private final float luck;
    private final WorldServer level;
    private final Function<MinecraftKey, LootTable> lootTables;
    private final Set<LootTable> visitedTables = Sets.newLinkedHashSet();
    private final Function<MinecraftKey, LootItemCondition> conditions;
    private final Set<LootItemCondition> visitedConditions = Sets.newLinkedHashSet();
    private final Map<LootContextParameter<?>, Object> params;
    private final Map<MinecraftKey, b> dynamicDrops;

    LootTableInfo(Random var0, float var1, WorldServer var2, Function<MinecraftKey, LootTable> var3, Function<MinecraftKey, LootItemCondition> var4, Map<LootContextParameter<?>, Object> var5, Map<MinecraftKey, b> var6) {
        this.random = var0;
        this.luck = var1;
        this.level = var2;
        this.lootTables = var3;
        this.conditions = var4;
        this.params = ImmutableMap.copyOf(var5);
        this.dynamicDrops = ImmutableMap.copyOf(var6);
    }

    public boolean hasParam(LootContextParameter<?> var0) {
        return this.params.containsKey(var0);
    }

    public <T> T getParam(LootContextParameter<T> var0) {
        Object var1 = this.params.get(var0);
        if (var1 == null) {
            throw new NoSuchElementException(var0.getName().toString());
        }
        return (T)var1;
    }

    public void addDynamicDrops(MinecraftKey var0, Consumer<ItemStack> var1) {
        b var2 = this.dynamicDrops.get(var0);
        if (var2 != null) {
            var2.add(this, var1);
        }
    }

    @Nullable
    public <T> T getParamOrNull(LootContextParameter<T> var0) {
        return (T)this.params.get(var0);
    }

    public boolean addVisitedTable(LootTable var0) {
        return this.visitedTables.add(var0);
    }

    public void removeVisitedTable(LootTable var0) {
        this.visitedTables.remove(var0);
    }

    public boolean addVisitedCondition(LootItemCondition var0) {
        return this.visitedConditions.add(var0);
    }

    public void removeVisitedCondition(LootItemCondition var0) {
        this.visitedConditions.remove(var0);
    }

    public LootTable getLootTable(MinecraftKey var0) {
        return this.lootTables.apply(var0);
    }

    public LootItemCondition getCondition(MinecraftKey var0) {
        return this.conditions.apply(var0);
    }

    public Random getRandom() {
        return this.random;
    }

    public float getLuck() {
        return this.luck;
    }

    public WorldServer getLevel() {
        return this.level;
    }

    @FunctionalInterface
    public static interface b {
        public void add(LootTableInfo var1, Consumer<ItemStack> var2);
    }

    public static final class EntityTarget
    extends Enum<EntityTarget> {
        public static final /* enum */ EntityTarget THIS = new EntityTarget("this", LootContextParameters.THIS_ENTITY);
        public static final /* enum */ EntityTarget KILLER = new EntityTarget("killer", LootContextParameters.KILLER_ENTITY);
        public static final /* enum */ EntityTarget DIRECT_KILLER = new EntityTarget("direct_killer", LootContextParameters.DIRECT_KILLER_ENTITY);
        public static final /* enum */ EntityTarget KILLER_PLAYER = new EntityTarget("killer_player", LootContextParameters.LAST_DAMAGE_PLAYER);
        final String name;
        private final LootContextParameter<? extends Entity> param;
        private static final /* synthetic */ EntityTarget[] g;

        public static EntityTarget[] values() {
            return (EntityTarget[])g.clone();
        }

        public static EntityTarget valueOf(String var0) {
            return Enum.valueOf(EntityTarget.class, var0);
        }

        private EntityTarget(String var2, LootContextParameter var3) {
            this.name = var2;
            this.param = var3;
        }

        public LootContextParameter<? extends Entity> getParam() {
            return this.param;
        }

        public static EntityTarget getByName(String var0) {
            for (EntityTarget var4 : EntityTarget.values()) {
                if (!var4.name.equals(var0)) continue;
                return var4;
            }
            throw new IllegalArgumentException("Invalid entity target " + var0);
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{THIS, KILLER, DIRECT_KILLER, KILLER_PLAYER};
        }

        static {
            g = EntityTarget.b();
        }

        public static class a
        extends TypeAdapter<EntityTarget> {
            public void write(JsonWriter var0, EntityTarget var1) throws IOException {
                var0.value(var1.name);
            }

            public EntityTarget read(JsonReader var0) throws IOException {
                return EntityTarget.getByName(var0.nextString());
            }

            public /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                return this.read(jsonReader);
            }

            public /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
                this.write(jsonWriter, (EntityTarget)((Object)object));
            }
        }
    }

    public static class Builder {
        private final WorldServer level;
        private final Map<LootContextParameter<?>, Object> params = Maps.newIdentityHashMap();
        private final Map<MinecraftKey, b> dynamicDrops = Maps.newHashMap();
        private Random random;
        private float luck;

        public Builder(WorldServer var0) {
            this.level = var0;
        }

        public Builder withRandom(Random var0) {
            this.random = var0;
            return this;
        }

        public Builder withOptionalRandomSeed(long var0) {
            if (var0 != 0L) {
                this.random = new Random(var0);
            }
            return this;
        }

        public Builder withOptionalRandomSeed(long var0, Random var2) {
            this.random = var0 == 0L ? var2 : new Random(var0);
            return this;
        }

        public Builder withLuck(float var0) {
            this.luck = var0;
            return this;
        }

        public <T> Builder withParameter(LootContextParameter<T> var0, T var1) {
            this.params.put(var0, var1);
            return this;
        }

        public <T> Builder withOptionalParameter(LootContextParameter<T> var0, @Nullable T var1) {
            if (var1 == null) {
                this.params.remove(var0);
            } else {
                this.params.put(var0, var1);
            }
            return this;
        }

        public Builder withDynamicDrop(MinecraftKey var0, b var1) {
            b var2 = this.dynamicDrops.put(var0, var1);
            if (var2 != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + this.dynamicDrops + "'");
            }
            return this;
        }

        public WorldServer getLevel() {
            return this.level;
        }

        public <T> T getParameter(LootContextParameter<T> var0) {
            Object var1 = this.params.get(var0);
            if (var1 == null) {
                throw new IllegalArgumentException("No parameter " + var0);
            }
            return (T)var1;
        }

        @Nullable
        public <T> T getOptionalParameter(LootContextParameter<T> var0) {
            return (T)this.params.get(var0);
        }

        public LootTableInfo create(LootContextParameterSet var0) {
            Sets.SetView var1 = Sets.difference(this.params.keySet(), var0.getAllowed());
            if (!var1.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + (Set)var1);
            }
            Sets.SetView var2 = Sets.difference(var0.getRequired(), this.params.keySet());
            if (!var2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + (Set)var2);
            }
            Random var3 = this.random;
            if (var3 == null) {
                var3 = new Random();
            }
            MinecraftServer var4 = this.level.getServer();
            return new LootTableInfo(var3, this.luck, this.level, var4.getLootTables()::get, var4.getPredicateManager()::get, this.params, this.dynamicDrops);
        }
    }
}

