/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.serialization.Lifecycle;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.IWorldDataServer;

public interface SaveData {
    public static final int ANVIL_VERSION_ID = 19133;
    public static final int MCREGION_VERSION_ID = 19132;

    public DataPackConfiguration getDataPackConfig();

    public void setDataPackConfig(DataPackConfiguration var1);

    public boolean wasModded();

    public Set<String> getKnownServerBrands();

    public void setModdedInfo(String var1, boolean var2);

    default public void fillCrashReportCategory(CrashReportSystemDetails var0) {
        var0.setDetail("Known server brands", () -> String.join((CharSequence)", ", this.getKnownServerBrands()));
        var0.setDetail("Level was modded", () -> Boolean.toString(this.wasModded()));
        var0.setDetail("Level storage version", () -> {
            int var0 = this.getVersion();
            return String.format("0x%05X - %s", var0, this.getStorageVersionName(var0));
        });
    }

    default public String getStorageVersionName(int var0) {
        switch (var0) {
            case 19133: {
                return "Anvil";
            }
            case 19132: {
                return "McRegion";
            }
        }
        return "Unknown?";
    }

    @Nullable
    public NBTTagCompound getCustomBossEvents();

    public void setCustomBossEvents(@Nullable NBTTagCompound var1);

    public IWorldDataServer overworldData();

    public WorldSettings getLevelSettings();

    public NBTTagCompound createTag(IRegistryCustom var1, @Nullable NBTTagCompound var2);

    public boolean isHardcore();

    public int getVersion();

    public String getLevelName();

    public EnumGamemode getGameType();

    public void setGameType(EnumGamemode var1);

    public boolean getAllowCommands();

    public EnumDifficulty getDifficulty();

    public void setDifficulty(EnumDifficulty var1);

    public boolean isDifficultyLocked();

    public void setDifficultyLocked(boolean var1);

    public GameRules getGameRules();

    @Nullable
    public NBTTagCompound getLoadedPlayerTag();

    public NBTTagCompound endDragonFightData();

    public void setEndDragonFightData(NBTTagCompound var1);

    public GeneratorSettings worldGenSettings();

    public Lifecycle worldGenSettingsLifecycle();
}

