/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.saveddata.maps.MapIcon;

public class MapIconBanner {
    private final BlockPosition pos;
    private final EnumColor color;
    @Nullable
    private final IChatBaseComponent name;

    public MapIconBanner(BlockPosition var0, EnumColor var1, @Nullable IChatBaseComponent var2) {
        this.pos = var0;
        this.color = var1;
        this.name = var2;
    }

    public static MapIconBanner load(NBTTagCompound var0) {
        BlockPosition var1 = GameProfileSerializer.readBlockPos(var0.getCompound("Pos"));
        EnumColor var2 = EnumColor.byName(var0.getString("Color"), EnumColor.WHITE);
        IChatMutableComponent var3 = var0.contains("Name") ? IChatBaseComponent.ChatSerializer.fromJson(var0.getString("Name")) : null;
        return new MapIconBanner(var1, var2, var3);
    }

    @Nullable
    public static MapIconBanner fromWorld(IBlockAccess var0, BlockPosition var1) {
        TileEntity var2 = var0.getBlockEntity(var1);
        if (var2 instanceof TileEntityBanner) {
            TileEntityBanner var3 = (TileEntityBanner)var2;
            EnumColor var4 = var3.getBaseColor();
            IChatBaseComponent var5 = var3.hasCustomName() ? var3.getCustomName() : null;
            return new MapIconBanner(var1, var4, var5);
        }
        return null;
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public EnumColor getColor() {
        return this.color;
    }

    public MapIcon.Type getDecoration() {
        switch (this.color) {
            case WHITE: {
                return MapIcon.Type.BANNER_WHITE;
            }
            case ORANGE: {
                return MapIcon.Type.BANNER_ORANGE;
            }
            case MAGENTA: {
                return MapIcon.Type.BANNER_MAGENTA;
            }
            case LIGHT_BLUE: {
                return MapIcon.Type.BANNER_LIGHT_BLUE;
            }
            case YELLOW: {
                return MapIcon.Type.BANNER_YELLOW;
            }
            case LIME: {
                return MapIcon.Type.BANNER_LIME;
            }
            case PINK: {
                return MapIcon.Type.BANNER_PINK;
            }
            case GRAY: {
                return MapIcon.Type.BANNER_GRAY;
            }
            case LIGHT_GRAY: {
                return MapIcon.Type.BANNER_LIGHT_GRAY;
            }
            case CYAN: {
                return MapIcon.Type.BANNER_CYAN;
            }
            case PURPLE: {
                return MapIcon.Type.BANNER_PURPLE;
            }
            case BLUE: {
                return MapIcon.Type.BANNER_BLUE;
            }
            case BROWN: {
                return MapIcon.Type.BANNER_BROWN;
            }
            case GREEN: {
                return MapIcon.Type.BANNER_GREEN;
            }
            case RED: {
                return MapIcon.Type.BANNER_RED;
            }
        }
        return MapIcon.Type.BANNER_BLACK;
    }

    @Nullable
    public IChatBaseComponent getName() {
        return this.name;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        MapIconBanner var1 = (MapIconBanner)var0;
        return Objects.equals(this.pos, var1.pos) && this.color == var1.color && Objects.equals(this.name, var1.name);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.color, this.name);
    }

    public NBTTagCompound save() {
        NBTTagCompound var0 = new NBTTagCompound();
        var0.put("Pos", GameProfileSerializer.writeBlockPos(this.pos));
        var0.putString("Color", this.color.getName());
        if (this.name != null) {
            var0.putString("Name", IChatBaseComponent.ChatSerializer.toJson(this.name));
        }
        return var0;
    }

    public String getId() {
        return "banner-" + this.pos.getX() + "," + this.pos.getY() + "," + this.pos.getZ();
    }
}

