/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;

public abstract class FluidTypeLava
extends FluidTypeFlowing {
    public static final float MIN_LEVEL_CUTOFF = 0.44444445f;

    @Override
    public FluidType getFlowing() {
        return FluidTypes.FLOWING_LAVA;
    }

    @Override
    public FluidType getSource() {
        return FluidTypes.LAVA;
    }

    @Override
    public Item getBucket() {
        return Items.LAVA_BUCKET;
    }

    @Override
    public void animateTick(World var0, BlockPosition var1, Fluid var2, Random var3) {
        BlockPosition var4 = var1.above();
        if (var0.getBlockState(var4).isAir() && !var0.getBlockState(var4).isSolidRender(var0, var4)) {
            if (var3.nextInt(100) == 0) {
                double var5 = (double)var1.getX() + var3.nextDouble();
                double var7 = (double)var1.getY() + 1.0;
                double var9 = (double)var1.getZ() + var3.nextDouble();
                var0.addParticle(Particles.LAVA, var5, var7, var9, 0.0, 0.0, 0.0);
                var0.playLocalSound(var5, var7, var9, SoundEffects.LAVA_POP, SoundCategory.BLOCKS, 0.2f + var3.nextFloat() * 0.2f, 0.9f + var3.nextFloat() * 0.15f, false);
            }
            if (var3.nextInt(200) == 0) {
                var0.playLocalSound(var1.getX(), var1.getY(), var1.getZ(), SoundEffects.LAVA_AMBIENT, SoundCategory.BLOCKS, 0.2f + var3.nextFloat() * 0.2f, 0.9f + var3.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public void randomTick(World var0, BlockPosition var1, Fluid var2, Random var3) {
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            return;
        }
        int var4 = var3.nextInt(3);
        if (var4 > 0) {
            BlockPosition var5 = var1;
            for (int var6 = 0; var6 < var4; ++var6) {
                if (!var0.isLoaded(var5 = var5.offset(var3.nextInt(3) - 1, 1, var3.nextInt(3) - 1))) {
                    return;
                }
                IBlockData var7 = var0.getBlockState(var5);
                if (var7.isAir()) {
                    if (!this.hasFlammableNeighbours(var0, var5)) continue;
                    var0.setBlockAndUpdate(var5, BlockFireAbstract.getState(var0, var5));
                    return;
                }
                if (!var7.getMaterial().blocksMotion()) continue;
                return;
            }
        } else {
            for (int var5 = 0; var5 < 3; ++var5) {
                BlockPosition var6 = var1.offset(var3.nextInt(3) - 1, 0, var3.nextInt(3) - 1);
                if (!var0.isLoaded(var6)) {
                    return;
                }
                if (!var0.isEmptyBlock(var6.above()) || !this.isFlammable(var0, var6)) continue;
                var0.setBlockAndUpdate(var6.above(), BlockFireAbstract.getState(var0, var6));
            }
        }
    }

    private boolean hasFlammableNeighbours(IWorldReader var0, BlockPosition var1) {
        for (EnumDirection var5 : EnumDirection.values()) {
            if (!this.isFlammable(var0, var1.relative(var5))) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable(IWorldReader var0, BlockPosition var1) {
        if (var1.getY() >= var0.getMinBuildHeight() && var1.getY() < var0.getMaxBuildHeight() && !var0.hasChunkAt(var1)) {
            return false;
        }
        return var0.getBlockState(var1).getMaterial().isFlammable();
    }

    @Override
    @Nullable
    public ParticleParam getDripParticle() {
        return Particles.DRIPPING_LAVA;
    }

    @Override
    protected void beforeDestroyingBlock(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        this.fizz(var0, var1);
    }

    @Override
    public int getSlopeFindDistance(IWorldReader var0) {
        return var0.dimensionType().ultraWarm() ? 4 : 2;
    }

    @Override
    public IBlockData createLegacyBlock(Fluid var0) {
        return (IBlockData)Blocks.LAVA.defaultBlockState().setValue(BlockFluids.LEVEL, FluidTypeLava.getLegacyLevel(var0));
    }

    @Override
    public boolean isSame(FluidType var0) {
        return var0 == FluidTypes.LAVA || var0 == FluidTypes.FLOWING_LAVA;
    }

    @Override
    public int getDropOff(IWorldReader var0) {
        return var0.dimensionType().ultraWarm() ? 1 : 2;
    }

    @Override
    public boolean canBeReplacedWith(Fluid var0, IBlockAccess var1, BlockPosition var2, FluidType var3, EnumDirection var4) {
        return var0.getHeight(var1, var2) >= 0.44444445f && var3.is(TagsFluid.WATER);
    }

    @Override
    public int getTickDelay(IWorldReader var0) {
        return var0.dimensionType().ultraWarm() ? 10 : 30;
    }

    @Override
    public int getSpreadDelay(World var0, BlockPosition var1, Fluid var2, Fluid var3) {
        int var4 = this.getTickDelay(var0);
        if (!(var2.isEmpty() || var3.isEmpty() || var2.getValue(FALLING).booleanValue() || var3.getValue(FALLING).booleanValue() || !(var3.getHeight(var0, var1) > var2.getHeight(var0, var1)) || var0.getRandom().nextInt(4) == 0)) {
            var4 *= 4;
        }
        return var4;
    }

    private void fizz(GeneratorAccess var0, BlockPosition var1) {
        var0.levelEvent(1501, var1, 0);
    }

    @Override
    protected boolean canConvertToSource() {
        return false;
    }

    @Override
    protected void spreadTo(GeneratorAccess var0, BlockPosition var1, IBlockData var2, EnumDirection var3, Fluid var4) {
        if (var3 == EnumDirection.DOWN) {
            Fluid var5 = var0.getFluidState(var1);
            if (this.is(TagsFluid.LAVA) && var5.is(TagsFluid.WATER)) {
                if (var2.getBlock() instanceof BlockFluids) {
                    var0.setBlock(var1, Blocks.STONE.defaultBlockState(), 3);
                }
                this.fizz(var0, var1);
                return;
            }
        }
        super.spreadTo(var0, var1, var2, var3, var4);
    }

    @Override
    protected boolean isRandomlyTicking() {
        return true;
    }

    @Override
    protected float getExplosionResistance() {
        return 100.0f;
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return Optional.of(SoundEffects.BUCKET_FILL_LAVA);
    }

    public static class a
    extends FluidTypeLava {
        @Override
        protected void createFluidStateDefinition(BlockStateList.a<FluidType, Fluid> var0) {
            super.createFluidStateDefinition(var0);
            var0.add(LEVEL);
        }

        @Override
        public int getAmount(Fluid var0) {
            return var0.getValue(LEVEL);
        }

        @Override
        public boolean isSource(Fluid var0) {
            return false;
        }
    }

    public static class b
    extends FluidTypeLava {
        @Override
        public int getAmount(Fluid var0) {
            return 8;
        }

        @Override
        public boolean isSource(Fluid var0) {
            return true;
        }
    }
}

