/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.feature.WorldGenMineshaft;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.LootTables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenMineshaftPieces {
    static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_SHAFT_WIDTH = 3;
    private static final int DEFAULT_SHAFT_HEIGHT = 3;
    private static final int DEFAULT_SHAFT_LENGTH = 5;
    private static final int MAX_PILLAR_HEIGHT = 20;
    private static final int MAX_CHAIN_HEIGHT = 50;
    private static final int MAX_DEPTH = 8;
    public static final int MAGIC_START_Y = 50;

    private static c createRandomShaftPiece(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, @Nullable EnumDirection var5, int var6, WorldGenMineshaft.Type var7) {
        int var8 = var1.nextInt(100);
        if (var8 >= 80) {
            StructureBoundingBox var9 = WorldGenMineshaftCross.findCrossing(var0, var1, var2, var3, var4, var5);
            if (var9 != null) {
                return new WorldGenMineshaftCross(var6, var9, var5, var7);
            }
        } else if (var8 >= 70) {
            StructureBoundingBox var9 = WorldGenMineshaftStairs.findStairs(var0, var1, var2, var3, var4, var5);
            if (var9 != null) {
                return new WorldGenMineshaftStairs(var6, var9, var5, var7);
            }
        } else {
            StructureBoundingBox var9 = WorldGenMineshaftCorridor.findCorridorSize(var0, var1, var2, var3, var4, var5);
            if (var9 != null) {
                return new WorldGenMineshaftCorridor(var6, var1, var9, var5, var7);
            }
        }
        return null;
    }

    static c generateAndAddPiece(StructurePiece var0, StructurePieceAccessor var1, Random var2, int var3, int var4, int var5, EnumDirection var6, int var7) {
        if (var7 > 8) {
            return null;
        }
        if (Math.abs(var3 - var0.getBoundingBox().minX()) > 80 || Math.abs(var5 - var0.getBoundingBox().minZ()) > 80) {
            return null;
        }
        WorldGenMineshaft.Type var8 = ((c)var0).type;
        c var9 = WorldGenMineshaftPieces.createRandomShaftPiece(var1, var2, var3, var4, var5, var6, var7 + 1, var8);
        if (var9 != null) {
            var1.addPiece(var9);
            var9.addChildren(var0, var1, var2);
        }
        return var9;
    }

    public static class WorldGenMineshaftCross
    extends c {
        private final EnumDirection direction;
        private final boolean isTwoFloored;

        public WorldGenMineshaftCross(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CROSSING, var0);
            this.isTwoFloored = var0.getBoolean("tf");
            this.direction = EnumDirection.from2DDataValue(var0.getInt("D"));
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("tf", this.isTwoFloored);
            var1.putInt("D", this.direction.get2DDataValue());
        }

        public WorldGenMineshaftCross(int var0, StructureBoundingBox var1, @Nullable EnumDirection var2, WorldGenMineshaft.Type var3) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CROSSING, var0, var3, var1);
            this.direction = var2;
            this.isTwoFloored = var1.getYSpan() > 3;
        }

        @Nullable
        public static StructureBoundingBox findCrossing(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5) {
            int var6 = var1.nextInt(4) == 0 ? 6 : 2;
            StructureBoundingBox var7 = switch (var5) {
                default -> new StructureBoundingBox(-1, 0, -4, 3, var6, 0);
                case EnumDirection.SOUTH -> new StructureBoundingBox(-1, 0, 0, 3, var6, 4);
                case EnumDirection.WEST -> new StructureBoundingBox(-4, 0, -1, 0, var6, 3);
                case EnumDirection.EAST -> new StructureBoundingBox(0, 0, -1, 4, var6, 3);
            };
            var7.move(var2, var3, var4);
            if (var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return var7;
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            int var3 = this.getGenDepth();
            switch (this.direction) {
                default: {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.WEST, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.EAST, var3);
                    break;
                }
                case SOUTH: {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.WEST, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.EAST, var3);
                    break;
                }
                case WEST: {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.WEST, var3);
                    break;
                }
                case EAST: {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, EnumDirection.EAST, var3);
                }
            }
            if (this.isTwoFloored) {
                if (var2.nextBoolean()) {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                }
                if (var2.nextBoolean()) {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() + 1, EnumDirection.WEST, var3);
                }
                if (var2.nextBoolean()) {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.minZ() + 1, EnumDirection.EAST, var3);
                }
                if (var2.nextBoolean()) {
                    WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3 + 1, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                }
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            if (this.edgesLiquid(var0, var4)) {
                return;
            }
            IBlockData var7 = this.type.getPlanksState();
            if (this.isTwoFloored) {
                this.generateBox(var0, var4, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.minY() + 3 - 1, this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                this.generateBox(var0, var4, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.minY() + 3 - 1, this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(var0, var4, this.boundingBox.minX() + 1, this.boundingBox.maxY() - 2, this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                this.generateBox(var0, var4, this.boundingBox.minX(), this.boundingBox.maxY() - 2, this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
                this.generateBox(var0, var4, this.boundingBox.minX() + 1, this.boundingBox.minY() + 3, this.boundingBox.minZ() + 1, this.boundingBox.maxX() - 1, this.boundingBox.minY() + 3, this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
            } else {
                this.generateBox(var0, var4, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), this.boundingBox.maxX() - 1, this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
                this.generateBox(var0, var4, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ() - 1, CAVE_AIR, CAVE_AIR, false);
            }
            this.placeSupportPillar(var0, var4, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
            this.placeSupportPillar(var0, var4, this.boundingBox.minX() + 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
            this.placeSupportPillar(var0, var4, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.minZ() + 1, this.boundingBox.maxY());
            this.placeSupportPillar(var0, var4, this.boundingBox.maxX() - 1, this.boundingBox.minY(), this.boundingBox.maxZ() - 1, this.boundingBox.maxY());
            int var8 = this.boundingBox.minY() - 1;
            for (int var9 = this.boundingBox.minX(); var9 <= this.boundingBox.maxX(); ++var9) {
                for (int var10 = this.boundingBox.minZ(); var10 <= this.boundingBox.maxZ(); ++var10) {
                    this.setPlanksBlock(var0, var4, var7, var9, var8, var10);
                }
            }
        }

        private void placeSupportPillar(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5) {
            if (!this.getBlock(var0, var2, var5 + 1, var4, var1).isAir()) {
                this.generateBox(var0, var1, var2, var3, var4, var2, var5, var4, this.type.getPlanksState(), CAVE_AIR, false);
            }
        }
    }

    public static class WorldGenMineshaftStairs
    extends c {
        public WorldGenMineshaftStairs(int var0, StructureBoundingBox var1, EnumDirection var2, WorldGenMineshaft.Type var3) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_STAIRS, var0, var3, var1);
            this.setOrientation(var2);
        }

        public WorldGenMineshaftStairs(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_STAIRS, var0);
        }

        @Nullable
        public static StructureBoundingBox findStairs(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5) {
            StructureBoundingBox var6 = switch (var5) {
                default -> new StructureBoundingBox(0, -5, -8, 2, 2, 0);
                case EnumDirection.SOUTH -> new StructureBoundingBox(0, -5, 0, 2, 2, 8);
                case EnumDirection.WEST -> new StructureBoundingBox(-8, -5, 0, 0, 2, 2);
                case EnumDirection.EAST -> new StructureBoundingBox(0, -5, 0, 8, 2, 2);
            };
            var6.move(var2, var3, var4);
            if (var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return var6;
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            int var3 = this.getGenDepth();
            EnumDirection var4 = this.getOrientation();
            if (var4 != null) {
                switch (var4) {
                    default: {
                        WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                        break;
                    }
                    case SOUTH: {
                        WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX(), this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                        break;
                    }
                    case WEST: {
                        WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY(), this.boundingBox.minZ(), EnumDirection.WEST, var3);
                        break;
                    }
                    case EAST: {
                        WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY(), this.boundingBox.minZ(), EnumDirection.EAST, var3);
                    }
                }
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            if (this.edgesLiquid(var0, var4)) {
                return;
            }
            this.generateBox(var0, var4, 0, 5, 0, 2, 7, 1, CAVE_AIR, CAVE_AIR, false);
            this.generateBox(var0, var4, 0, 0, 7, 2, 2, 8, CAVE_AIR, CAVE_AIR, false);
            for (int var7 = 0; var7 < 5; ++var7) {
                this.generateBox(var0, var4, 0, 5 - var7 - (var7 < 4 ? 1 : 0), 2 + var7, 2, 7 - var7, 2 + var7, CAVE_AIR, CAVE_AIR, false);
            }
        }
    }

    public static class WorldGenMineshaftCorridor
    extends c {
        private final boolean hasRails;
        private final boolean spiderCorridor;
        private boolean hasPlacedSpider;
        private final int numSections;

        public WorldGenMineshaftCorridor(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CORRIDOR, var0);
            this.hasRails = var0.getBoolean("hr");
            this.spiderCorridor = var0.getBoolean("sc");
            this.hasPlacedSpider = var0.getBoolean("hps");
            this.numSections = var0.getInt("Num");
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("hr", this.hasRails);
            var1.putBoolean("sc", this.spiderCorridor);
            var1.putBoolean("hps", this.hasPlacedSpider);
            var1.putInt("Num", this.numSections);
        }

        public WorldGenMineshaftCorridor(int var0, Random var1, StructureBoundingBox var2, EnumDirection var3, WorldGenMineshaft.Type var4) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_CORRIDOR, var0, var4, var2);
            this.setOrientation(var3);
            this.hasRails = var1.nextInt(3) == 0;
            this.spiderCorridor = !this.hasRails && var1.nextInt(23) == 0;
            this.numSections = this.getOrientation().getAxis() == EnumDirection.EnumAxis.Z ? var2.getZSpan() / 5 : var2.getXSpan() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static StructureBoundingBox findCorridorSize(StructurePieceAccessor var0, Random var1, int var2, int var3, int var4, EnumDirection var5) {
            int var6 = var1.nextInt(3) + 2;
            while (var6 > 0) {
                int var8 = var6 * 5;
                StructureBoundingBox var7 = switch (var5) {
                    default -> new StructureBoundingBox(0, 0, -(var8 - 1), 2, 2, 0);
                    case EnumDirection.SOUTH -> new StructureBoundingBox(0, 0, 0, 2, 2, var8 - 1);
                    case EnumDirection.WEST -> new StructureBoundingBox(-(var8 - 1), 0, 0, 0, 2, 2);
                    case EnumDirection.EAST -> new StructureBoundingBox(0, 0, 0, var8 - 1, 2, 2);
                };
                var7.move(var2, var3, var4);
                if (var0.findCollisionPiece(var7) == null) {
                    return var7;
                }
                --var6;
            }
            return null;
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            block24: {
                int var3 = this.getGenDepth();
                int var4 = var2.nextInt(4);
                EnumDirection var5 = this.getOrientation();
                if (var5 != null) {
                    switch (var5) {
                        default: {
                            if (var4 <= 1) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX(), this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ() - 1, var5, var3);
                                break;
                            }
                            if (var4 == 2) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ(), EnumDirection.WEST, var3);
                                break;
                            }
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ(), EnumDirection.EAST, var3);
                            break;
                        }
                        case SOUTH: {
                            if (var4 <= 1) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX(), this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.maxZ() + 1, var5, var3);
                                break;
                            }
                            if (var4 == 2) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.maxZ() - 3, EnumDirection.WEST, var3);
                                break;
                            }
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.maxZ() - 3, EnumDirection.EAST, var3);
                            break;
                        }
                        case WEST: {
                            if (var4 <= 1) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ(), var5, var3);
                                break;
                            }
                            if (var4 == 2) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX(), this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                                break;
                            }
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX(), this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                            break;
                        }
                        case EAST: {
                            if (var4 <= 1) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ(), var5, var3);
                                break;
                            }
                            if (var4 == 2) {
                                WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                                break;
                            }
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() - 3, this.boundingBox.minY() - 1 + var2.nextInt(3), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                        }
                    }
                }
                if (var3 >= 8) break block24;
                if (var5 == EnumDirection.NORTH || var5 == EnumDirection.SOUTH) {
                    int var6 = this.boundingBox.minZ() + 3;
                    while (var6 + 3 <= this.boundingBox.maxZ()) {
                        int var7 = var2.nextInt(5);
                        if (var7 == 0) {
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY(), var6, EnumDirection.WEST, var3 + 1);
                        } else if (var7 == 1) {
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY(), var6, EnumDirection.EAST, var3 + 1);
                        }
                        var6 += 5;
                    }
                } else {
                    int var6 = this.boundingBox.minX() + 3;
                    while (var6 + 3 <= this.boundingBox.maxX()) {
                        int var7 = var2.nextInt(5);
                        if (var7 == 0) {
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, var6, this.boundingBox.minY(), this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3 + 1);
                        } else if (var7 == 1) {
                            WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, var6, this.boundingBox.minY(), this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3 + 1);
                        }
                        var6 += 5;
                    }
                }
            }
        }

        @Override
        protected boolean createChest(GeneratorAccessSeed var0, StructureBoundingBox var1, Random var2, int var3, int var4, int var5, MinecraftKey var6) {
            BlockPosition.MutableBlockPosition var7 = this.getWorldPos(var3, var4, var5);
            if (var1.isInside(var7) && var0.getBlockState(var7).isAir() && !var0.getBlockState(((BlockPosition)var7).below()).isAir()) {
                IBlockData var8 = (IBlockData)Blocks.RAIL.defaultBlockState().setValue(BlockMinecartTrack.SHAPE, var2.nextBoolean() ? BlockPropertyTrackPosition.NORTH_SOUTH : BlockPropertyTrackPosition.EAST_WEST);
                this.placeBlock(var0, var8, var3, var4, var5, var1);
                EntityMinecartChest var9 = new EntityMinecartChest(var0.getLevel(), (double)var7.getX() + 0.5, (double)var7.getY() + 0.5, (double)var7.getZ() + 0.5);
                var9.setLootTable(var6, var2.nextLong());
                var0.addFreshEntity(var9);
                return true;
            }
            return false;
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var15;
            int var14;
            int var13;
            if (this.edgesLiquid(var0, var4)) {
                return;
            }
            boolean var7 = false;
            int var8 = 2;
            boolean var9 = false;
            int var10 = 2;
            int var11 = this.numSections * 5 - 1;
            IBlockData var12 = this.type.getPlanksState();
            this.generateBox(var0, var4, 0, 0, 0, 2, 1, var11, CAVE_AIR, CAVE_AIR, false);
            this.generateMaybeBox(var0, var4, var3, 0.8f, 0, 2, 0, 2, 2, var11, CAVE_AIR, CAVE_AIR, false, false);
            if (this.spiderCorridor) {
                this.generateMaybeBox(var0, var4, var3, 0.6f, 0, 0, 0, 2, 1, var11, Blocks.COBWEB.defaultBlockState(), CAVE_AIR, false, true);
            }
            for (var13 = 0; var13 < this.numSections; ++var13) {
                var14 = 2 + var13 * 5;
                this.placeSupport(var0, var4, 0, 0, var14, 2, 2, var3);
                this.maybePlaceCobWeb(var0, var4, var3, 0.1f, 0, 2, var14 - 1);
                this.maybePlaceCobWeb(var0, var4, var3, 0.1f, 2, 2, var14 - 1);
                this.maybePlaceCobWeb(var0, var4, var3, 0.1f, 0, 2, var14 + 1);
                this.maybePlaceCobWeb(var0, var4, var3, 0.1f, 2, 2, var14 + 1);
                this.maybePlaceCobWeb(var0, var4, var3, 0.05f, 0, 2, var14 - 2);
                this.maybePlaceCobWeb(var0, var4, var3, 0.05f, 2, 2, var14 - 2);
                this.maybePlaceCobWeb(var0, var4, var3, 0.05f, 0, 2, var14 + 2);
                this.maybePlaceCobWeb(var0, var4, var3, 0.05f, 2, 2, var14 + 2);
                if (var3.nextInt(100) == 0) {
                    this.createChest(var0, var4, var3, 2, 0, var14 - 1, LootTables.ABANDONED_MINESHAFT);
                }
                if (var3.nextInt(100) == 0) {
                    this.createChest(var0, var4, var3, 0, 0, var14 + 1, LootTables.ABANDONED_MINESHAFT);
                }
                if (!this.spiderCorridor || this.hasPlacedSpider) continue;
                var15 = 1;
                int var16 = var14 - 1 + var3.nextInt(3);
                BlockPosition.MutableBlockPosition var17 = this.getWorldPos(1, 0, var16);
                if (!var4.isInside(var17) || !this.isInterior(var0, 1, 0, var16, var4)) continue;
                this.hasPlacedSpider = true;
                var0.setBlock(var17, Blocks.SPAWNER.defaultBlockState(), 2);
                TileEntity var18 = var0.getBlockEntity(var17);
                if (!(var18 instanceof TileEntityMobSpawner)) continue;
                ((TileEntityMobSpawner)var18).getSpawner().setEntityId(EntityTypes.CAVE_SPIDER);
            }
            for (var13 = 0; var13 <= 2; ++var13) {
                for (var14 = 0; var14 <= var11; ++var14) {
                    this.setPlanksBlock(var0, var4, var12, var13, -1, var14);
                }
            }
            var13 = 2;
            this.placeDoubleLowerOrUpperSupport(var0, var4, 0, -1, 2);
            if (this.numSections > 1) {
                var14 = var11 - 2;
                this.placeDoubleLowerOrUpperSupport(var0, var4, 0, -1, var14);
            }
            if (this.hasRails) {
                IBlockData var142 = (IBlockData)Blocks.RAIL.defaultBlockState().setValue(BlockMinecartTrack.SHAPE, BlockPropertyTrackPosition.NORTH_SOUTH);
                for (var15 = 0; var15 <= var11; ++var15) {
                    IBlockData var16 = this.getBlock(var0, 1, -1, var15, var4);
                    if (var16.isAir() || !var16.isSolidRender(var0, this.getWorldPos(1, -1, var15))) continue;
                    float var17 = this.isInterior(var0, 1, 0, var15, var4) ? 0.7f : 0.9f;
                    this.maybeGenerateBlock(var0, var4, var3, var17, 1, 0, var15, var142);
                }
            }
        }

        private void placeDoubleLowerOrUpperSupport(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4) {
            IBlockData var5 = this.type.getWoodState();
            IBlockData var6 = this.type.getPlanksState();
            if (this.getBlock(var0, var2, var3, var4, var1).is(var6.getBlock())) {
                this.fillPillarDownOrChainUp(var0, var5, var2, var3, var4, var1);
            }
            if (this.getBlock(var0, var2 + 2, var3, var4, var1).is(var6.getBlock())) {
                this.fillPillarDownOrChainUp(var0, var5, var2 + 2, var3, var4, var1);
            }
        }

        @Override
        protected void fillColumnDown(GeneratorAccessSeed var0, IBlockData var1, int var2, int var3, int var4, StructureBoundingBox var5) {
            BlockPosition.MutableBlockPosition var6 = this.getWorldPos(var2, var3, var4);
            if (!var5.isInside(var6)) {
                return;
            }
            int var7 = var6.getY();
            while (this.isReplaceableByStructures(var0.getBlockState(var6)) && var6.getY() > var0.getMinBuildHeight() + 1) {
                var6.move(EnumDirection.DOWN);
            }
            if (!this.canPlaceColumnOnTopOf(var0.getBlockState(var6))) {
                return;
            }
            while (var6.getY() < var7) {
                var6.move(EnumDirection.UP);
                var0.setBlock(var6, var1, 2);
            }
        }

        protected void fillPillarDownOrChainUp(GeneratorAccessSeed var0, IBlockData var1, int var2, int var3, int var4, StructureBoundingBox var5) {
            BlockPosition.MutableBlockPosition var6 = this.getWorldPos(var2, var3, var4);
            if (!var5.isInside(var6)) {
                return;
            }
            int var7 = var6.getY();
            int var8 = 1;
            boolean var9 = true;
            boolean var10 = true;
            while (var9 || var10) {
                boolean var12;
                IBlockData var11;
                if (var9) {
                    var6.setY(var7 - var8);
                    var11 = var0.getBlockState(var6);
                    boolean bl = var12 = this.isReplaceableByStructures(var11) && !var11.is(Blocks.LAVA);
                    if (!var12 && this.canPlaceColumnOnTopOf(var11)) {
                        WorldGenMineshaftCorridor.fillColumnBetween(var0, var1, var6, var7 - var8 + 1, var7);
                        return;
                    }
                    boolean bl2 = var9 = var8 <= 20 && var12 && var6.getY() > var0.getMinBuildHeight() + 1;
                }
                if (var10) {
                    var6.setY(var7 + var8);
                    var11 = var0.getBlockState(var6);
                    var12 = this.isReplaceableByStructures(var11);
                    if (!var12 && this.canHangChainBelow(var0, var6, var11)) {
                        var0.setBlock(var6.setY(var7 + 1), this.type.getFenceState(), 2);
                        WorldGenMineshaftCorridor.fillColumnBetween(var0, Blocks.CHAIN.defaultBlockState(), var6, var7 + 2, var7 + var8);
                        return;
                    }
                    var10 = var8 <= 50 && var12 && var6.getY() < var0.getMaxBuildHeight() - 1;
                }
                ++var8;
            }
        }

        private static void fillColumnBetween(GeneratorAccessSeed var0, IBlockData var1, BlockPosition.MutableBlockPosition var2, int var3, int var4) {
            for (int var5 = var3; var5 < var4; ++var5) {
                var0.setBlock(var2.setY(var5), var1, 2);
            }
        }

        private boolean canPlaceColumnOnTopOf(IBlockData var0) {
            return !var0.is(Blocks.RAIL) && !var0.is(Blocks.LAVA);
        }

        private boolean canHangChainBelow(IWorldReader var0, BlockPosition var1, IBlockData var2) {
            return Block.canSupportCenter(var0, var1, EnumDirection.DOWN) && !(var2.getBlock() instanceof BlockFalling);
        }

        private void placeSupport(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5, int var6, Random var7) {
            if (!this.isSupportingBox(var0, var1, var2, var6, var5, var4)) {
                return;
            }
            IBlockData var8 = this.type.getPlanksState();
            IBlockData var9 = this.type.getFenceState();
            this.generateBox(var0, var1, var2, var3, var4, var2, var5 - 1, var4, (IBlockData)var9.setValue(BlockFence.WEST, true), CAVE_AIR, false);
            this.generateBox(var0, var1, var6, var3, var4, var6, var5 - 1, var4, (IBlockData)var9.setValue(BlockFence.EAST, true), CAVE_AIR, false);
            if (var7.nextInt(4) == 0) {
                this.generateBox(var0, var1, var2, var5, var4, var2, var5, var4, var8, CAVE_AIR, false);
                this.generateBox(var0, var1, var6, var5, var4, var6, var5, var4, var8, CAVE_AIR, false);
            } else {
                this.generateBox(var0, var1, var2, var5, var4, var6, var5, var4, var8, CAVE_AIR, false);
                this.maybeGenerateBlock(var0, var1, var7, 0.05f, var2 + 1, var5, var4 - 1, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.SOUTH));
                this.maybeGenerateBlock(var0, var1, var7, 0.05f, var2 + 1, var5, var4 + 1, (IBlockData)Blocks.WALL_TORCH.defaultBlockState().setValue(BlockTorchWall.FACING, EnumDirection.NORTH));
            }
        }

        private void maybePlaceCobWeb(GeneratorAccessSeed var0, StructureBoundingBox var1, Random var2, float var3, int var4, int var5, int var6) {
            if (this.isInterior(var0, var4, var5, var6, var1) && var2.nextFloat() < var3 && this.hasSturdyNeighbours(var0, var1, var4, var5, var6, 2)) {
                this.placeBlock(var0, Blocks.COBWEB.defaultBlockState(), var4, var5, var6, var1);
            }
        }

        private boolean hasSturdyNeighbours(GeneratorAccessSeed var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5) {
            BlockPosition.MutableBlockPosition var6 = this.getWorldPos(var2, var3, var4);
            int var7 = 0;
            for (EnumDirection var11 : EnumDirection.values()) {
                var6.move(var11);
                if (var1.isInside(var6) && var0.getBlockState(var6).isFaceSturdy(var0, var6, var11.getOpposite()) && ++var7 >= var5) {
                    return true;
                }
                var6.move(var11.getOpposite());
            }
            return false;
        }
    }

    static abstract class c
    extends StructurePiece {
        protected WorldGenMineshaft.Type type;

        public c(WorldGenFeatureStructurePieceType var0, int var1, WorldGenMineshaft.Type var2, StructureBoundingBox var3) {
            super(var0, var1, var3);
            this.type = var2;
        }

        public c(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
            super(var0, var1);
            this.type = WorldGenMineshaft.Type.byId(var1.getInt("MST"));
        }

        @Override
        protected boolean canBeReplaced(IWorldReader var0, int var1, int var2, int var3, StructureBoundingBox var4) {
            IBlockData var5 = this.getBlock(var0, var1, var2, var3, var4);
            return !var5.is(this.type.getPlanksState().getBlock()) && !var5.is(this.type.getWoodState().getBlock()) && !var5.is(this.type.getFenceState().getBlock()) && !var5.is(Blocks.CHAIN);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            var1.putInt("MST", this.type.ordinal());
        }

        protected boolean isSupportingBox(IBlockAccess var0, StructureBoundingBox var1, int var2, int var3, int var4, int var5) {
            for (int var6 = var2; var6 <= var3; ++var6) {
                if (!this.getBlock(var0, var6, var4 + 1, var5, var1).isAir()) continue;
                return false;
            }
            return true;
        }

        protected boolean edgesLiquid(IBlockAccess var0, StructureBoundingBox var1) {
            int var10;
            int var9;
            int var2 = Math.max(this.boundingBox.minX() - 1, var1.minX());
            int var3 = Math.max(this.boundingBox.minY() - 1, var1.minY());
            int var4 = Math.max(this.boundingBox.minZ() - 1, var1.minZ());
            int var5 = Math.min(this.boundingBox.maxX() + 1, var1.maxX());
            int var6 = Math.min(this.boundingBox.maxY() + 1, var1.maxY());
            int var7 = Math.min(this.boundingBox.maxZ() + 1, var1.maxZ());
            BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition();
            for (var9 = var2; var9 <= var5; ++var9) {
                for (var10 = var4; var10 <= var7; ++var10) {
                    if (var0.getBlockState(var8.set(var9, var3, var10)).getMaterial().isLiquid()) {
                        return true;
                    }
                    if (!var0.getBlockState(var8.set(var9, var6, var10)).getMaterial().isLiquid()) continue;
                    return true;
                }
            }
            for (var9 = var2; var9 <= var5; ++var9) {
                for (var10 = var3; var10 <= var6; ++var10) {
                    if (var0.getBlockState(var8.set(var9, var10, var4)).getMaterial().isLiquid()) {
                        return true;
                    }
                    if (!var0.getBlockState(var8.set(var9, var10, var7)).getMaterial().isLiquid()) continue;
                    return true;
                }
            }
            for (var9 = var4; var9 <= var7; ++var9) {
                for (var10 = var3; var10 <= var6; ++var10) {
                    if (var0.getBlockState(var8.set(var2, var10, var9)).getMaterial().isLiquid()) {
                        return true;
                    }
                    if (!var0.getBlockState(var8.set(var5, var10, var9)).getMaterial().isLiquid()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void setPlanksBlock(GeneratorAccessSeed var0, StructureBoundingBox var1, IBlockData var2, int var3, int var4, int var5) {
            if (!this.isInterior(var0, var3, var4, var5, var1)) {
                return;
            }
            BlockPosition.MutableBlockPosition var6 = this.getWorldPos(var3, var4, var5);
            IBlockData var7 = var0.getBlockState(var6);
            if (var7.isAir() || var7.is(Blocks.CHAIN)) {
                var0.setBlock(var6, var2, 2);
            }
        }
    }

    public static class WorldGenMineshaftRoom
    extends c {
        private final List<StructureBoundingBox> childEntranceBoxes = Lists.newLinkedList();

        public WorldGenMineshaftRoom(int var0, Random var1, int var2, int var3, WorldGenMineshaft.Type var4) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_ROOM, var0, var4, new StructureBoundingBox(var2, 50, var3, var2 + 7 + var1.nextInt(6), 54 + var1.nextInt(6), var3 + 7 + var1.nextInt(6)));
            this.type = var4;
        }

        public WorldGenMineshaftRoom(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.MINE_SHAFT_ROOM, var0);
            StructureBoundingBox.CODEC.listOf().parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.getList("Entrances", 11)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this.childEntranceBoxes::addAll);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, Random var2) {
            StructureBoundingBox var7;
            c var6;
            int var4;
            int var3 = this.getGenDepth();
            int var5 = this.boundingBox.getYSpan() - 3 - 1;
            if (var5 <= 0) {
                var5 = 1;
            }
            for (var4 = 0; var4 < this.boundingBox.getXSpan() && (var4 += var2.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); var4 += 4) {
                var6 = WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var2.nextInt(var5) + 1, this.boundingBox.minZ() - 1, EnumDirection.NORTH, var3);
                if (var6 == null) continue;
                var7 = var6.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(var7.minX(), var7.minY(), this.boundingBox.minZ(), var7.maxX(), var7.maxY(), this.boundingBox.minZ() + 1));
            }
            for (var4 = 0; var4 < this.boundingBox.getXSpan() && (var4 += var2.nextInt(this.boundingBox.getXSpan())) + 3 <= this.boundingBox.getXSpan(); var4 += 4) {
                var6 = WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var2.nextInt(var5) + 1, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, var3);
                if (var6 == null) continue;
                var7 = var6.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(var7.minX(), var7.minY(), this.boundingBox.maxZ() - 1, var7.maxX(), var7.maxY(), this.boundingBox.maxZ()));
            }
            for (var4 = 0; var4 < this.boundingBox.getZSpan() && (var4 += var2.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); var4 += 4) {
                var6 = WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var2.nextInt(var5) + 1, this.boundingBox.minZ() + var4, EnumDirection.WEST, var3);
                if (var6 == null) continue;
                var7 = var6.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(this.boundingBox.minX(), var7.minY(), var7.minZ(), this.boundingBox.minX() + 1, var7.maxY(), var7.maxZ()));
            }
            for (var4 = 0; var4 < this.boundingBox.getZSpan() && (var4 += var2.nextInt(this.boundingBox.getZSpan())) + 3 <= this.boundingBox.getZSpan(); var4 += 4) {
                var6 = WorldGenMineshaftPieces.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var2.nextInt(var5) + 1, this.boundingBox.minZ() + var4, EnumDirection.EAST, var3);
                if (var6 == null) continue;
                var7 = var6.getBoundingBox();
                this.childEntranceBoxes.add(new StructureBoundingBox(this.boundingBox.maxX() - 1, var7.minY(), var7.minZ(), this.boundingBox.maxX(), var7.maxY(), var7.maxZ()));
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, Random var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            if (this.edgesLiquid(var0, var4)) {
                return;
            }
            this.generateBox(var0, var4, this.boundingBox.minX(), this.boundingBox.minY() + 1, this.boundingBox.minZ(), this.boundingBox.maxX(), Math.min(this.boundingBox.minY() + 3, this.boundingBox.maxY()), this.boundingBox.maxZ(), CAVE_AIR, CAVE_AIR, false);
            for (StructureBoundingBox var8 : this.childEntranceBoxes) {
                this.generateBox(var0, var4, var8.minX(), var8.maxY() - 2, var8.minZ(), var8.maxX(), var8.maxY(), var8.maxZ(), CAVE_AIR, CAVE_AIR, false);
            }
            this.generateUpperHalfSphere(var0, var4, this.boundingBox.minX(), this.boundingBox.minY() + 4, this.boundingBox.minZ(), this.boundingBox.maxX(), this.boundingBox.maxY(), this.boundingBox.maxZ(), CAVE_AIR, false);
        }

        @Override
        public void move(int var0, int var1, int var2) {
            super.move(var0, var1, var2);
            for (StructureBoundingBox var4 : this.childEntranceBoxes) {
                var4.move(var0, var1, var2);
            }
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var12) {
            super.addAdditionalSaveData(var0, var12);
            StructureBoundingBox.CODEC.listOf().encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, this.childEntranceBoxes).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var12.put("Entrances", (NBTBase)var1));
        }
    }
}

