/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;

public class WorldGenFeatureTreeAlterGround
extends WorldGenFeatureTree {
    public static final Codec<WorldGenFeatureTreeAlterGround> CODEC = WorldGenFeatureStateProvider.CODEC.fieldOf("provider").xmap(WorldGenFeatureTreeAlterGround::new, var0 -> var0.provider).codec();
    private final WorldGenFeatureStateProvider provider;

    public WorldGenFeatureTreeAlterGround(WorldGenFeatureStateProvider var0) {
        this.provider = var0;
    }

    @Override
    protected WorldGenFeatureTrees<?> type() {
        return WorldGenFeatureTrees.ALTER_GROUND;
    }

    @Override
    public void place(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var12, Random var2, List<BlockPosition> var32, List<BlockPosition> var4) {
        if (var32.isEmpty()) {
            return;
        }
        int var5 = var32.get(0).getY();
        var32.stream().filter(var1 -> var1.getY() == var5).forEach(var3 -> {
            this.placeCircle(var0, var12, var2, var3.west().north());
            this.placeCircle(var0, var12, var2, var3.east(2).north());
            this.placeCircle(var0, var12, var2, var3.west().south(2));
            this.placeCircle(var0, var12, var2, var3.east(2).south(2));
            for (int var4 = 0; var4 < 5; ++var4) {
                int var5 = var2.nextInt(64);
                int var6 = var5 % 8;
                int var7 = var5 / 8;
                if (var6 != 0 && var6 != 7 && var7 != 0 && var7 != 7) continue;
                this.placeCircle(var0, var12, var2, var3.offset(-3 + var6, 0, -3 + var7));
            }
        });
    }

    private void placeCircle(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, Random var2, BlockPosition var3) {
        for (int var4 = -2; var4 <= 2; ++var4) {
            for (int var5 = -2; var5 <= 2; ++var5) {
                if (Math.abs(var4) == 2 && Math.abs(var5) == 2) continue;
                this.placeBlockAt(var0, var1, var2, var3.offset(var4, 0, var5));
            }
        }
    }

    private void placeBlockAt(VirtualLevelReadable var0, BiConsumer<BlockPosition, IBlockData> var1, Random var2, BlockPosition var3) {
        for (int var4 = 2; var4 >= -3; --var4) {
            BlockPosition var5 = var3.above(var4);
            if (WorldGenerator.isGrassOrDirt(var0, var5)) {
                var1.accept(var5, this.provider.getState(var2, var3));
                break;
            }
            if (!WorldGenerator.isAir(var0, var5) && var4 < 0) break;
        }
    }
}

