/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureMushroomConfiguration;

public abstract class WorldGenMushrooms
extends WorldGenerator<WorldGenFeatureMushroomConfiguration> {
    public WorldGenMushrooms(Codec<WorldGenFeatureMushroomConfiguration> var0) {
        super(var0);
    }

    protected void placeTrunk(GeneratorAccess var0, Random var1, BlockPosition var2, WorldGenFeatureMushroomConfiguration var3, int var4, BlockPosition.MutableBlockPosition var5) {
        for (int var6 = 0; var6 < var4; ++var6) {
            var5.set(var2).move(EnumDirection.UP, var6);
            if (var0.getBlockState(var5).isSolidRender(var0, var5)) continue;
            this.setBlock(var0, var5, var3.stemProvider.getState(var1, var2));
        }
    }

    protected int getTreeHeight(Random var0) {
        int var1 = var0.nextInt(3) + 4;
        if (var0.nextInt(12) == 0) {
            var1 *= 2;
        }
        return var1;
    }

    protected boolean isValidPosition(GeneratorAccess var0, BlockPosition var1, int var2, BlockPosition.MutableBlockPosition var3, WorldGenFeatureMushroomConfiguration var4) {
        int var5 = var1.getY();
        if (var5 < var0.getMinBuildHeight() + 1 || var5 + var2 + 1 >= var0.getMaxBuildHeight()) {
            return false;
        }
        IBlockData var6 = var0.getBlockState(var1.below());
        if (!WorldGenMushrooms.isDirt(var6) && !var6.is(TagsBlock.MUSHROOM_GROW_BLOCK)) {
            return false;
        }
        for (int var7 = 0; var7 <= var2; ++var7) {
            int var8 = this.getTreeRadiusForHeight(-1, -1, var4.foliageRadius, var7);
            for (int var9 = -var8; var9 <= var8; ++var9) {
                for (int var10 = -var8; var10 <= var8; ++var10) {
                    IBlockData var11 = var0.getBlockState(var3.setWithOffset(var1, var9, var7, var10));
                    if (var11.isAir() || var11.is(TagsBlock.LEAVES)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureMushroomConfiguration> var0) {
        BlockPosition.MutableBlockPosition var6;
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        Random var3 = var0.random();
        WorldGenFeatureMushroomConfiguration var4 = var0.config();
        int var5 = this.getTreeHeight(var3);
        if (!this.isValidPosition(var1, var2, var5, var6 = new BlockPosition.MutableBlockPosition(), var4)) {
            return false;
        }
        this.makeCap(var1, var3, var2, var5, var6, var4);
        this.placeTrunk(var1, var3, var2, var4, var5, var6);
        return true;
    }

    protected abstract int getTreeRadiusForHeight(int var1, int var2, int var3, int var4);

    protected abstract void makeCap(GeneratorAccess var1, Random var2, BlockPosition var3, int var4, BlockPosition.MutableBlockPosition var5, WorldGenFeatureMushroomConfiguration var6);
}

