/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenBonusChest
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenBonusChest(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        Random var1 = var0.random();
        GeneratorAccessSeed var2 = var0.level();
        ChunkCoordIntPair var3 = new ChunkCoordIntPair(var0.origin());
        List var4 = IntStream.rangeClosed(var3.getMinBlockX(), var3.getMaxBlockX()).boxed().collect(Collectors.toList());
        Collections.shuffle(var4, var1);
        List var5 = IntStream.rangeClosed(var3.getMinBlockZ(), var3.getMaxBlockZ()).boxed().collect(Collectors.toList());
        Collections.shuffle(var5, var1);
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        for (Integer var8 : var4) {
            for (Integer var10 : var5) {
                var6.set(var8, 0, var10);
                BlockPosition var11 = var2.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var6);
                if (!var2.isEmptyBlock(var11) && !var2.getBlockState(var11).getCollisionShape(var2, var11).isEmpty()) continue;
                var2.setBlock(var11, Blocks.CHEST.defaultBlockState(), 2);
                TileEntityLootable.setLootTable(var2, var1, var11, LootTables.SPAWN_BONUS_CHEST);
                IBlockData var12 = Blocks.TORCH.defaultBlockState();
                for (EnumDirection var14 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                    BlockPosition var15 = var11.relative(var14);
                    if (!var12.canSurvive(var2, var15)) continue;
                    var2.setBlock(var15, var12, 2);
                }
                return true;
            }
        }
        return false;
    }
}

