/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenBuriedTreasure;
import net.minecraft.world.level.levelgen.feature.WorldGenEndCity;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBastionRemnant;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureDesertPyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIgloo;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureJunglePyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRuinedPortal;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureShipwreck;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMineshaft;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.feature.WorldGenStronghold;
import net.minecraft.world.level.levelgen.feature.WorldGenVillage;
import net.minecraft.world.level.levelgen.feature.WorldGenWoodlandMansion;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureSettingsFeature;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenMineshaftConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureNetherFossil;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureOceanRuin;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureGenerator<C extends WorldGenFeatureConfiguration> {
    public static final BiMap<String, StructureGenerator<?>> STRUCTURES_REGISTRY = HashBiMap.create();
    private static final Map<StructureGenerator<?>, WorldGenStage.Decoration> STEP = Maps.newHashMap();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> PILLAGER_OUTPOST = StructureGenerator.register("Pillager_Outpost", new WorldGenFeaturePillagerOutpost(WorldGenFeatureVillageConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenMineshaftConfiguration> MINESHAFT = StructureGenerator.register("Mineshaft", new WorldGenMineshaft(WorldGenMineshaftConfiguration.CODEC), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> WOODLAND_MANSION = StructureGenerator.register("Mansion", new WorldGenWoodlandMansion(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> JUNGLE_TEMPLE = StructureGenerator.register("Jungle_Pyramid", new WorldGenFeatureJunglePyramid(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> DESERT_PYRAMID = StructureGenerator.register("Desert_Pyramid", new WorldGenFeatureDesertPyramid(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> IGLOO = StructureGenerator.register("Igloo", new WorldGenFeatureIgloo(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureRuinedPortalConfiguration> RUINED_PORTAL = StructureGenerator.register("Ruined_Portal", new WorldGenFeatureRuinedPortal(WorldGenFeatureRuinedPortalConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureShipwreckConfiguration> SHIPWRECK = StructureGenerator.register("Shipwreck", new WorldGenFeatureShipwreck(WorldGenFeatureShipwreckConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> SWAMP_HUT = StructureGenerator.register("Swamp_Hut", new WorldGenFeatureSwampHut(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> STRONGHOLD = StructureGenerator.register("Stronghold", new WorldGenStronghold(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.STRONGHOLDS);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> OCEAN_MONUMENT = StructureGenerator.register("Monument", new WorldGenMonument(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureOceanRuinConfiguration> OCEAN_RUIN = StructureGenerator.register("Ocean_Ruin", new WorldGenFeatureOceanRuin(WorldGenFeatureOceanRuinConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> NETHER_BRIDGE = StructureGenerator.register("Fortress", new WorldGenNether(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.UNDERGROUND_DECORATION);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> END_CITY = StructureGenerator.register("EndCity", new WorldGenEndCity(WorldGenFeatureEmptyConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureConfigurationChance> BURIED_TREASURE = StructureGenerator.register("Buried_Treasure", new WorldGenBuriedTreasure(WorldGenFeatureConfigurationChance.CODEC), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> VILLAGE = StructureGenerator.register("Village", new WorldGenVillage(WorldGenFeatureVillageConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureGenerator<RangeConfiguration> NETHER_FOSSIL = StructureGenerator.register("Nether_Fossil", new WorldGenFeatureNetherFossil(RangeConfiguration.CODEC), WorldGenStage.Decoration.UNDERGROUND_DECORATION);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> BASTION_REMNANT = StructureGenerator.register("Bastion_Remnant", new WorldGenFeatureBastionRemnant(WorldGenFeatureVillageConfiguration.CODEC), WorldGenStage.Decoration.SURFACE_STRUCTURES);
    public static final List<StructureGenerator<?>> NOISE_AFFECTING_FEATURES = ImmutableList.of(PILLAGER_OUTPOST, VILLAGE, NETHER_FOSSIL, STRONGHOLD);
    public static final int MAX_STRUCTURE_RANGE = 8;
    private final Codec<StructureFeature<C, StructureGenerator<C>>> configuredStructureCodec;
    private final PieceGeneratorSupplier<C> pieceGenerator;
    private final PostPlacementProcessor postPlacementProcessor;

    private static <F extends StructureGenerator<?>> F register(String var0, F var1, WorldGenStage.Decoration var2) {
        STRUCTURES_REGISTRY.put((Object)var0.toLowerCase(Locale.ROOT), var1);
        STEP.put(var1, var2);
        return (F)IRegistry.register(IRegistry.STRUCTURE_FEATURE, var0.toLowerCase(Locale.ROOT), var1);
    }

    public StructureGenerator(Codec<C> var0, PieceGeneratorSupplier<C> var1) {
        this(var0, var1, PostPlacementProcessor.NONE);
    }

    public StructureGenerator(Codec<C> var02, PieceGeneratorSupplier<C> var1, PostPlacementProcessor var2) {
        this.configuredStructureCodec = var02.fieldOf("config").xmap(var0 -> new StructureFeature<WorldGenFeatureConfiguration, StructureGenerator>(this, (WorldGenFeatureConfiguration)var0), var0 -> var0.config).codec();
        this.pieceGenerator = var1;
        this.postPlacementProcessor = var2;
    }

    public WorldGenStage.Decoration step() {
        return STEP.get(this);
    }

    public static void bootstrap() {
    }

    @Nullable
    public static StructureStart<?> loadStaticStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        String var4 = var1.getString("id");
        if ("INVALID".equals(var4)) {
            return StructureStart.INVALID_START;
        }
        StructureGenerator<?> var5 = IRegistry.STRUCTURE_FEATURE.get(new MinecraftKey(var4.toLowerCase(Locale.ROOT)));
        if (var5 == null) {
            LOGGER.error("Unknown feature id: {}", (Object)var4);
            return null;
        }
        ChunkCoordIntPair var6 = new ChunkCoordIntPair(var1.getInt("ChunkX"), var1.getInt("ChunkZ"));
        int var7 = var1.getInt("references");
        NBTTagList var8 = var1.getList("Children", 10);
        try {
            PiecesContainer var9 = PiecesContainer.load(var8, var0);
            if (var5 == OCEAN_MONUMENT) {
                var9 = WorldGenMonument.regeneratePiecesAfterLoad(var6, var2, var9);
            }
            return new StructureStart(var5, var6, var7, var9);
        }
        catch (Exception var9) {
            LOGGER.error("Failed Start with id {}", (Object)var4, (Object)var9);
            return null;
        }
    }

    public Codec<StructureFeature<C, StructureGenerator<C>>> configuredStructureCodec() {
        return this.configuredStructureCodec;
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> configured(C var0) {
        return new StructureFeature<C, StructureGenerator>(this, var0);
    }

    public BlockPosition getLocatePos(ChunkCoordIntPair var0) {
        return new BlockPosition(var0.getMinBlockX(), 0, var0.getMinBlockZ());
    }

    @Nullable
    public BlockPosition getNearestGeneratedFeature(IWorldReader var0, StructureManager var1, BlockPosition var2, int var3, boolean var4, long var5, StructureSettingsFeature var7) {
        int var8 = var7.spacing();
        int var9 = SectionPosition.blockToSectionCoord(var2.getX());
        int var10 = SectionPosition.blockToSectionCoord(var2.getZ());
        block0: for (int var11 = 0; var11 <= var3; ++var11) {
            for (int var12 = -var11; var12 <= var11; ++var12) {
                boolean var13 = var12 == -var11 || var12 == var11;
                for (int var14 = -var11; var14 <= var11; ++var14) {
                    int var17;
                    int var16;
                    ChunkCoordIntPair var18;
                    StructureCheckResult var19;
                    boolean var15;
                    boolean bl = var15 = var14 == -var11 || var14 == var11;
                    if (!var13 && !var15 || (var19 = var1.checkStructurePresence(var18 = this.getPotentialFeatureChunk(var7, var5, var16 = var9 + var8 * var12, var17 = var10 + var8 * var14), this, var4)) == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!var4 && var19 == StructureCheckResult.START_PRESENT) {
                        return this.getLocatePos(var18);
                    }
                    IChunkAccess var20 = var0.getChunk(var18.x, var18.z, ChunkStatus.STRUCTURE_STARTS);
                    StructureStart<?> var21 = var1.getStartForFeature(SectionPosition.bottomOf(var20), this, var20);
                    if (var21 != null && var21.isValid()) {
                        if (var4 && var21.canBeReferenced()) {
                            var1.addReference(var21);
                            return this.getLocatePos(var21.getChunkPos());
                        }
                        if (!var4) {
                            return this.getLocatePos(var21.getChunkPos());
                        }
                    }
                    if (var11 == 0) break;
                }
                if (var11 == 0) continue block0;
            }
        }
        return null;
    }

    protected boolean linearSeparation() {
        return true;
    }

    public final ChunkCoordIntPair getPotentialFeatureChunk(StructureSettingsFeature var0, long var1, int var3, int var4) {
        int var11;
        int var10;
        int var5 = var0.spacing();
        int var6 = var0.separation();
        int var7 = Math.floorDiv(var3, var5);
        int var8 = Math.floorDiv(var4, var5);
        SeededRandom var9 = new SeededRandom(new LegacyRandomSource(0L));
        var9.setLargeFeatureWithSalt(var1, var7, var8, var0.salt());
        if (this.linearSeparation()) {
            var10 = var9.nextInt(var5 - var6);
            var11 = var9.nextInt(var5 - var6);
        } else {
            var10 = (var9.nextInt(var5 - var6) + var9.nextInt(var5 - var6)) / 2;
            var11 = (var9.nextInt(var5 - var6) + var9.nextInt(var5 - var6)) / 2;
        }
        return new ChunkCoordIntPair(var7 * var5 + var10, var8 * var5 + var11);
    }

    public StructureStart<?> generate(IRegistryCustom var0, ChunkGenerator var1, WorldChunkManager var2, DefinedStructureManager var3, long var4, ChunkCoordIntPair var6, int var7, StructureSettingsFeature var8, C var9, LevelHeightAccessor var10, Predicate<BiomeBase> var11) {
        Optional<PieceGenerator<C>> var13;
        ChunkCoordIntPair var12 = this.getPotentialFeatureChunk(var8, var4, var6.x, var6.z);
        if (var6.x == var12.x && var6.z == var12.z && (var13 = this.pieceGenerator.createGenerator(new PieceGeneratorSupplier.a<C>(var1, var2, var4, var6, var9, var10, var11, var3, var0))).isPresent()) {
            StructurePiecesBuilder var14 = new StructurePiecesBuilder();
            SeededRandom var15 = new SeededRandom(new LegacyRandomSource(0L));
            var15.setLargeFeatureSeed(var4, var6.x, var6.z);
            var13.get().generatePieces(var14, new PieceGenerator.a<C>(var9, var1, var3, var6, var10, var15, var4));
            StructureStart var16 = new StructureStart(this, var6, var7, var14.build());
            if (var16.isValid()) {
                return var16;
            }
        }
        return StructureStart.INVALID_START;
    }

    public boolean canGenerate(IRegistryCustom var0, ChunkGenerator var1, WorldChunkManager var2, DefinedStructureManager var3, long var4, ChunkCoordIntPair var6, C var7, LevelHeightAccessor var8, Predicate<BiomeBase> var9) {
        return this.pieceGenerator.createGenerator(new PieceGeneratorSupplier.a<C>(var1, var2, var4, var6, var7, var8, var9, var3, var0)).isPresent();
    }

    public PostPlacementProcessor getPostPlacementProcessor() {
        return this.postPlacementProcessor;
    }

    public String getFeatureName() {
        return (String)STRUCTURES_REGISTRY.inverse().get((Object)this);
    }

    public StructureBoundingBox adjustBoundingBox(StructureBoundingBox var0) {
        return var0;
    }
}

