/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class FossilFeatureConfiguration
implements WorldGenFeatureConfiguration {
    public static final Codec<FossilFeatureConfiguration> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)MinecraftKey.CODEC.listOf().fieldOf("fossil_structures").forGetter(var0 -> var0.fossilStructures), (App)MinecraftKey.CODEC.listOf().fieldOf("overlay_structures").forGetter(var0 -> var0.overlayStructures), (App)DefinedStructureStructureProcessorType.LIST_CODEC.fieldOf("fossil_processors").forGetter(var0 -> var0.fossilProcessors), (App)DefinedStructureStructureProcessorType.LIST_CODEC.fieldOf("overlay_processors").forGetter(var0 -> var0.overlayProcessors), (App)Codec.intRange((int)0, (int)7).fieldOf("max_empty_corners_allowed").forGetter(var0 -> var0.maxEmptyCornersAllowed)).apply((Applicative)var02, FossilFeatureConfiguration::new));
    public final List<MinecraftKey> fossilStructures;
    public final List<MinecraftKey> overlayStructures;
    public final Supplier<ProcessorList> fossilProcessors;
    public final Supplier<ProcessorList> overlayProcessors;
    public final int maxEmptyCornersAllowed;

    public FossilFeatureConfiguration(List<MinecraftKey> var0, List<MinecraftKey> var1, Supplier<ProcessorList> var2, Supplier<ProcessorList> var3, int var4) {
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Fossil structure lists need at least one entry");
        }
        if (var0.size() != var1.size()) {
            throw new IllegalArgumentException("Fossil structure lists must be equal lengths");
        }
        this.fossilStructures = var0;
        this.overlayStructures = var1;
        this.fossilProcessors = var2;
        this.overlayProcessors = var3;
        this.maxEmptyCornersAllowed = var4;
    }

    public FossilFeatureConfiguration(List<MinecraftKey> var0, List<MinecraftKey> var1, ProcessorList var2, ProcessorList var3, int var4) {
        this(var0, var1, () -> var2, () -> var3, var4);
    }
}

