/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class CarverDebugSettings {
    public static final CarverDebugSettings DEFAULT = new CarverDebugSettings(false, Blocks.ACACIA_BUTTON.defaultBlockState(), Blocks.CANDLE.defaultBlockState(), Blocks.ORANGE_STAINED_GLASS.defaultBlockState(), Blocks.GLASS.defaultBlockState());
    public static final Codec<CarverDebugSettings> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("debug_mode", (Object)false).forGetter(CarverDebugSettings::isDebugMode), (App)IBlockData.CODEC.optionalFieldOf("air_state", (Object)DEFAULT.getAirState()).forGetter(CarverDebugSettings::getAirState), (App)IBlockData.CODEC.optionalFieldOf("water_state", (Object)DEFAULT.getAirState()).forGetter(CarverDebugSettings::getWaterState), (App)IBlockData.CODEC.optionalFieldOf("lava_state", (Object)DEFAULT.getAirState()).forGetter(CarverDebugSettings::getLavaState), (App)IBlockData.CODEC.optionalFieldOf("barrier_state", (Object)DEFAULT.getAirState()).forGetter(CarverDebugSettings::getBarrierState)).apply((Applicative)var0, CarverDebugSettings::new));
    private boolean debugMode;
    private final IBlockData airState;
    private final IBlockData waterState;
    private final IBlockData lavaState;
    private final IBlockData barrierState;

    public static CarverDebugSettings of(boolean var0, IBlockData var1, IBlockData var2, IBlockData var3, IBlockData var4) {
        return new CarverDebugSettings(var0, var1, var2, var3, var4);
    }

    public static CarverDebugSettings of(IBlockData var0, IBlockData var1, IBlockData var2, IBlockData var3) {
        return new CarverDebugSettings(false, var0, var1, var2, var3);
    }

    public static CarverDebugSettings of(boolean var0, IBlockData var1) {
        return new CarverDebugSettings(var0, var1, DEFAULT.getWaterState(), DEFAULT.getLavaState(), DEFAULT.getBarrierState());
    }

    private CarverDebugSettings(boolean var0, IBlockData var1, IBlockData var2, IBlockData var3, IBlockData var4) {
        this.debugMode = var0;
        this.airState = var1;
        this.waterState = var2;
        this.lavaState = var3;
        this.barrierState = var4;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public IBlockData getAirState() {
        return this.airState;
    }

    public IBlockData getWaterState() {
        return this.waterState;
    }

    public IBlockData getLavaState() {
        return this.lavaState;
    }

    public IBlockData getBarrierState() {
        return this.barrierState;
    }
}

