/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;

public class NoiseSampler
implements Climate.Sampler {
    private static final float ORE_VEIN_RARITY = 1.0f;
    private static final float ORE_THICKNESS = 0.08f;
    private static final float VEININESS_THRESHOLD = 0.4f;
    private static final double VEININESS_FREQUENCY = 1.5;
    private static final int EDGE_ROUNDOFF_BEGIN = 20;
    private static final double MAX_EDGE_ROUNDOFF = 0.2;
    private static final float VEIN_SOLIDNESS = 0.7f;
    private static final float MIN_RICHNESS = 0.1f;
    private static final float MAX_RICHNESS = 0.3f;
    private static final float MAX_RICHNESS_THRESHOLD = 0.6f;
    private static final float CHANCE_OF_RAW_ORE_BLOCK = 0.02f;
    private static final float SKIP_ORE_IF_GAP_NOISE_IS_BELOW = -0.3f;
    private static final double NOODLE_SPACING_AND_STRAIGHTNESS = 1.5;
    private final NoiseSettings noiseSettings;
    private final boolean isNoiseCavesEnabled;
    private final NoiseChunk.b baseNoise;
    private final BlendedNoise blendedNoise;
    @Nullable
    private final NoiseGenerator3Handler islandNoise;
    private final NoiseGeneratorNormal jaggedNoise;
    private final NoiseGeneratorNormal barrierNoise;
    private final NoiseGeneratorNormal fluidLevelFloodednessNoise;
    private final NoiseGeneratorNormal fluidLevelSpreadNoise;
    private final NoiseGeneratorNormal lavaNoise;
    private final NoiseGeneratorNormal layerNoiseSource;
    private final NoiseGeneratorNormal pillarNoiseSource;
    private final NoiseGeneratorNormal pillarRarenessModulator;
    private final NoiseGeneratorNormal pillarThicknessModulator;
    private final NoiseGeneratorNormal spaghetti2DNoiseSource;
    private final NoiseGeneratorNormal spaghetti2DElevationModulator;
    private final NoiseGeneratorNormal spaghetti2DRarityModulator;
    private final NoiseGeneratorNormal spaghetti2DThicknessModulator;
    private final NoiseGeneratorNormal spaghetti3DNoiseSource1;
    private final NoiseGeneratorNormal spaghetti3DNoiseSource2;
    private final NoiseGeneratorNormal spaghetti3DRarityModulator;
    private final NoiseGeneratorNormal spaghetti3DThicknessModulator;
    private final NoiseGeneratorNormal spaghettiRoughnessNoise;
    private final NoiseGeneratorNormal spaghettiRoughnessModulator;
    private final NoiseGeneratorNormal bigEntranceNoiseSource;
    private final NoiseGeneratorNormal cheeseNoiseSource;
    private final NoiseGeneratorNormal temperatureNoise;
    private final NoiseGeneratorNormal humidityNoise;
    private final NoiseGeneratorNormal continentalnessNoise;
    private final NoiseGeneratorNormal erosionNoise;
    private final NoiseGeneratorNormal weirdnessNoise;
    private final NoiseGeneratorNormal offsetNoise;
    private final NoiseGeneratorNormal gapNoise;
    private final NoiseChunk.b veininess;
    private final NoiseChunk.b veinA;
    private final NoiseChunk.b veinB;
    private final NoiseChunk.b noodleToggle;
    private final NoiseChunk.b noodleThickness;
    private final NoiseChunk.b noodleRidgeA;
    private final NoiseChunk.b noodleRidgeB;
    private final PositionalRandomFactory aquiferPositionalRandomFactory;
    private final PositionalRandomFactory oreVeinsPositionalRandomFactory;
    private final PositionalRandomFactory depthBasedLayerPositionalRandomFactory;
    private final List<Climate.d> spawnTarget = new OverworldBiomeBuilder().spawnTarget();
    private final boolean amplified;

    public NoiseSampler(NoiseSettings var02, boolean var1, long var2, IRegistry<NoiseGeneratorNormal.a> var4, SeededRandom.a var5) {
        this.noiseSettings = var02;
        this.isNoiseCavesEnabled = var1;
        this.baseNoise = var0 -> var0.createNoiseInterpolator((var1, var2, var3) -> this.calculateBaseNoise(var1, var2, var3, var0.noiseData(QuartPos.fromBlock(var1), QuartPos.fromBlock(var3)).terrainInfo(), var0.getBlender()));
        if (var02.islandNoiseOverride()) {
            RandomSource var6 = var5.newInstance(var2);
            var6.consumeCount(17292);
            this.islandNoise = new NoiseGenerator3Handler(var6);
        } else {
            this.islandNoise = null;
        }
        this.amplified = var02.isAmplified();
        int var6 = var02.minY();
        int var7 = Stream.of(c.values()).mapToInt(var0 -> var0.minY).min().orElse(var6);
        int var8 = Stream.of(c.values()).mapToInt(var0 -> var0.maxY).max().orElse(var6);
        float var9 = 4.0f;
        double var10 = 2.6666666666666665;
        int var12 = var6 + 4;
        int var13 = var6 + var02.height();
        boolean var14 = var02.largeBiomes();
        PositionalRandomFactory var15 = var5.newInstance(var2).forkPositional();
        if (var5 != SeededRandom.a.LEGACY) {
            this.blendedNoise = new BlendedNoise(var15.fromHashOf(new MinecraftKey("terrain")), var02.noiseSamplingSettings(), var02.getCellWidth(), var02.getCellHeight());
            this.temperatureNoise = Noises.instantiate(var4, var15, var14 ? Noises.TEMPERATURE_LARGE : Noises.TEMPERATURE);
            this.humidityNoise = Noises.instantiate(var4, var15, var14 ? Noises.VEGETATION_LARGE : Noises.VEGETATION);
            this.offsetNoise = Noises.instantiate(var4, var15, Noises.SHIFT);
        } else {
            this.blendedNoise = new BlendedNoise(var5.newInstance(var2), var02.noiseSamplingSettings(), var02.getCellWidth(), var02.getCellHeight());
            this.temperatureNoise = NoiseGeneratorNormal.createLegacyNetherBiome(var5.newInstance(var2), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
            this.humidityNoise = NoiseGeneratorNormal.createLegacyNetherBiome(var5.newInstance(var2 + 1L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
            this.offsetNoise = NoiseGeneratorNormal.create(var15.fromHashOf(Noises.SHIFT.location()), new NoiseGeneratorNormal.a(0, 0.0, new double[0]));
        }
        this.aquiferPositionalRandomFactory = var15.fromHashOf(new MinecraftKey("aquifer")).forkPositional();
        this.oreVeinsPositionalRandomFactory = var15.fromHashOf(new MinecraftKey("ore")).forkPositional();
        this.depthBasedLayerPositionalRandomFactory = var15.fromHashOf(new MinecraftKey("depth_based_layer")).forkPositional();
        this.barrierNoise = Noises.instantiate(var4, var15, Noises.AQUIFER_BARRIER);
        this.fluidLevelFloodednessNoise = Noises.instantiate(var4, var15, Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS);
        this.lavaNoise = Noises.instantiate(var4, var15, Noises.AQUIFER_LAVA);
        this.fluidLevelSpreadNoise = Noises.instantiate(var4, var15, Noises.AQUIFER_FLUID_LEVEL_SPREAD);
        this.pillarNoiseSource = Noises.instantiate(var4, var15, Noises.PILLAR);
        this.pillarRarenessModulator = Noises.instantiate(var4, var15, Noises.PILLAR_RARENESS);
        this.pillarThicknessModulator = Noises.instantiate(var4, var15, Noises.PILLAR_THICKNESS);
        this.spaghetti2DNoiseSource = Noises.instantiate(var4, var15, Noises.SPAGHETTI_2D);
        this.spaghetti2DElevationModulator = Noises.instantiate(var4, var15, Noises.SPAGHETTI_2D_ELEVATION);
        this.spaghetti2DRarityModulator = Noises.instantiate(var4, var15, Noises.SPAGHETTI_2D_MODULATOR);
        this.spaghetti2DThicknessModulator = Noises.instantiate(var4, var15, Noises.SPAGHETTI_2D_THICKNESS);
        this.spaghetti3DNoiseSource1 = Noises.instantiate(var4, var15, Noises.SPAGHETTI_3D_1);
        this.spaghetti3DNoiseSource2 = Noises.instantiate(var4, var15, Noises.SPAGHETTI_3D_2);
        this.spaghetti3DRarityModulator = Noises.instantiate(var4, var15, Noises.SPAGHETTI_3D_RARITY);
        this.spaghetti3DThicknessModulator = Noises.instantiate(var4, var15, Noises.SPAGHETTI_3D_THICKNESS);
        this.spaghettiRoughnessNoise = Noises.instantiate(var4, var15, Noises.SPAGHETTI_ROUGHNESS);
        this.spaghettiRoughnessModulator = Noises.instantiate(var4, var15, Noises.SPAGHETTI_ROUGHNESS_MODULATOR);
        this.bigEntranceNoiseSource = Noises.instantiate(var4, var15, Noises.CAVE_ENTRANCE);
        this.layerNoiseSource = Noises.instantiate(var4, var15, Noises.CAVE_LAYER);
        this.cheeseNoiseSource = Noises.instantiate(var4, var15, Noises.CAVE_CHEESE);
        this.continentalnessNoise = Noises.instantiate(var4, var15, var14 ? Noises.CONTINENTALNESS_LARGE : Noises.CONTINENTALNESS);
        this.erosionNoise = Noises.instantiate(var4, var15, var14 ? Noises.EROSION_LARGE : Noises.EROSION);
        this.weirdnessNoise = Noises.instantiate(var4, var15, Noises.RIDGE);
        this.veininess = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.ORE_VEININESS), var7, var8, 0, 1.5);
        this.veinA = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.ORE_VEIN_A), var7, var8, 0, 4.0);
        this.veinB = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.ORE_VEIN_B), var7, var8, 0, 4.0);
        this.gapNoise = Noises.instantiate(var4, var15, Noises.ORE_GAP);
        this.noodleToggle = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.NOODLE), var12, var13, -1, 1.0);
        this.noodleThickness = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.NOODLE_THICKNESS), var12, var13, 0, 1.0);
        this.noodleRidgeA = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.NOODLE_RIDGE_A), var12, var13, 0, 2.6666666666666665);
        this.noodleRidgeB = NoiseSampler.yLimitedInterpolatableNoise(Noises.instantiate(var4, var15, Noises.NOODLE_RIDGE_B), var12, var13, 0, 2.6666666666666665);
        this.jaggedNoise = Noises.instantiate(var4, var15, Noises.JAGGED);
    }

    private static NoiseChunk.b yLimitedInterpolatableNoise(NoiseGeneratorNormal var0, int var12, int var2, int var3, double var4) {
        NoiseChunk.c var62 = (var6, var7, var8) -> {
            if (var7 > var2 || var7 < var12) {
                return var3;
            }
            return var0.getValue((double)var6 * var4, (double)var7 * var4, (double)var8 * var4);
        };
        return var1 -> var1.createNoiseInterpolator(var62);
    }

    private double calculateBaseNoise(int var0, int var1, int var2, TerrainInfo var3, Blender var4) {
        double var5 = this.blendedNoise.calculateNoise(var0, var1, var2);
        boolean var7 = !this.isNoiseCavesEnabled;
        return this.calculateBaseNoise(var0, var1, var2, var3, var5, var7, true, var4);
    }

    private double calculateBaseNoise(int var0, int var1, int var2, TerrainInfo var3, double var4, boolean var6, boolean var7, Blender var8) {
        double var21;
        double var19;
        double var17;
        double var15;
        double var13;
        double var11;
        double var9;
        if (this.islandNoise != null) {
            var9 = ((double)WorldChunkManagerTheEnd.getHeightValue(this.islandNoise, var0 / 8, var2 / 8) - 8.0) / 128.0;
        } else {
            var11 = var7 ? this.sampleJaggedNoise(var3.jaggedness(), var0, var2) : 0.0;
            var13 = (this.computeBaseDensity(var1, var3) + var11) * var3.factor();
            var9 = var13 * (double)(var13 > 0.0 ? 4 : 1);
        }
        var11 = var9 + var4;
        var13 = 1.5625;
        if (var6 || var11 < -64.0) {
            var15 = var11;
            var17 = 64.0;
            var19 = -64.0;
        } else {
            var21 = var11 - 1.5625;
            boolean var23 = var21 < 0.0;
            double var24 = this.getBigEntrances(var0, var1, var2);
            double var26 = this.spaghettiRoughness(var0, var1, var2);
            double var28 = this.getSpaghetti3D(var0, var1, var2);
            double var30 = Math.min(var24, var28 + var26);
            if (var23) {
                var15 = var11;
                var17 = var30 * 5.0;
                var19 = -64.0;
            } else {
                double var34;
                double var32 = this.getLayerizedCaverns(var0, var1, var2);
                if (var32 > 64.0) {
                    var15 = 64.0;
                } else {
                    var34 = this.cheeseNoiseSource.getValue(var0, (double)var1 / 1.5, var2);
                    double var36 = MathHelper.clamp(var34 + 0.27, -1.0, 1.0);
                    double var38 = var21 * 1.28;
                    double var40 = var36 + MathHelper.clampedLerp(0.5, 0.0, var38);
                    var15 = var40 + var32;
                }
                var34 = this.getSpaghetti2D(var0, var1, var2);
                var17 = Math.min(var30, var34 + var26);
                var19 = this.getPillars(var0, var1, var2);
            }
        }
        var21 = Math.max(Math.min(var15, var17), var19);
        var21 = this.applySlide(var21, var1 / this.noiseSettings.getCellHeight());
        var21 = var8.blendDensity(var0, var1, var2, var21);
        var21 = MathHelper.clamp(var21, -64.0, 64.0);
        return var21;
    }

    private double sampleJaggedNoise(double var0, double var2, double var4) {
        if (var0 == 0.0) {
            return 0.0;
        }
        float var6 = 1500.0f;
        double var7 = this.jaggedNoise.getValue(var2 * 1500.0, 0.0, var4 * 1500.0);
        return var7 > 0.0 ? var0 * var7 : var0 / 2.0 * var7;
    }

    private double computeBaseDensity(int var0, TerrainInfo var1) {
        double var2 = 1.0 - (double)var0 / 128.0;
        return var2 + var1.offset();
    }

    private double applySlide(double var0, int var2) {
        int var3 = var2 - this.noiseSettings.getMinCellY();
        var0 = this.noiseSettings.topSlideSettings().applySlide(var0, this.noiseSettings.getCellCountY() - var3);
        var0 = this.noiseSettings.bottomSlideSettings().applySlide(var0, var3);
        return var0;
    }

    protected NoiseChunk.a makeBaseNoiseFiller(NoiseChunk var0, NoiseChunk.c var1, boolean var2) {
        NoiseChunk.e var3 = this.baseNoise.instantiate(var0);
        NoiseChunk.e var4 = var2 ? this.noodleToggle.instantiate(var0) : () -> -1.0;
        NoiseChunk.e var5 = var2 ? this.noodleThickness.instantiate(var0) : () -> 0.0;
        NoiseChunk.e var6 = var2 ? this.noodleRidgeA.instantiate(var0) : () -> 0.0;
        NoiseChunk.e var72 = var2 ? this.noodleRidgeB.instantiate(var0) : () -> 0.0;
        return (var7, var8, var9) -> {
            double var10;
            double var12 = var10 = var3.sample();
            var12 = MathHelper.clamp(var12 * 0.64, -1.0, 1.0);
            var12 = var12 / 2.0 - var12 * var12 * var12 / 24.0;
            if (var4.sample() >= 0.0) {
                double var14 = 0.05;
                double var16 = 0.1;
                double var18 = MathHelper.clampedMap(var5.sample(), -1.0, 1.0, 0.05, 0.1);
                double var20 = Math.abs(1.5 * var6.sample()) - var18;
                double var22 = Math.abs(1.5 * var72.sample()) - var18;
                var12 = Math.min(var12, Math.max(var20, var22));
            }
            return var0.aquifer().computeSubstance(var7, var8, var9, var10, var12 += var1.calculateNoise(var7, var8, var9));
        };
    }

    protected NoiseChunk.a makeOreVeinifier(NoiseChunk var02, boolean var12) {
        if (!var12) {
            return (var0, var1, var2) -> null;
        }
        NoiseChunk.e var22 = this.veininess.instantiate(var02);
        NoiseChunk.e var3 = this.veinA.instantiate(var02);
        NoiseChunk.e var42 = this.veinB.instantiate(var02);
        IBlockData var52 = null;
        return (var4, var5, var6) -> {
            RandomSource var7 = this.oreVeinsPositionalRandomFactory.at(var4, var5, var6);
            double var8 = var22.sample();
            c var10 = this.getVeinType(var8, var5);
            if (var10 == null) {
                return var52;
            }
            if (var7.nextFloat() > 0.7f) {
                return var52;
            }
            if (this.isVein(var3.sample(), var42.sample())) {
                double var11 = MathHelper.clampedMap(Math.abs(var8), (double)0.4f, (double)0.6f, (double)0.1f, (double)0.3f);
                if ((double)var7.nextFloat() < var11 && this.gapNoise.getValue(var4, var5, var6) > (double)-0.3f) {
                    return var7.nextFloat() < 0.02f ? var10.rawOreBlock : var10.ore;
                }
                return var10.filler;
            }
            return var52;
        };
    }

    protected int getPreliminarySurfaceLevel(int var0, int var1, TerrainInfo var2) {
        for (int var3 = this.noiseSettings.getMinCellY() + this.noiseSettings.getCellCountY(); var3 >= this.noiseSettings.getMinCellY(); --var3) {
            int var4 = var3 * this.noiseSettings.getCellHeight();
            double var5 = -0.703125;
            double var7 = this.calculateBaseNoise(var0, var4, var1, var2, -0.703125, true, false, Blender.empty());
            if (!(var7 > 0.390625)) continue;
            return var4;
        }
        return Integer.MAX_VALUE;
    }

    protected Aquifer createAquifer(NoiseChunk var0, int var1, int var2, int var3, int var4, Aquifer.a var5, boolean var6) {
        if (!var6) {
            return Aquifer.createDisabled(var5);
        }
        int var7 = SectionPosition.blockToSectionCoord(var1);
        int var8 = SectionPosition.blockToSectionCoord(var2);
        return Aquifer.create(var0, new ChunkCoordIntPair(var7, var8), this.barrierNoise, this.fluidLevelFloodednessNoise, this.fluidLevelSpreadNoise, this.lavaNoise, this.aquiferPositionalRandomFactory, var3 * this.noiseSettings.getCellHeight(), var4 * this.noiseSettings.getCellHeight(), var5);
    }

    @VisibleForDebug
    public a noiseData(int var0, int var1, Blender var2) {
        double var3 = (double)var0 + this.getOffset(var0, 0, var1);
        double var5 = (double)var1 + this.getOffset(var1, var0, 0);
        double var7 = this.getContinentalness(var3, 0.0, var5);
        double var9 = this.getWeirdness(var3, 0.0, var5);
        double var11 = this.getErosion(var3, 0.0, var5);
        TerrainInfo var13 = this.terrainInfo(QuartPos.toBlock(var0), QuartPos.toBlock(var1), (float)var7, (float)var9, (float)var11, var2);
        return new a(var3, var5, var7, var9, var11, var13);
    }

    @Override
    public Climate.h sample(int var0, int var1, int var2) {
        return this.target(var0, var1, var2, this.noiseData(var0, var2, Blender.empty()));
    }

    @VisibleForDebug
    public Climate.h target(int var0, int var1, int var2, a var3) {
        double var4 = var3.shiftedX();
        double var6 = (double)var1 + this.getOffset(var1, var2, var0);
        double var8 = var3.shiftedZ();
        double var10 = this.computeBaseDensity(QuartPos.toBlock(var1), var3.terrainInfo());
        return Climate.target((float)this.getTemperature(var4, var6, var8), (float)this.getHumidity(var4, var6, var8), (float)var3.continentalness(), (float)var3.erosion(), (float)var10, (float)var3.weirdness());
    }

    public TerrainInfo terrainInfo(int var0, int var1, float var2, float var3, float var4, Blender var5) {
        TerrainShaper var6 = this.noiseSettings.terrainShaper();
        TerrainShaper.b var7 = var6.makePoint(var2, var4, var3);
        float var8 = var6.offset(var7);
        float var9 = var6.factor(var7);
        float var10 = var6.jaggedness(var7);
        TerrainInfo var11 = new TerrainInfo(var8, var9, var10);
        return var5.blendOffsetAndFactor(var0, var1, var11);
    }

    @Override
    public BlockPosition findSpawnPosition() {
        return Climate.findSpawnPosition(this.spawnTarget, this);
    }

    @VisibleForDebug
    public double getOffset(int var0, int var1, int var2) {
        return this.offsetNoise.getValue(var0, var1, var2) * 4.0;
    }

    private double getTemperature(double var0, double var2, double var4) {
        return this.temperatureNoise.getValue(var0, 0.0, var4);
    }

    private double getHumidity(double var0, double var2, double var4) {
        return this.humidityNoise.getValue(var0, 0.0, var4);
    }

    @VisibleForDebug
    public double getContinentalness(double var0, double var2, double var4) {
        if (SharedConstants.debugGenerateSquareTerrainWithoutNoise) {
            double var6;
            if (SharedConstants.debugVoidTerrain(new ChunkCoordIntPair(QuartPos.toSection(MathHelper.floor(var0)), QuartPos.toSection(MathHelper.floor(var4))))) {
                return -1.0;
            }
            return var6 * var6 * (double)((var6 = MathHelper.frac(var0 / 2048.0) * 2.0 - 1.0) < 0.0 ? -1 : 1);
        }
        if (SharedConstants.debugGenerateStripedTerrainWithoutNoise) {
            double var6 = var0 * 0.005;
            return Math.sin(var6 + 0.5 * Math.sin(var6));
        }
        return this.continentalnessNoise.getValue(var0, var2, var4);
    }

    @VisibleForDebug
    public double getErosion(double var0, double var2, double var4) {
        if (SharedConstants.debugGenerateSquareTerrainWithoutNoise) {
            double var6;
            if (SharedConstants.debugVoidTerrain(new ChunkCoordIntPair(QuartPos.toSection(MathHelper.floor(var0)), QuartPos.toSection(MathHelper.floor(var4))))) {
                return -1.0;
            }
            return var6 * var6 * (double)((var6 = MathHelper.frac(var4 / 256.0) * 2.0 - 1.0) < 0.0 ? -1 : 1);
        }
        if (SharedConstants.debugGenerateStripedTerrainWithoutNoise) {
            double var6 = var4 * 0.005;
            return Math.sin(var6 + 0.5 * Math.sin(var6));
        }
        return this.erosionNoise.getValue(var0, var2, var4);
    }

    @VisibleForDebug
    public double getWeirdness(double var0, double var2, double var4) {
        return this.weirdnessNoise.getValue(var0, var2, var4);
    }

    private double getBigEntrances(int var0, int var1, int var2) {
        double var3 = 0.75;
        double var5 = 0.5;
        double var7 = 0.37;
        double var9 = this.bigEntranceNoiseSource.getValue((double)var0 * 0.75, (double)var1 * 0.5, (double)var2 * 0.75) + 0.37;
        int var11 = -10;
        double var12 = (double)(var1 - -10) / 40.0;
        double var14 = 0.3;
        return var9 + MathHelper.clampedLerp(0.3, 0.0, var12);
    }

    private double getPillars(int var0, int var1, int var2) {
        double var3 = 0.0;
        double var5 = 2.0;
        double var7 = NoiseUtils.sampleNoiseAndMapToRange(this.pillarRarenessModulator, var0, var1, var2, 0.0, 2.0);
        double var9 = 0.0;
        double var11 = 1.1;
        double var13 = NoiseUtils.sampleNoiseAndMapToRange(this.pillarThicknessModulator, var0, var1, var2, 0.0, 1.1);
        var13 = Math.pow(var13, 3.0);
        double var15 = 25.0;
        double var17 = 0.3;
        double var19 = this.pillarNoiseSource.getValue((double)var0 * 25.0, (double)var1 * 0.3, (double)var2 * 25.0);
        if ((var19 = var13 * (var19 * 2.0 - var7)) > 0.03) {
            return var19;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private double getLayerizedCaverns(int var0, int var1, int var2) {
        double var3 = this.layerNoiseSource.getValue(var0, var1 * 8, var2);
        return MathHelper.square(var3) * 4.0;
    }

    private double getSpaghetti3D(int var0, int var1, int var2) {
        double var3 = this.spaghetti3DRarityModulator.getValue(var0 * 2, var1, var2 * 2);
        double var5 = b.getSpaghettiRarity3D(var3);
        double var7 = 0.065;
        double var9 = 0.088;
        double var11 = NoiseUtils.sampleNoiseAndMapToRange(this.spaghetti3DThicknessModulator, var0, var1, var2, 0.065, 0.088);
        double var13 = NoiseSampler.sampleWithRarity(this.spaghetti3DNoiseSource1, var0, var1, var2, var5);
        double var15 = Math.abs(var5 * var13) - var11;
        double var17 = NoiseSampler.sampleWithRarity(this.spaghetti3DNoiseSource2, var0, var1, var2, var5);
        double var19 = Math.abs(var5 * var17) - var11;
        return NoiseSampler.clampToUnit(Math.max(var15, var19));
    }

    private double getSpaghetti2D(int var0, int var1, int var2) {
        double var3 = this.spaghetti2DRarityModulator.getValue(var0 * 2, var1, var2 * 2);
        double var5 = b.getSphaghettiRarity2D(var3);
        double var7 = 0.6;
        double var9 = 1.3;
        double var11 = NoiseUtils.sampleNoiseAndMapToRange(this.spaghetti2DThicknessModulator, var0 * 2, var1, var2 * 2, 0.6, 1.3);
        double var13 = NoiseSampler.sampleWithRarity(this.spaghetti2DNoiseSource, var0, var1, var2, var5);
        double var15 = 0.083;
        double var17 = Math.abs(var5 * var13) - 0.083 * var11;
        int var19 = this.noiseSettings.getMinCellY();
        int var20 = 8;
        double var21 = NoiseUtils.sampleNoiseAndMapToRange(this.spaghetti2DElevationModulator, var0, 0.0, var2, var19, 8.0);
        double var23 = Math.abs(var21 - (double)var1 / 8.0) - 1.0 * var11;
        var23 = var23 * var23 * var23;
        return NoiseSampler.clampToUnit(Math.max(var23, var17));
    }

    private double spaghettiRoughness(int var0, int var1, int var2) {
        double var3 = NoiseUtils.sampleNoiseAndMapToRange(this.spaghettiRoughnessModulator, var0, var1, var2, 0.0, 0.1);
        return (0.4 - Math.abs(this.spaghettiRoughnessNoise.getValue(var0, var1, var2))) * var3;
    }

    public PositionalRandomFactory getDepthBasedLayerPositionalRandom() {
        return this.depthBasedLayerPositionalRandomFactory;
    }

    private static double clampToUnit(double var0) {
        return MathHelper.clamp(var0, -1.0, 1.0);
    }

    private static double sampleWithRarity(NoiseGeneratorNormal var0, double var1, double var3, double var5, double var7) {
        return var0.getValue(var1 / var7, var3 / var7, var5 / var7);
    }

    private boolean isVein(double var0, double var2) {
        double var6;
        double var4 = Math.abs(1.0 * var0) - (double)0.08f;
        return Math.max(var4, var6 = Math.abs(1.0 * var2) - (double)0.08f) < 0.0;
    }

    @Nullable
    private c getVeinType(double var0, int var2) {
        c var3 = var0 > 0.0 ? c.COPPER : c.IRON;
        int var4 = var3.maxY - var2;
        int var5 = var2 - var3.minY;
        if (var5 < 0 || var4 < 0) {
            return null;
        }
        int var6 = Math.min(var4, var5);
        double var7 = MathHelper.clampedMap((double)var6, 0.0, 20.0, -0.2, 0.0);
        if (Math.abs(var0) + var7 < (double)0.4f) {
            return null;
        }
        return var3;
    }

    static final class c
    extends Enum<c> {
        public static final /* enum */ c COPPER = new c(Blocks.COPPER_ORE.defaultBlockState(), Blocks.RAW_COPPER_BLOCK.defaultBlockState(), Blocks.GRANITE.defaultBlockState(), 0, 50);
        public static final /* enum */ c IRON = new c(Blocks.DEEPSLATE_IRON_ORE.defaultBlockState(), Blocks.RAW_IRON_BLOCK.defaultBlockState(), Blocks.TUFF.defaultBlockState(), -60, -8);
        final IBlockData ore;
        final IBlockData rawOreBlock;
        final IBlockData filler;
        final int minY;
        final int maxY;
        private static final /* synthetic */ c[] h;

        public static c[] values() {
            return (c[])h.clone();
        }

        public static c valueOf(String var0) {
            return Enum.valueOf(c.class, var0);
        }

        private c(IBlockData var2, IBlockData var3, IBlockData var4, int var5, int var6) {
            this.ore = var2;
            this.rawOreBlock = var3;
            this.filler = var4;
            this.minY = var5;
            this.maxY = var6;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{COPPER, IRON};
        }

        static {
            h = c.a();
        }
    }

    public record a(double shiftedX, double shiftedZ, double continentalness, double weirdness, double erosion, TerrainInfo terrainInfo) {
    }

    static final class b {
        private b() {
        }

        static double getSphaghettiRarity2D(double var0) {
            if (var0 < -0.75) {
                return 0.5;
            }
            if (var0 < -0.5) {
                return 0.75;
            }
            if (var0 < 0.5) {
                return 1.0;
            }
            if (var0 < 0.75) {
                return 2.0;
            }
            return 3.0;
        }

        static double getSpaghettiRarity3D(double var0) {
            if (var0 < -0.5) {
                return 0.75;
            }
            if (var0 < 0.0) {
                return 1.0;
            }
            if (var0 < 0.5) {
                return 1.5;
            }
            return 2.0;
        }
    }
}

