/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;

public class NoiseChunk {
    private final NoiseSampler sampler;
    final NoiseSettings noiseSettings;
    final int cellCountXZ;
    final int cellCountY;
    final int cellNoiseMinY;
    final int firstCellX;
    final int firstCellZ;
    private final int firstNoiseX;
    private final int firstNoiseZ;
    final List<d> interpolators;
    private final NoiseSampler.a[][] noiseData;
    private final Long2IntMap preliminarySurfaceLevel = new Long2IntOpenHashMap();
    private final Aquifer aquifer;
    private final a baseNoise;
    private final a oreVeins;
    private final Blender blender;

    public static NoiseChunk forChunk(IChunkAccess var0, NoiseSampler var1, Supplier<c> var2, GeneratorSettingBase var3, Aquifer.a var4, Blender var5) {
        ChunkCoordIntPair var6 = var0.getPos();
        NoiseSettings var7 = var3.noiseSettings();
        int var8 = Math.max(var7.minY(), var0.getMinBuildHeight());
        int var9 = Math.min(var7.minY() + var7.height(), var0.getMaxBuildHeight());
        int var10 = MathHelper.intFloorDiv(var8, var7.getCellHeight());
        int var11 = MathHelper.intFloorDiv(var9 - var8, var7.getCellHeight());
        return new NoiseChunk(16 / var7.getCellWidth(), var11, var10, var1, var6.getMinBlockX(), var6.getMinBlockZ(), var2.get(), var3, var4, var5);
    }

    public static NoiseChunk forColumn(int var02, int var12, int var22, int var3, NoiseSampler var4, GeneratorSettingBase var5, Aquifer.a var6) {
        return new NoiseChunk(1, var3, var22, var4, var02, var12, (var0, var1, var2) -> 0.0, var5, var6, Blender.empty());
    }

    private NoiseChunk(int var0, int var1, int var2, NoiseSampler var3, int var4, int var5, c var6, GeneratorSettingBase var7, Aquifer.a var8, Blender var9) {
        this.noiseSettings = var7.noiseSettings();
        this.cellCountXZ = var0;
        this.cellCountY = var1;
        this.cellNoiseMinY = var2;
        this.sampler = var3;
        int var10 = this.noiseSettings.getCellWidth();
        this.firstCellX = Math.floorDiv(var4, var10);
        this.firstCellZ = Math.floorDiv(var5, var10);
        this.interpolators = Lists.newArrayList();
        this.firstNoiseX = QuartPos.fromBlock(var4);
        this.firstNoiseZ = QuartPos.fromBlock(var5);
        int var11 = QuartPos.fromBlock(var0 * var10);
        this.noiseData = new NoiseSampler.a[var11 + 1][];
        this.blender = var9;
        for (int var12 = 0; var12 <= var11; ++var12) {
            int var13 = this.firstNoiseX + var12;
            this.noiseData[var12] = new NoiseSampler.a[var11 + 1];
            for (int var14 = 0; var14 <= var11; ++var14) {
                int var15 = this.firstNoiseZ + var14;
                this.noiseData[var12][var14] = var3.noiseData(var13, var15, var9);
            }
        }
        this.aquifer = var3.createAquifer(this, var4, var5, var2, var1, var8, var7.isAquifersEnabled());
        this.baseNoise = var3.makeBaseNoiseFiller(this, var6, var7.isNoodleCavesEnabled());
        this.oreVeins = var3.makeOreVeinifier(this, var7.isOreVeinsEnabled());
    }

    public NoiseSampler.a noiseData(int var0, int var1) {
        return this.noiseData[var0 - this.firstNoiseX][var1 - this.firstNoiseZ];
    }

    public int preliminarySurfaceLevel(int var0, int var1) {
        return this.preliminarySurfaceLevel.computeIfAbsent(ChunkCoordIntPair.asLong(QuartPos.fromBlock(var0), QuartPos.fromBlock(var1)), this::computePreliminarySurfaceLevel);
    }

    private int computePreliminarySurfaceLevel(long var0) {
        int var2 = ChunkCoordIntPair.getX(var0);
        int var3 = ChunkCoordIntPair.getZ(var0);
        int var4 = var2 - this.firstNoiseX;
        int var5 = var3 - this.firstNoiseZ;
        int var6 = this.noiseData.length;
        TerrainInfo var7 = var4 >= 0 && var5 >= 0 && var4 < var6 && var5 < var6 ? this.noiseData[var4][var5].terrainInfo() : this.sampler.noiseData(var2, var3, this.blender).terrainInfo();
        return this.sampler.getPreliminarySurfaceLevel(QuartPos.toBlock(var2), QuartPos.toBlock(var3), var7);
    }

    protected d createNoiseInterpolator(c var0) {
        return new d(var0);
    }

    public Blender getBlender() {
        return this.blender;
    }

    public void initializeForFirstCellX() {
        this.interpolators.forEach(var0 -> var0.initializeForFirstCellX());
    }

    public void advanceCellX(int var0) {
        this.interpolators.forEach(var1 -> var1.advanceCellX(var0));
    }

    public void selectCellYZ(int var0, int var1) {
        this.interpolators.forEach(var2 -> var2.selectCellYZ(var0, var1));
    }

    public void updateForY(double var0) {
        this.interpolators.forEach(var2 -> var2.updateForY(var0));
    }

    public void updateForX(double var0) {
        this.interpolators.forEach(var2 -> var2.updateForX(var0));
    }

    public void updateForZ(double var0) {
        this.interpolators.forEach(var2 -> var2.updateForZ(var0));
    }

    public void swapSlices() {
        this.interpolators.forEach(d::swapSlices);
    }

    public Aquifer aquifer() {
        return this.aquifer;
    }

    @Nullable
    protected IBlockData updateNoiseAndGenerateBaseState(int var0, int var1, int var2) {
        return this.baseNoise.calculate(var0, var1, var2);
    }

    @Nullable
    protected IBlockData oreVeinify(int var0, int var1, int var2) {
        return this.oreVeins.calculate(var0, var1, var2);
    }

    @FunctionalInterface
    public static interface c {
        public double calculateNoise(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface a {
        @Nullable
        public IBlockData calculate(int var1, int var2, int var3);
    }

    public class d
    implements e {
        private double[][] slice0;
        private double[][] slice1;
        private final c noiseFiller;
        private double noise000;
        private double noise001;
        private double noise100;
        private double noise101;
        private double noise010;
        private double noise011;
        private double noise110;
        private double noise111;
        private double valueXZ00;
        private double valueXZ10;
        private double valueXZ01;
        private double valueXZ11;
        private double valueZ0;
        private double valueZ1;
        private double value;

        d(c var1) {
            this.noiseFiller = var1;
            this.slice0 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            this.slice1 = this.allocateSlice(NoiseChunk.this.cellCountY, NoiseChunk.this.cellCountXZ);
            NoiseChunk.this.interpolators.add(this);
        }

        private double[][] allocateSlice(int var0, int var1) {
            int var2 = var1 + 1;
            int var3 = var0 + 1;
            double[][] var4 = new double[var2][var3];
            for (int var5 = 0; var5 < var2; ++var5) {
                var4[var5] = new double[var3];
            }
            return var4;
        }

        void initializeForFirstCellX() {
            this.fillSlice(this.slice0, NoiseChunk.this.firstCellX);
        }

        void advanceCellX(int var0) {
            this.fillSlice(this.slice1, NoiseChunk.this.firstCellX + var0 + 1);
        }

        private void fillSlice(double[][] var0, int var1) {
            int var2 = NoiseChunk.this.noiseSettings.getCellWidth();
            int var3 = NoiseChunk.this.noiseSettings.getCellHeight();
            for (int var4 = 0; var4 < NoiseChunk.this.cellCountXZ + 1; ++var4) {
                int var5 = NoiseChunk.this.firstCellZ + var4;
                for (int var6 = 0; var6 < NoiseChunk.this.cellCountY + 1; ++var6) {
                    double var9;
                    int var7 = var6 + NoiseChunk.this.cellNoiseMinY;
                    int var8 = var7 * var3;
                    var0[var4][var6] = var9 = this.noiseFiller.calculateNoise(var1 * var2, var8, var5 * var2);
                }
            }
        }

        void selectCellYZ(int var0, int var1) {
            this.noise000 = this.slice0[var1][var0];
            this.noise001 = this.slice0[var1 + 1][var0];
            this.noise100 = this.slice1[var1][var0];
            this.noise101 = this.slice1[var1 + 1][var0];
            this.noise010 = this.slice0[var1][var0 + 1];
            this.noise011 = this.slice0[var1 + 1][var0 + 1];
            this.noise110 = this.slice1[var1][var0 + 1];
            this.noise111 = this.slice1[var1 + 1][var0 + 1];
        }

        void updateForY(double var0) {
            this.valueXZ00 = MathHelper.lerp(var0, this.noise000, this.noise010);
            this.valueXZ10 = MathHelper.lerp(var0, this.noise100, this.noise110);
            this.valueXZ01 = MathHelper.lerp(var0, this.noise001, this.noise011);
            this.valueXZ11 = MathHelper.lerp(var0, this.noise101, this.noise111);
        }

        void updateForX(double var0) {
            this.valueZ0 = MathHelper.lerp(var0, this.valueXZ00, this.valueXZ10);
            this.valueZ1 = MathHelper.lerp(var0, this.valueXZ01, this.valueXZ11);
        }

        void updateForZ(double var0) {
            this.value = MathHelper.lerp(var0, this.valueZ0, this.valueZ1);
        }

        @Override
        public double sample() {
            return this.value;
        }

        private void swapSlices() {
            double[][] var0 = this.slice0;
            this.slice0 = this.slice1;
            this.slice1 = var0;
        }
    }

    @FunctionalInterface
    public static interface e {
        public double sample();
    }

    @FunctionalInterface
    public static interface b {
        public e instantiate(NoiseChunk var1);
    }
}

