/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;

public class MobSpawnerPhantom
implements MobSpawner {
    private int nextTick;

    @Override
    public int tick(WorldServer var0, boolean var1, boolean var2) {
        if (!var1) {
            return 0;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA)) {
            return 0;
        }
        Random var3 = var0.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += (60 + var3.nextInt(60)) * 20;
        if (var0.getSkyDarken() < 5 && var0.dimensionType().hasSkyLight()) {
            return 0;
        }
        int var4 = 0;
        for (EntityHuman entityHuman : var0.players()) {
            Fluid var14;
            IBlockData var13;
            BlockPosition var12;
            DifficultyDamageScaler var8;
            if (entityHuman.isSpectator()) continue;
            BlockPosition var7 = entityHuman.blockPosition();
            if (var0.dimensionType().hasSkyLight() && (var7.getY() < var0.getSeaLevel() || !var0.canSeeSky(var7)) || !(var8 = var0.getCurrentDifficultyAt(var7)).isHarderThan(var3.nextFloat() * 3.0f)) continue;
            ServerStatisticManager var9 = ((EntityPlayer)entityHuman).getStats();
            int var10 = MathHelper.clamp(var9.getValue(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST)), 1, Integer.MAX_VALUE);
            int var11 = 24000;
            if (var3.nextInt(var10) < 72000 || !SpawnerCreature.isValidEmptySpawnBlock(var0, var12 = var7.above(20 + var3.nextInt(15)).east(-10 + var3.nextInt(21)).south(-10 + var3.nextInt(21)), var13 = var0.getBlockState(var12), var14 = var0.getFluidState(var12), EntityTypes.PHANTOM)) continue;
            GroupDataEntity var15 = null;
            int var16 = 1 + var3.nextInt(var8.getDifficulty().getId() + 1);
            for (int var17 = 0; var17 < var16; ++var17) {
                EntityPhantom var18 = EntityTypes.PHANTOM.create(var0);
                var18.moveTo(var12, 0.0f, 0.0f);
                var15 = var18.finalizeSpawn(var0, var8, EnumMobSpawn.NATURAL, var15, null);
                var0.addFreshEntityWithPassengers(var18);
            }
            var4 += var16;
        }
        return var4;
    }
}

