/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.commons.lang3.mutable.MutableDouble;

public interface Aquifer {
    public static Aquifer create(NoiseChunk var0, ChunkCoordIntPair var1, NoiseGeneratorNormal var2, NoiseGeneratorNormal var3, NoiseGeneratorNormal var4, NoiseGeneratorNormal var5, PositionalRandomFactory var6, int var7, int var8, a var9) {
        return new c(var0, var1, var2, var3, var4, var5, var6, var7, var8, var9);
    }

    public static Aquifer createDisabled(final a var0) {
        return new Aquifer(){

            @Override
            @Nullable
            public IBlockData computeSubstance(int var02, int var1, int var2, double var3, double var5) {
                if (var5 > 0.0) {
                    return null;
                }
                return var0.computeFluid(var02, var1, var2).at(var1);
            }

            @Override
            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
    }

    @Nullable
    public IBlockData computeSubstance(int var1, int var2, int var3, double var4, double var6);

    public boolean shouldScheduleFluidUpdate();

    public static class c
    implements Aquifer,
    a {
        private static final int X_RANGE = 10;
        private static final int Y_RANGE = 9;
        private static final int Z_RANGE = 10;
        private static final int X_SEPARATION = 6;
        private static final int Y_SEPARATION = 3;
        private static final int Z_SEPARATION = 6;
        private static final int X_SPACING = 16;
        private static final int Y_SPACING = 12;
        private static final int Z_SPACING = 16;
        private static final int MAX_REASONABLE_DISTANCE_TO_AQUIFER_CENTER = 11;
        private static final double FLOWING_UPDATE_SIMULARITY = c.similarity(MathHelper.square(10), MathHelper.square(12));
        private final NoiseChunk noiseChunk;
        private final NoiseGeneratorNormal barrierNoise;
        private final NoiseGeneratorNormal fluidLevelFloodednessNoise;
        private final NoiseGeneratorNormal fluidLevelSpreadNoise;
        private final NoiseGeneratorNormal lavaNoise;
        private final PositionalRandomFactory positionalRandomFactory;
        private final b[] aquiferCache;
        private final long[] aquiferLocationCache;
        private final a globalFluidPicker;
        private boolean shouldScheduleFluidUpdate;
        private final int minGridX;
        private final int minGridY;
        private final int minGridZ;
        private final int gridSizeX;
        private final int gridSizeZ;
        private static final int[][] SURFACE_SAMPLING_OFFSETS_IN_CHUNKS = new int[][]{{-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {-3, 0}, {-2, 0}, {-1, 0}, {0, 0}, {1, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}};

        c(NoiseChunk var0, ChunkCoordIntPair var1, NoiseGeneratorNormal var2, NoiseGeneratorNormal var3, NoiseGeneratorNormal var4, NoiseGeneratorNormal var5, PositionalRandomFactory var6, int var7, int var8, a var9) {
            this.noiseChunk = var0;
            this.barrierNoise = var2;
            this.fluidLevelFloodednessNoise = var3;
            this.fluidLevelSpreadNoise = var4;
            this.lavaNoise = var5;
            this.positionalRandomFactory = var6;
            this.minGridX = this.gridX(var1.getMinBlockX()) - 1;
            this.globalFluidPicker = var9;
            int var10 = this.gridX(var1.getMaxBlockX()) + 1;
            this.gridSizeX = var10 - this.minGridX + 1;
            this.minGridY = this.gridY(var7) - 1;
            int var11 = this.gridY(var7 + var8) + 1;
            int var12 = var11 - this.minGridY + 1;
            this.minGridZ = this.gridZ(var1.getMinBlockZ()) - 1;
            int var13 = this.gridZ(var1.getMaxBlockZ()) + 1;
            this.gridSizeZ = var13 - this.minGridZ + 1;
            int var14 = this.gridSizeX * var12 * this.gridSizeZ;
            this.aquiferCache = new b[var14];
            this.aquiferLocationCache = new long[var14];
            Arrays.fill(this.aquiferLocationCache, Long.MAX_VALUE);
        }

        private int getIndex(int var0, int var1, int var2) {
            int var3 = var0 - this.minGridX;
            int var4 = var1 - this.minGridY;
            int var5 = var2 - this.minGridZ;
            return (var4 * this.gridSizeZ + var5) * this.gridSizeX + var3;
        }

        @Override
        @Nullable
        public IBlockData computeSubstance(int var0, int var1, int var2, double var3, double var5) {
            if (var3 <= -64.0) {
                return this.globalFluidPicker.computeFluid(var0, var1, var2).at(var1);
            }
            if (var5 <= 0.0) {
                boolean var10;
                double var7;
                IBlockData var9;
                b var11 = this.globalFluidPicker.computeFluid(var0, var1, var2);
                if (var11.at(var1).is(Blocks.LAVA)) {
                    var9 = Blocks.LAVA.defaultBlockState();
                    var7 = 0.0;
                    var10 = false;
                } else {
                    int var12 = Math.floorDiv(var0 - 5, 16);
                    int var13 = Math.floorDiv(var1 + 1, 12);
                    int var14 = Math.floorDiv(var2 - 5, 16);
                    int var15 = Integer.MAX_VALUE;
                    int var16 = Integer.MAX_VALUE;
                    int var17 = Integer.MAX_VALUE;
                    long var18 = 0L;
                    long var20 = 0L;
                    long var22 = 0L;
                    for (int var24 = 0; var24 <= 1; ++var24) {
                        for (int var25 = -1; var25 <= 1; ++var25) {
                            for (int var26 = 0; var26 <= 1; ++var26) {
                                long var31;
                                int var27 = var12 + var24;
                                int var28 = var13 + var25;
                                int var29 = var14 + var26;
                                int var30 = this.getIndex(var27, var28, var29);
                                long var33 = this.aquiferLocationCache[var30];
                                if (var33 != Long.MAX_VALUE) {
                                    var31 = var33;
                                } else {
                                    RandomSource var35 = this.positionalRandomFactory.at(var27, var28, var29);
                                    this.aquiferLocationCache[var30] = var31 = BlockPosition.asLong(var27 * 16 + var35.nextInt(10), var28 * 12 + var35.nextInt(9), var29 * 16 + var35.nextInt(10));
                                }
                                int var35 = BlockPosition.getX(var31) - var0;
                                int var36 = BlockPosition.getY(var31) - var1;
                                int var37 = BlockPosition.getZ(var31) - var2;
                                int var38 = var35 * var35 + var36 * var36 + var37 * var37;
                                if (var15 >= var38) {
                                    var22 = var20;
                                    var20 = var18;
                                    var18 = var31;
                                    var17 = var16;
                                    var16 = var15;
                                    var15 = var38;
                                    continue;
                                }
                                if (var16 >= var38) {
                                    var22 = var20;
                                    var20 = var31;
                                    var17 = var16;
                                    var16 = var38;
                                    continue;
                                }
                                if (var17 < var38) continue;
                                var22 = var31;
                                var17 = var38;
                            }
                        }
                    }
                    b var24 = this.getAquiferStatus(var18);
                    b var25 = this.getAquiferStatus(var20);
                    b var26 = this.getAquiferStatus(var22);
                    double var27 = c.similarity(var15, var16);
                    double var29 = c.similarity(var15, var17);
                    double var31 = c.similarity(var16, var17);
                    boolean bl = var10 = var27 >= FLOWING_UPDATE_SIMULARITY;
                    if (var24.at(var1).is(Blocks.WATER) && this.globalFluidPicker.computeFluid(var0, var1 - 1, var2).at(var1 - 1).is(Blocks.LAVA)) {
                        var7 = 1.0;
                    } else if (var27 > -1.0) {
                        MutableDouble var33 = new MutableDouble(Double.NaN);
                        double var34 = this.calculatePressure(var0, var1, var2, var33, var24, var25);
                        double var36 = this.calculatePressure(var0, var1, var2, var33, var24, var26);
                        double var38 = this.calculatePressure(var0, var1, var2, var33, var25, var26);
                        double var40 = Math.max(0.0, var27);
                        double var42 = Math.max(0.0, var29);
                        double var44 = Math.max(0.0, var31);
                        double var46 = 2.0 * var40 * Math.max(var34, Math.max(var36 * var42, var38 * var44));
                        var7 = Math.max(0.0, var46);
                    } else {
                        var7 = 0.0;
                    }
                    var9 = var24.at(var1);
                }
                if (var5 + var7 <= 0.0) {
                    this.shouldScheduleFluidUpdate = var10;
                    return var9;
                }
            }
            this.shouldScheduleFluidUpdate = false;
            return null;
        }

        @Override
        public boolean shouldScheduleFluidUpdate() {
            return this.shouldScheduleFluidUpdate;
        }

        private static double similarity(int var0, int var1) {
            double var2 = 25.0;
            return 1.0 - (double)Math.abs(var1 - var0) / 25.0;
        }

        private double calculatePressure(int var0, int var1, int var2, MutableDouble var3, b var4, b var5) {
            double var31;
            IBlockData var6 = var4.at(var1);
            IBlockData var7 = var5.at(var1);
            if (var6.is(Blocks.LAVA) && var7.is(Blocks.WATER) || var6.is(Blocks.WATER) && var7.is(Blocks.LAVA)) {
                return 1.0;
            }
            int var8 = Math.abs(var4.fluidLevel - var5.fluidLevel);
            if (var8 == 0) {
                return 0.0;
            }
            double var9 = 0.5 * (double)(var4.fluidLevel + var5.fluidLevel);
            double var11 = (double)var1 + 0.5 - var9;
            double var13 = (double)var8 / 2.0;
            double var15 = 0.0;
            double var17 = 2.5;
            double var19 = 1.5;
            double var21 = 3.0;
            double var23 = 10.0;
            double var25 = 3.0;
            double var27 = var13 - Math.abs(var11);
            double var29 = var11 > 0.0 ? ((var31 = 0.0 + var27) > 0.0 ? var31 / 1.5 : var31 / 2.5) : ((var31 = 3.0 + var27) > 0.0 ? var31 / 3.0 : var31 / 10.0);
            if (var29 < -2.0 || var29 > 2.0) {
                return var29;
            }
            var31 = var3.getValue();
            if (Double.isNaN(var31)) {
                double var33 = 0.5;
                double var35 = this.barrierNoise.getValue(var0, (double)var1 * 0.5, var2);
                var3.setValue(var35);
                return var35 + var29;
            }
            return var31 + var29;
        }

        private int gridX(int var0) {
            return Math.floorDiv(var0, 16);
        }

        private int gridY(int var0) {
            return Math.floorDiv(var0, 12);
        }

        private int gridZ(int var0) {
            return Math.floorDiv(var0, 16);
        }

        private b getAquiferStatus(long var0) {
            b var10;
            int var7;
            int var6;
            int var2 = BlockPosition.getX(var0);
            int var3 = BlockPosition.getY(var0);
            int var4 = BlockPosition.getZ(var0);
            int var5 = this.gridX(var2);
            int var8 = this.getIndex(var5, var6 = this.gridY(var3), var7 = this.gridZ(var4));
            b var9 = this.aquiferCache[var8];
            if (var9 != null) {
                return var9;
            }
            this.aquiferCache[var8] = var10 = this.computeFluid(var2, var3, var4);
            return var10;
        }

        @Override
        public b computeFluid(int var0, int var1, int var2) {
            double var16;
            b var3 = this.globalFluidPicker.computeFluid(var0, var1, var2);
            int var4 = Integer.MAX_VALUE;
            int var5 = var1 + 12;
            int var6 = var1 - 12;
            boolean var7 = false;
            for (int[] var11 : SURFACE_SAMPLING_OFFSETS_IN_CHUNKS) {
                b var18;
                boolean var17;
                boolean var162;
                int var12 = var0 + SectionPosition.sectionToBlockCoord(var11[0]);
                int var13 = var2 + SectionPosition.sectionToBlockCoord(var11[1]);
                int var14 = this.noiseChunk.preliminarySurfaceLevel(var12, var13);
                int var15 = var14 + 8;
                boolean bl = var162 = var11[0] == 0 && var11[1] == 0;
                if (var162 && var6 > var15) {
                    return var3;
                }
                boolean bl2 = var17 = var5 > var15;
                if ((var17 || var162) && !(var18 = this.globalFluidPicker.computeFluid(var12, var15, var13)).at(var15).isAir()) {
                    if (var162) {
                        var7 = true;
                    }
                    if (var17) {
                        return var18;
                    }
                }
                var4 = Math.min(var4, var14);
            }
            int var8 = var4 + 8 - var1;
            int var9 = 64;
            double var10 = var7 ? MathHelper.clampedMap((double)var8, 0.0, 64.0, 1.0, 0.0) : 0.0;
            double var12 = 0.67;
            double var14 = MathHelper.clamp(this.fluidLevelFloodednessNoise.getValue(var0, (double)var1 * 0.67, var2), -1.0, 1.0);
            if (var14 > (var16 = MathHelper.map(var10, 1.0, 0.0, -0.3, 0.8))) {
                return var3;
            }
            double var18 = MathHelper.map(var10, 1.0, 0.0, -0.8, 0.4);
            if (var14 <= var18) {
                return new b(DimensionManager.WAY_BELOW_MIN_Y, var3.fluidType);
            }
            int var20 = 16;
            int var21 = 40;
            int var22 = Math.floorDiv(var0, 16);
            int var23 = Math.floorDiv(var1, 40);
            int var24 = Math.floorDiv(var2, 16);
            int var25 = var23 * 40 + 20;
            int var26 = 10;
            double var27 = this.fluidLevelSpreadNoise.getValue(var22, (double)var23 / 1.4, var24) * 10.0;
            int var29 = MathHelper.quantize(var27, 3);
            int var30 = var25 + var29;
            int var31 = Math.min(var4, var30);
            IBlockData var32 = this.getFluidType(var0, var1, var2, var3, var30);
            return new b(var31, var32);
        }

        private IBlockData getFluidType(int var0, int var1, int var2, b var3, int var4) {
            if (var4 <= -10) {
                int var9;
                int var8;
                int var5 = 64;
                int var6 = 40;
                int var7 = Math.floorDiv(var0, 64);
                double var10 = this.lavaNoise.getValue(var7, var8 = Math.floorDiv(var1, 40), var9 = Math.floorDiv(var2, 64));
                if (Math.abs(var10) > 0.3) {
                    return Blocks.LAVA.defaultBlockState();
                }
            }
            return var3.fluidType;
        }
    }

    public static interface a {
        public b computeFluid(int var1, int var2, int var3);
    }

    public static final class b {
        final int fluidLevel;
        final IBlockData fluidType;

        public b(int var0, IBlockData var1) {
            this.fluidLevel = var0;
            this.fluidType = var1;
        }

        public IBlockData at(int var0) {
            return var0 < this.fluidLevel ? this.fluidType : Blocks.AIR.defaultBlockState();
        }
    }
}

