/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.PositionSourceType;

public class EntityPositionSource
implements PositionSource {
    public static final Codec<EntityPositionSource> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.INT.fieldOf("source_entity_id").forGetter(var0 -> var0.sourceEntityId)).apply((Applicative)var02, EntityPositionSource::new));
    final int sourceEntityId;
    private Optional<Entity> sourceEntity = Optional.empty();

    public EntityPositionSource(int var0) {
        this.sourceEntityId = var0;
    }

    @Override
    public Optional<BlockPosition> getPosition(World var0) {
        if (!this.sourceEntity.isPresent()) {
            this.sourceEntity = Optional.ofNullable(var0.getEntity(this.sourceEntityId));
        }
        return this.sourceEntity.map(Entity::blockPosition);
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.ENTITY;
    }

    public static class a
    implements PositionSourceType<EntityPositionSource> {
        @Override
        public EntityPositionSource read(PacketDataSerializer var0) {
            return new EntityPositionSource(var0.readVarInt());
        }

        @Override
        public void write(PacketDataSerializer var0, EntityPositionSource var1) {
            var0.writeVarInt(var1.sourceEntityId);
        }

        @Override
        public Codec<EntityPositionSource> codec() {
            return CODEC;
        }

        @Override
        public /* synthetic */ PositionSource read(PacketDataSerializer packetDataSerializer) {
            return this.read(packetDataSerializer);
        }
    }
}

