/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.RegistryID;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;

public class DataPaletteHash<T>
implements DataPalette<T> {
    private final Registry<T> registry;
    private final RegistryID<T> values;
    private final DataPaletteExpandable<T> resizeHandler;
    private final int bits;

    public DataPaletteHash(Registry<T> var0, int var1, DataPaletteExpandable<T> var2, List<T> var3) {
        this(var0, var1, var2);
        var3.forEach(this.values::add);
    }

    public DataPaletteHash(Registry<T> var0, int var1, DataPaletteExpandable<T> var2) {
        this(var0, var1, var2, RegistryID.create(1 << var1));
    }

    private DataPaletteHash(Registry<T> var0, int var1, DataPaletteExpandable<T> var2, RegistryID<T> var3) {
        this.registry = var0;
        this.bits = var1;
        this.resizeHandler = var2;
        this.values = var3;
    }

    public static <A> DataPalette<A> create(int var0, Registry<A> var1, DataPaletteExpandable<A> var2, List<A> var3) {
        return new DataPaletteHash<A>(var1, var0, var2, var3);
    }

    @Override
    public int idFor(T var0) {
        int var1 = this.values.getId(var0);
        if (var1 == -1 && (var1 = this.values.add(var0)) >= 1 << this.bits) {
            var1 = this.resizeHandler.onResize(this.bits + 1, var0);
        }
        return var1;
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            if (!var0.test(this.values.byId(var1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int var0) {
        T var1 = this.values.byId(var0);
        if (var1 == null) {
            throw new MissingPaletteEntryException(var0);
        }
        return var1;
    }

    @Override
    public void read(PacketDataSerializer var0) {
        this.values.clear();
        int var1 = var0.readVarInt();
        for (int var2 = 0; var2 < var1; ++var2) {
            this.values.add(this.registry.byId(var0.readVarInt()));
        }
    }

    @Override
    public void write(PacketDataSerializer var0) {
        int var1 = this.getSize();
        var0.writeVarInt(var1);
        for (int var2 = 0; var2 < var1; ++var2) {
            var0.writeVarInt(this.registry.getId(this.values.byId(var2)));
        }
    }

    @Override
    public int getSerializedSize() {
        int var0 = PacketDataSerializer.getVarIntSize(this.getSize());
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            var0 += PacketDataSerializer.getVarIntSize(this.registry.getId(this.values.byId(var1)));
        }
        return var0;
    }

    public List<T> getEntries() {
        ArrayList var0 = new ArrayList();
        this.values.iterator().forEachRemaining(var0::add);
        return var0;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public DataPalette<T> copy() {
        return new DataPaletteHash<T>(this.registry, this.bits, this.resizeHandler, this.values.copy());
    }
}

